/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.namespace;

import it.grid.storm.config.ConfigReader;
import it.grid.storm.config.Configuration;
import it.grid.storm.namespace.Namespace;
import it.grid.storm.namespace.NamespaceInterface;
import it.grid.storm.namespace.config.NamespaceLoader;
import it.grid.storm.namespace.config.NamespaceParser;
import it.grid.storm.namespace.config.xml.XMLNamespaceLoader;
import it.grid.storm.namespace.config.xml.XMLNamespaceParser;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamespaceDirector {
    private static final Logger log = LoggerFactory.getLogger(NamespaceDirector.class);
    private static NamespaceInterface namespaceIstance = null;
    private static int refreshInSeconds = 5;
    private static String configurationPATH;
    private static String namespaceConfigFileName;
    private static boolean runningMode;
    private static String configurationFileName;
    private Configuration config;
    private static NamespaceLoader loader;
    private static NamespaceParser parser;
    private static boolean initialized;

    public static void initializeDirector(boolean verboseMode, boolean testingMode) {
        log.info("NAMESPACE : Inizializating ...");
        Configuration config = Configuration.getInstance();
        if (testingMode) {
            log.info(" ####################### ");
            log.info(" ####  TESTING MODE #### ");
            log.info(" ####################### ");
            runningMode = testingMode;
            configurationPATH = System.getProperty("user.dir") + File.separator + "etc";
            configurationFileName = configurationPATH + File.separator + "storm_test.properties";
            config.setConfigReader(new ConfigReader(configurationFileName, refreshInSeconds));
            namespaceConfigFileName = config.getNamespaceConfigFilename();
            refreshInSeconds = config.getNamespaceConfigRefreshRateInSeconds();
            loader = new XMLNamespaceLoader(configurationPATH, namespaceConfigFileName, refreshInSeconds, false);
            if (loader instanceof XMLNamespaceLoader) {
                XMLNamespaceLoader xmlLoader = (XMLNamespaceLoader)loader;
                if (!xmlLoader.schemaValidity) {
                    System.out.println("Namespace configuration is not conformant with namespae grammar.");
                    System.out.println("Please validate namespace configuration file.");
                    System.exit(0);
                }
            }
        } else {
            log.info(" +++++++++++++++++++++++ ");
            log.info("    Production Mode      ");
            log.info(" +++++++++++++++++++++++ ");
            runningMode = testingMode;
            configurationPATH = config.namespaceConfigPath();
            namespaceConfigFileName = config.getNamespaceConfigFilename();
            refreshInSeconds = config.getNamespaceConfigRefreshRateInSeconds();
            loader = new XMLNamespaceLoader(configurationPATH, namespaceConfigFileName, refreshInSeconds, verboseMode);
            if (loader instanceof XMLNamespaceLoader) {
                XMLNamespaceLoader xmlLoader = (XMLNamespaceLoader)loader;
                if (!xmlLoader.schemaValidity) {
                    System.out.println("Namespace configuration is not conformant with namespae grammar.");
                    System.out.println("Please validate namespace configuration file.");
                    System.exit(0);
                }
            }
        }
        log.debug("Namespace Configuration PATH : " + configurationPATH);
        log.debug("Namespace Configuration FILENAME : " + namespaceConfigFileName);
        log.debug("Namespace Configuration GLANCE RATE : " + refreshInSeconds);
        parser = new XMLNamespaceParser(loader, verboseMode, testingMode);
        namespaceIstance = new Namespace(parser);
        log.debug("NAMESPACE INITIALIZATION : ... done!");
        initialized = true;
    }

    public static NamespaceInterface getNamespace() {
        if (!initialized) {
            NamespaceDirector.initializeDirector(false, false);
        }
        return namespaceIstance;
    }

    public static NamespaceInterface getNamespace(boolean verboseMode, boolean testingMode) {
        if (!initialized) {
            NamespaceDirector.initializeDirector(verboseMode, testingMode);
        }
        return namespaceIstance;
    }

    public static NamespaceParser getNamespaceParser(boolean verboseMode, boolean testingMode) {
        if (!initialized) {
            NamespaceDirector.initializeDirector(verboseMode, testingMode);
        }
        return parser;
    }

    public static NamespaceLoader getNamespaceLoader(boolean verboseMode, boolean testingMode) {
        if (!initialized) {
            NamespaceDirector.initializeDirector(verboseMode, testingMode);
        }
        return loader;
    }

    public static Logger getLogger() {
        return log;
    }

    static {
        runningMode = false;
        initialized = false;
    }
}

