/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.namespace;

import it.grid.storm.common.GUID;
import it.grid.storm.common.types.PFN;
import it.grid.storm.common.types.StFN;
import it.grid.storm.filesystem.LocalFile;
import it.grid.storm.filesystem.Space;
import it.grid.storm.griduser.AbstractGridUser;
import it.grid.storm.griduser.CannotMapUserException;
import it.grid.storm.griduser.GridUserInterface;
import it.grid.storm.namespace.NamespaceDirector;
import it.grid.storm.namespace.NamespaceException;
import it.grid.storm.namespace.NamespaceInterface;
import it.grid.storm.namespace.StoRI;
import it.grid.storm.namespace.UnapprochableSurlException;
import it.grid.storm.namespace.VirtualFSInterface;
import it.grid.storm.namespace.config.NamespaceParser;
import it.grid.storm.namespace.model.ApproachableRule;
import it.grid.storm.namespace.model.MappingRule;
import it.grid.storm.namespace.model.StoRIType;
import it.grid.storm.namespace.naming.NamespaceUtil;
import it.grid.storm.namespace.naming.SURL;
import it.grid.storm.srm.types.TSURL;
import it.grid.storm.srm.types.TSizeInBytes;
import it.grid.storm.srm.types.TSpaceToken;
import it.grid.storm.srm.types.TTURL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import java.util.Vector;
import org.slf4j.Logger;

public class Namespace
implements NamespaceInterface {
    private static final String SPACE_FILE_NAME_SUFFIX = ".space";
    private static final char SPACE_FILE_NAME_SEPARATOR = '_';
    private final Logger log = NamespaceDirector.getLogger();
    private final NamespaceParser parser;

    public Namespace(NamespaceParser parser) {
        this.parser = parser;
    }

    @Override
    public String getNamespaceVersion() throws NamespaceException {
        return this.parser.getNamespaceVersion();
    }

    @Override
    public Collection<VirtualFSInterface> getAllDefinedVFS() throws NamespaceException {
        return this.parser.getVFSs().values();
    }

    @Override
    public List<VirtualFSInterface> getApproachableVFS(GridUserInterface user) throws NamespaceException {
        return null;
    }

    @Override
    public VirtualFSInterface getDefaultVFS(GridUserInterface user) throws NamespaceException {
        TreeSet<ApproachableRule> appRules = new TreeSet<ApproachableRule>(this.getApproachableRules(user));
        if (appRules.isEmpty()) {
            if (user instanceof AbstractGridUser) {
                this.log.error("No approachable rules found for user with DN='" + user.getDn() + "' and VO = '" + ((AbstractGridUser)user).getVO() + "'");
                throw new NamespaceException("No approachable rules found for user with DN='" + user.getDn() + "' and VO = '" + ((AbstractGridUser)user).getVO() + "'");
            }
            this.log.error("No approachable rules found for user with DN='" + user.getDn() + "' User certificate has not VOMS extension");
            throw new NamespaceException("No approachable rules found for user with DN='" + user.getDn() + "' User certificate has not VOMS extension");
        }
        this.log.debug("Compatible Approachable rules : " + appRules);
        ApproachableRule firstAppRule = appRules.first();
        this.log.debug("Default APP_RULE is the first (in respsect of name): " + firstAppRule);
        VirtualFSInterface vfs = this.getApproachableDefaultVFS(firstAppRule);
        this.log.debug("Default VFS for Space Files : " + vfs);
        return vfs;
    }

    @Override
    public boolean isApproachable(StoRI storageResource, GridUserInterface gridUser) throws NamespaceException {
        return true;
    }

    @Override
    public StoRI resolveStoRIbySURL(TSURL surl, GridUserInterface user) throws IllegalArgumentException, UnapprochableSurlException {
        if (surl == null || user == null) {
            this.log.error("Received null parameters: surl= " + surl + " user=" + user);
            throw new IllegalArgumentException("Received null parameters");
        }
        List<VirtualFSInterface> vfsApproachable = this.getListOfVFS(user);
        StoRI stori = this.resolveStoRIbySURL(surl, vfsApproachable);
        if (stori == null) {
            if (this.isStfnFittingSomewhere(surl)) {
                throw new UnapprochableSurlException("Surl " + surl + " is not approchable by user " + user);
            }
            throw new UnapprochableSurlException("Surl " + surl + " is not managed by this StoRM instance");
        }
        return stori;
    }

    private StoRI resolveStoRIbySURL(TSURL surl, List<VirtualFSInterface> vfsApproachable) throws UnapprochableSurlException {
        this.log.debug("Resolving StoRI from surl " + surl + " on " + vfsApproachable + " VFS");
        return this.resolveStoRIbySURL(surl, vfsApproachable, true);
    }

    @Override
    public StoRI resolveStoRIbySURL(TSURL surl) throws UnapprochableSurlException {
        this.log.debug("Resolving StoRI from surl " + surl + " on any VFS");
        StoRI stori = this.resolveStoRIbySURL(surl, null, false);
        if (stori == null) {
            throw new UnapprochableSurlException("Surl " + surl + " is not managed by this StoRM instance");
        }
        return stori;
    }

    private StoRI resolveStoRIbySURL(TSURL surl, List<VirtualFSInterface> vfsApproachable, boolean withVFSList) {
        if (surl == null || withVFSList && vfsApproachable == null) {
            this.log.error("Unable to perform resolveStoRIbySURL, invalid arguments: surl=" + surl + " withVFSList=" + withVFSList + " vfsApproachable=" + vfsApproachable);
            throw new IllegalArgumentException("Unable to perform getWinnerRule, invalid arguments");
        }
        String stfnStr = surl.sfn().stfn().toString();
        MappingRule winnerRule = this.getWinnerRule(NamespaceUtil.getStFNPath(stfnStr), vfsApproachable, withVFSList);
        if (winnerRule == null) {
            winnerRule = this.getWinnerRule(stfnStr, vfsApproachable, withVFSList);
        }
        StoRI stori = null;
        if (winnerRule != null) {
            this.log.debug("For StFN " + stfnStr + " the winner Rule is " + winnerRule.getRuleName());
            stori = winnerRule.getMappedFS().createFile(NamespaceUtil.extractRelativePath(winnerRule.getStFNRoot(), stfnStr), StoRIType.FILE);
            stori.setStFNRoot(winnerRule.getStFNRoot());
            stori.setMappingRule(winnerRule);
        } else {
            this.log.debug("No MappingRule matches SURL " + surl);
        }
        return stori;
    }

    @Override
    public VirtualFSInterface resolveVFSbySURL(TSURL surl, GridUserInterface user) throws UnapprochableSurlException {
        List<VirtualFSInterface> vfsApproachable = this.getListOfVFS(user);
        VirtualFSInterface vfs = this.resolveVFSbySURL(surl, vfsApproachable);
        if (vfs == null) {
            throw new UnapprochableSurlException("Surl " + surl + " is not approchable by user " + user);
        }
        return vfs;
    }

    private VirtualFSInterface resolveVFSbySURL(TSURL surl, List<VirtualFSInterface> vfsApproachable) {
        MappingRule winnerRule = this.getWinnerRule(NamespaceUtil.getStFNPath(surl.sfn().stfn().toString()), vfsApproachable);
        this.log.debug("For surl " + surl + " the winner Rule is " + winnerRule.getRuleName());
        return this.parser.getVFS(winnerRule.getMappedFS().getAliasName());
    }

    @Override
    public StoRI resolveStoRIbyAbsolutePath(String absolutePath, GridUserInterface user) throws NamespaceException {
        return this.resolveStoRIbyAbsolutePath(absolutePath);
    }

    @Override
    public StoRI resolveStoRIbyAbsolutePath(String absolutePath) throws NamespaceException {
        VirtualFSInterface vfs = this.resolveVFSbyAbsolutePath(absolutePath);
        this.log.debug("VFS retrivied is " + vfs.getAliasName());
        this.log.debug("VFS instance is " + vfs.hashCode());
        String relativePath = NamespaceUtil.extractRelativePath(vfs.getRootPath(), absolutePath);
        StoRI stori = vfs.createFile(relativePath);
        return stori;
    }

    @Override
    public VirtualFSInterface resolveVFSbyAbsolutePath(String absolutePath, GridUserInterface user) throws NamespaceException {
        return this.getWinnerVFS(absolutePath);
    }

    @Override
    public VirtualFSInterface resolveVFSbyRoot(String absolutePath) throws NamespaceException {
        return this.getWinnerVFS(absolutePath);
    }

    @Override
    public VirtualFSInterface resolveVFSbyAbsolutePath(String absolutePath) throws NamespaceException {
        return this.getWinnerVFS(absolutePath);
    }

    @Override
    public StoRI resolveStoRIbyLocalFile(LocalFile file, GridUserInterface user) throws NamespaceException {
        return null;
    }

    @Override
    public StoRI resolveStoRIbyLocalFile(LocalFile file) throws NamespaceException {
        return null;
    }

    @Override
    public VirtualFSInterface resolveVFSbyLocalFile(LocalFile file, GridUserInterface user) throws NamespaceException {
        return null;
    }

    @Override
    public VirtualFSInterface resolveVFSbyLocalFile(LocalFile file) throws NamespaceException {
        return null;
    }

    @Override
    public StoRI resolveStoRIbyStFN(StFN stfn, GridUserInterface user) throws NamespaceException {
        return null;
    }

    @Override
    public StoRI resolveStoRIbyStFN(StFN stfn) throws NamespaceException {
        return null;
    }

    @Override
    public VirtualFSInterface resolveVFSbyStFN(StFN stfn, GridUserInterface user) throws NamespaceException {
        return null;
    }

    @Override
    public VirtualFSInterface resolveVFSbyStFN(StFN stfn) throws NamespaceException {
        return null;
    }

    @Override
    public StoRI resolveStoRIbyPFN(PFN pfn, GridUserInterface user) throws NamespaceException {
        VirtualFSInterface vfs = this.resolveVFSbyPFN(pfn, user);
        String vfsRoot = vfs.getRootPath();
        String relativePath = NamespaceUtil.extractRelativePath(vfsRoot, pfn.getValue());
        StoRI stori = vfs.createFile(relativePath);
        return stori;
    }

    @Override
    public StoRI resolveStoRIbyPFN(PFN pfn) throws NamespaceException {
        VirtualFSInterface vfs = this.resolveVFSbyPFN(pfn);
        String vfsRoot = vfs.getRootPath();
        String relativePath = NamespaceUtil.extractRelativePath(vfsRoot, pfn.getValue());
        StoRI stori = vfs.createFile(relativePath);
        return stori;
    }

    @Override
    public VirtualFSInterface resolveVFSbyPFN(PFN pfn, GridUserInterface user) throws NamespaceException {
        return this.resolveVFSbyPFN(pfn);
    }

    @Override
    public VirtualFSInterface resolveVFSbyPFN(PFN pfn) throws NamespaceException {
        return this.getWinnerVFS(pfn.getValue());
    }

    @Override
    public StoRI resolveStoRIbyTURL(TTURL turl, GridUserInterface user) throws NamespaceException {
        PFN pfn = turl.tfn().pfn();
        return this.resolveStoRIbyPFN(pfn, user);
    }

    @Override
    public StoRI resolveStoRIbyTURL(TTURL turl) throws NamespaceException {
        PFN pfn = turl.tfn().pfn();
        return this.resolveStoRIbyPFN(pfn);
    }

    @Override
    public VirtualFSInterface resolveVFSbyTURL(TTURL turl, GridUserInterface user) throws NamespaceException {
        return null;
    }

    @Override
    public VirtualFSInterface resolveVFSbyTURL(TTURL turl) throws NamespaceException {
        return null;
    }

    @Override
    public StoRI getDefaultSpaceFileForUser(GridUserInterface user) throws NamespaceException {
        return null;
    }

    @Override
    public Space retrieveSpaceByToken(TSizeInBytes totSize, TSpaceToken token) {
        return null;
    }

    public MappingRule getWinnerRule(String stfnPath) {
        this.log.debug("Getting winner rule for StFN path =" + stfnPath + " on any VFS");
        return this.getWinnerRule(stfnPath, null, false);
    }

    private MappingRule getWinnerRule(String stfnPath, List<VirtualFSInterface> vfsApproachable, boolean withVFSList) {
        if (stfnPath == null || stfnPath.trim().isEmpty() || withVFSList && vfsApproachable == null) {
            this.log.error("Unable to perform getWinnerRule, invalid arguments: stfnPath=" + stfnPath + " withVFSList=" + withVFSList + " vfsApproachable=" + vfsApproachable);
            throw new IllegalArgumentException("Unable to perform getWinnerRule, invalid arguments");
        }
        Vector<MappingRule> rules = new Vector<MappingRule>(this.parser.getMappingRules().values());
        MappingRule winnerRule = null;
        int minDistance = Integer.MAX_VALUE;
        for (MappingRule rule : rules) {
            String stfnRoot;
            int distance;
            VirtualFSInterface mappedVFS = rule.getMappedFS();
            if (withVFSList && !vfsApproachable.contains(mappedVFS) || (distance = NamespaceUtil.computeDistanceFromPath(stfnRoot = rule.getStFNRoot(), stfnPath)) >= minDistance || !NamespaceUtil.isEnclosed(stfnRoot, stfnPath)) continue;
            minDistance = distance;
            winnerRule = rule;
        }
        return winnerRule;
    }

    private MappingRule getWinnerRule(String stfnPath, List<VirtualFSInterface> vfsApproachable) {
        this.log.debug("Getting winner rule for StFN path =" + stfnPath + " on " + vfsApproachable + " VFS");
        return this.getWinnerRule(stfnPath, vfsApproachable, true);
    }

    public VirtualFSInterface getWinnerVFS(String absolutePath) throws NamespaceException {
        VirtualFSInterface vfsWinner = null;
        String path = absolutePath;
        Hashtable table = (Hashtable)this.parser.getMapVFS_Root();
        int distance = Integer.MAX_VALUE;
        Enumeration scan = table.keys();
        String vfs_root = null;
        String vfs_root_winner = null;
        boolean found = false;
        String vfsNameWinner = null;
        while (scan.hasMoreElements()) {
            boolean enclosed;
            vfs_root = (String)scan.nextElement();
            int d = NamespaceUtil.computeDistanceFromPath(vfs_root, path);
            this.log.debug("Pondering VFS Root :'" + vfs_root + "' against '" + path + "' DISTANCE = " + d);
            if (d >= distance || !(enclosed = NamespaceUtil.isEnclosed(vfs_root, absolutePath))) continue;
            distance = d;
            vfsWinner = (VirtualFSInterface)table.get(vfs_root);
            vfsNameWinner = vfsWinner.getAliasName();
            vfs_root_winner = vfs_root;
            this.log.debug("Partial winner is " + vfs_root_winner + " (VFS :'" + vfsNameWinner + "'");
            found = true;
        }
        if (!found) {
            this.log.error("Unable to found a VFS compatible with path :'" + absolutePath + "'");
            throw new NamespaceException("Unable to found a VFS compatible with path :'" + absolutePath + "'");
        }
        this.log.debug("VFS winner is " + vfs_root_winner + " (VFS :'" + vfsNameWinner + "'");
        return vfsWinner;
    }

    @Override
    public String makeSpaceFileURI(GridUserInterface user) throws NamespaceException {
        String result = null;
        TreeSet<ApproachableRule> appRules = new TreeSet<ApproachableRule>(this.getApproachableRules(user));
        this.log.debug("Compatible Approachable rules : " + appRules);
        if (appRules.isEmpty()) {
            if (user instanceof AbstractGridUser) {
                this.log.error("No approachable rules found for user with DN='" + user.getDn() + "' and VO = '" + ((AbstractGridUser)user).getVO() + "'");
                throw new NamespaceException("No approachable rules found for user with DN='" + user.getDn() + "' and VO = '" + ((AbstractGridUser)user).getVO() + "'");
            }
            this.log.error("No approachable rules found for user with DN='" + user.getDn() + "' User certificate has not VOMS extension");
            throw new NamespaceException("No approachable rules found for user with DN='" + user.getDn() + "' User certificate has not VOMS extension");
        }
        ApproachableRule firstAppRule = appRules.first();
        this.log.debug("Default APP_RULE is the first (in respsect of name): " + firstAppRule);
        String spacePath = this.getRelativePathForSpaceFile(firstAppRule);
        VirtualFSInterface vfs = this.getApproachableDefaultVFS(firstAppRule);
        this.log.debug("Default VFS for Space Files : " + vfs);
        String rootPath = vfs.getRootPath();
        String spaceFileName = this.makeSpaceFileNameForUser(user);
        result = rootPath + spacePath + "/" + spaceFileName;
        return result;
    }

    public String getRelativePathForSpaceFile(ApproachableRule rule) {
        String result = rule.getSpaceRelativePath();
        if (result == null) {
            result = "/";
        }
        return result;
    }

    public String makeSpaceFileNameForUser(GridUserInterface user) {
        String userName = null;
        try {
            userName = user.getLocalUser().getLocalUserName();
        }
        catch (CannotMapUserException ex) {
            this.log.error("Cannot map user.");
        }
        if (userName == null) {
            userName = "unknown";
        }
        GUID guid = new GUID();
        return userName + '_' + guid + SPACE_FILE_NAME_SUFFIX;
    }

    @Override
    public boolean isSpaceFile(String fileName) throws IllegalArgumentException {
        if (fileName == null) {
            throw new IllegalArgumentException("Unable to check space file name. Invalid arguments: fileName=" + fileName);
        }
        if (!fileName.endsWith(SPACE_FILE_NAME_SUFFIX)) {
            return false;
        }
        if (fileName.indexOf(95) <= 0) {
            return false;
        }
        if (fileName.substring(fileName.indexOf(95) + 1).length() <= SPACE_FILE_NAME_SUFFIX.length()) {
            return false;
        }
        String uuidString = fileName.substring(fileName.indexOf(95) + 1, fileName.lastIndexOf(SPACE_FILE_NAME_SUFFIX));
        try {
            UUID.fromString(uuidString);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public SortedSet<ApproachableRule> getApproachableRules(GridUserInterface user) {
        TreeSet<ApproachableRule> appRules = null;
        Map<String, ApproachableRule> rules = this.parser.getApproachableRules();
        Hashtable<String, ApproachableRule> appRulesUnorderd = null;
        if (rules != null) {
            appRulesUnorderd = new Hashtable<String, ApproachableRule>(this.parser.getApproachableRules());
        }
        appRules = new TreeSet<ApproachableRule>();
        if (appRulesUnorderd != null) {
            ApproachableRule appRule = null;
            for (String key : appRulesUnorderd.keySet()) {
                appRule = appRulesUnorderd.get(key);
                if (!Namespace.matchSubject(appRule, user)) continue;
                appRules.add(appRule);
            }
        }
        return appRules;
    }

    public VirtualFSInterface getApproachableDefaultVFS(ApproachableRule appRule) throws NamespaceException {
        VirtualFSInterface defaultVFS = null;
        String defaultVFSName = null;
        List<VirtualFSInterface> listVFS = appRule.getApproachableVFS();
        if (listVFS != null && !listVFS.isEmpty()) {
            this.log.debug(" VFS List = " + listVFS);
            String vfsName = null;
            for (VirtualFSInterface element : listVFS) {
                if (!element.getAliasName().endsWith("*")) continue;
                vfsName = element.getAliasName().substring(0, element.getAliasName().length() - 1);
                break;
            }
            defaultVFSName = vfsName == null ? listVFS.get(0).getAliasName() : vfsName;
            this.log.debug(" Default VFS detected : '" + defaultVFSName + "'");
            defaultVFS = this.parser.getVFS(defaultVFSName);
            this.log.debug(" VFS Description " + defaultVFS);
            return defaultVFS;
        }
        throw new NamespaceException("No VFS associated to the provided ApproachableRule " + appRule);
    }

    private static boolean matchSubject(ApproachableRule approachableRule, GridUserInterface user) {
        boolean result = true;
        result = approachableRule.match(user);
        return result;
    }

    public List<VirtualFSInterface> getListOfVFS(GridUserInterface gUser) {
        Hashtable<String, ApproachableRule> apprules = new Hashtable<String, ApproachableRule>(this.parser.getApproachableRules());
        LinkedList<VirtualFSInterface> approachVFS = new LinkedList<VirtualFSInterface>();
        for (ApproachableRule appRule : apprules.values()) {
            if (!appRule.match(gUser)) continue;
            approachVFS.addAll(appRule.getApproachableVFS());
        }
        return approachVFS;
    }

    @Override
    public VirtualFSInterface resolveVFSbySpaceToken(TSpaceToken spaceToken) throws NamespaceException {
        return null;
    }

    @Override
    public boolean isStfnFittingSomewhere(String surlString, GridUserInterface user) throws NamespaceException {
        String stfnRoot;
        boolean result = false;
        ArrayList<String> stfnRoots = new ArrayList<String>();
        List<VirtualFSInterface> listVFS = this.getListOfVFS(user);
        Hashtable<String, MappingRule> rules = new Hashtable<String, MappingRule>(this.parser.getMappingRules());
        for (Map.Entry<String, MappingRule> rule : rules.entrySet()) {
            VirtualFSInterface mappedFS = rule.getValue().getMappedFS();
            if (!listVFS.contains(mappedFS)) continue;
            stfnRoot = rule.getValue().getStFNRoot();
            stfnRoots.add(stfnRoot);
        }
        this.log.debug("FITTING: List of StFNRoots approachables = " + stfnRoots);
        String stfn = SURL.makeSURLfromString(surlString).getStFN();
        ArrayList stfnArray = (ArrayList)NamespaceUtil.getPathElement(stfn);
        Iterator i$ = stfnRoots.iterator();
        while (i$.hasNext()) {
            String element;
            stfnRoot = element = (String)i$.next();
            this.log.debug("FITTING: considering StFNRoot = " + stfnRoot + " against StFN = " + stfn);
            ArrayList stfnRootArray = (ArrayList)NamespaceUtil.getPathElement(stfnRoot);
            stfnRootArray.retainAll(stfnArray);
            if (stfnRootArray.isEmpty()) continue;
            result = true;
            this.log.debug("FIT!");
            break;
        }
        return result;
    }

    @Override
    public boolean isStfnFittingSomewhereAnonymous(String surlString) throws NamespaceException {
        String stfnRoot;
        boolean result = false;
        ArrayList<String> stfnRoots = new ArrayList<String>();
        Hashtable<String, MappingRule> rules = new Hashtable<String, MappingRule>(this.parser.getMappingRules());
        for (Map.Entry<String, MappingRule> rule : rules.entrySet()) {
            VirtualFSInterface mappedFS = rule.getValue().getMappedFS();
            if (!mappedFS.isApproachableByAnonymous()) continue;
            stfnRoot = rule.getValue().getStFNRoot();
            stfnRoots.add(stfnRoot);
        }
        this.log.debug("FITTING: List of StFNRoots approachables = " + stfnRoots);
        String stfn = SURL.makeSURLfromString(surlString).getStFN();
        ArrayList stfnArray = (ArrayList)NamespaceUtil.getPathElement(stfn);
        Iterator i$ = stfnRoots.iterator();
        while (i$.hasNext()) {
            String element;
            stfnRoot = element = (String)i$.next();
            this.log.debug("FITTING: considering StFNRoot = " + stfnRoot + " against StFN = " + stfn);
            ArrayList stfnRootArray = (ArrayList)NamespaceUtil.getPathElement(stfnRoot);
            stfnRootArray.retainAll(stfnArray);
            if (stfnRootArray.isEmpty()) continue;
            result = true;
            this.log.debug("FIT!");
            break;
        }
        return result;
    }

    private boolean isStfnFittingSomewhere(TSURL surl) {
        HashSet<MappingRule> rules = new HashSet<MappingRule>(this.parser.getMappingRules().values());
        Collection<String> stfnArray = NamespaceUtil.getPathElement(surl.sfn().stfn().toString());
        for (MappingRule rule : rules) {
            this.log.debug("FITTING: considering StFNRoot " + rule.getStFNRoot() + " against StFN " + surl.sfn().stfn().toString());
            ArrayList stfnRootArray = (ArrayList)NamespaceUtil.getPathElement(rule.getStFNRoot());
            stfnRootArray.retainAll(stfnArray);
            if (stfnRootArray.isEmpty()) continue;
            this.log.debug("FITS!");
            return true;
        }
        return false;
    }
}

