/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.logging;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusManager;
import it.grid.storm.logging.Files;
import it.grid.storm.logging.Strings;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingReloadTask
extends TimerTask {
    private Logger log = LoggerFactory.getLogger(LoggingReloadTask.class);
    private String loggingConfigFilePath;
    private long lastModification;

    public LoggingReloadTask(String configFilePath) {
        this.loggingConfigFilePath = Strings.safeTrimOrNullString(configFilePath);
        this.lastModification = -1L;
    }

    @Override
    public void run() {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        this.log.debug("Logger Context : " + loggerContext);
        StatusManager statusManager = loggerContext.getStatusManager();
        this.log.debug("Status Manager : " + statusManager);
        this.log.debug(new Date(System.currentTimeMillis()) + " - Run log config loader Task");
        File loggingConfigFile = null;
        try {
            loggingConfigFile = Files.getReadableFile(this.loggingConfigFilePath);
        }
        catch (IOException e) {
            this.log.error("Error loading logging configuration file: " + this.loggingConfigFilePath, (Throwable)e);
            return;
        }
        if (this.lastModification >= loggingConfigFile.lastModified()) {
            this.log.trace("Logging configuration has not changed, skipping reload");
            return;
        }
        try {
            loggerContext.reset();
            JoranConfigurator configurator = new JoranConfigurator();
            configurator.setContext((Context)loggerContext);
            FileInputStream fin = new FileInputStream(loggingConfigFile);
            configurator.doConfigure((InputStream)fin);
            fin.close();
            loggerContext.start();
            System.out.println("Logger Context : " + loggerContext);
            List listLogger = loggerContext.getLoggerList();
            for (ch.qos.logback.classic.Logger logger : listLogger) {
                System.out.println("-- Logger = " + logger.getName());
            }
            Logger logNew = LoggerFactory.getLogger((String)"health");
            System.out.println("-- Logger = " + logNew.getName());
            this.log.info("Loaded new logging configuration file {}", (Object)loggingConfigFile.getAbsoluteFile());
            this.lastModification = loggingConfigFile.lastModified();
        }
        catch (JoranException e) {
            statusManager.add((Status)new ErrorStatus("Error loading logging configuration file: " + loggingConfigFile.getAbsolutePath(), (Object)this, (Throwable)e));
        }
        catch (IOException e) {
            statusManager.add((Status)new ErrorStatus("Error loading logging configuration file: " + loggingConfigFile.getAbsolutePath(), (Object)this, (Throwable)e));
        }
    }
}

