/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.jna;

import com.sun.jna.Library;
import com.sun.jna.Native;
import it.grid.storm.ea.AttributeNotFoundException;
import it.grid.storm.ea.ExtendedAttributes;
import it.grid.storm.ea.ExtendedAttributesException;
import it.grid.storm.ea.FileNotFoundException;
import it.grid.storm.ea.NotSupportedException;

public class ExtendedAttributesImpl
implements ExtendedAttributes {
    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("usage: <command>\ncommands: get set rm check");
            System.exit(1);
        }
        ExtendedAttributesImpl dmapi = new ExtendedAttributesImpl();
        if ("check".equals(args[0].toLowerCase())) {
            System.out.println("System last error is preserved: " + Native.getPreserveLastError());
        } else if ("get".equals(args[0].toLowerCase())) {
            if (args.length != 3) {
                System.out.println("usage: get <filename> <attributename>");
                System.exit(1);
            }
            String filename = args[1];
            String attributeName = args[2];
            try {
                byte[] byteArray = dmapi.getXAttr(filename, attributeName);
                System.out.println("Result: " + new String(byteArray));
            }
            catch (FileNotFoundException e) {
                System.out.println("File not found: " + filename);
                return;
            }
            catch (AttributeNotFoundException e) {
                System.out.println("Attribute not found: " + attributeName);
                return;
            }
            catch (ExtendedAttributesException e) {
                System.out.println("Error: " + e.getMessage());
                return;
            }
        } else if ("set".equals(args[0].toLowerCase())) {
            if (args.length != 4) {
                System.out.println("usage: set <filename> <attribute_name> <attribute_value>");
                System.exit(1);
            }
            String filename = args[1];
            String attributeName = args[2];
            String attributeValue = args[3];
            try {
                dmapi.setXAttr(filename, attributeName, attributeValue.getBytes());
            }
            catch (FileNotFoundException e) {
                System.out.println("File not found: " + filename);
                return;
            }
            catch (ExtendedAttributesException e) {
                System.out.println("Error: " + e.getMessage());
                return;
            }
        } else if ("rm".equals(args[0].toLowerCase())) {
            if (args.length != 3) {
                System.out.println("usage: rm <filename> <attributename>");
                System.exit(1);
            }
            String filename = args[1];
            String attributeName = args[2];
            try {
                dmapi.rmXAttr(filename, attributeName);
            }
            catch (FileNotFoundException e) {
                System.out.println("File not found: " + filename);
                return;
            }
            catch (AttributeNotFoundException e) {
                System.out.println("Attribute not found: " + attributeName);
                return;
            }
            catch (ExtendedAttributesException e) {
                System.out.println("Error: " + e.getMessage());
                return;
            }
        } else {
            System.out.println("Unrecognized command.");
        }
    }

    @Override
    public byte[] getXAttr(String fileName, String attributeName) throws ExtendedAttributesException {
        int bufpSize = 100;
        byte[] bufp = new byte[bufpSize];
        int attributeValueSize = DMAPILibrary.INSTANCE.getxattr(fileName, attributeName, bufp, bufpSize);
        if (attributeValueSize == -1) {
            int errno = Native.getLastError();
            if (errno == 34) {
                attributeValueSize = DMAPILibrary.INSTANCE.getxattr(fileName, attributeName, bufp, 0);
                bufp = new byte[attributeValueSize];
                attributeValueSize = DMAPILibrary.INSTANCE.getxattr(fileName, attributeName, bufp, attributeValueSize);
                throw new ExtendedAttributesException("Error, errno value: " + errno);
            }
            if (errno == 61) {
                throw new AttributeNotFoundException(attributeName);
            }
            if (errno == 2 || errno == 20) {
                throw new FileNotFoundException(fileName);
            }
            if (errno == 95) {
                throw new NotSupportedException();
            }
            throw new ExtendedAttributesException("Error, errno value: " + errno);
        }
        byte[] result = new byte[attributeValueSize];
        for (int i = 0; i < attributeValueSize; ++i) {
            result[i] = bufp[i];
        }
        return result;
    }

    @Override
    public void rmXAttr(String fileName, String attributeName) throws ExtendedAttributesException {
        int ret = DMAPILibrary.INSTANCE.removexattr(fileName, attributeName);
        if (ret == -1) {
            int errno = Native.getLastError();
            if (errno == 2 || errno == 20) {
                throw new FileNotFoundException(fileName);
            }
            if (errno == 61) {
                throw new AttributeNotFoundException(attributeName);
            }
            if (errno == 95) {
                throw new NotSupportedException();
            }
            throw new ExtendedAttributesException("Error, errno value: " + errno);
        }
    }

    @Override
    public void setXAttr(String fileName, String attributeName, byte[] attributeValue) throws ExtendedAttributesException {
        int ret;
        if (fileName == null || attributeName == null) {
            throw new ExtendedAttributesException("Null input");
        }
        int bufpSize = 0;
        if (attributeValue != null) {
            bufpSize = attributeValue.length;
        }
        if ((ret = DMAPILibrary.INSTANCE.setxattr(fileName, attributeName, attributeValue, bufpSize, 0)) == -1) {
            int errno = Native.getLastError();
            if (errno == 2 || errno == 20) {
                throw new FileNotFoundException(fileName);
            }
            if (errno == 28) {
                throw new ExtendedAttributesException("Not enough space on disk to write the extended attribute");
            }
            if (errno == 122) {
                throw new ExtendedAttributesException("Not enough space on disk (due to quota enforcement) to write the extended attribute");
            }
            if (errno == 95) {
                throw new NotSupportedException();
            }
            throw new ExtendedAttributesException("Error, errno value: " + errno);
        }
    }

    private static interface DMAPILibrary
    extends Library {
        public static final DMAPILibrary INSTANCE = (DMAPILibrary)Native.loadLibrary((String)"attr", DMAPILibrary.class);

        public int getxattr(String var1, String var2, byte[] var3, int var4);

        public int removexattr(String var1, String var2);

        public int setxattr(String var1, String var2, byte[] var3, int var4, int var5);
    }
}

