/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.jna;

import com.sun.jna.NativeLibrary;
import it.grid.storm.jna.CUtil;
import it.grid.storm.jna.NoGPFSFileSystemException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CUtilManager {
    private static final Logger log = LoggerFactory.getLogger(CUtilManager.class);
    private static Boolean gpfsFileSystem = null;

    private static synchronized void init() {
        if (gpfsFileSystem == null) {
            boolean loaded = false;
            try {
                NativeLibrary.getInstance((String)"storm_cutil");
                loaded = true;
            }
            catch (UnsatisfiedLinkError e) {
                log.error("Unable to create the NativeLibrary instance for library named storm_cutil : " + e.getMessage());
            }
            gpfsFileSystem = new Boolean(loaded);
        }
    }

    public static long getFileBlocksSize(String fileName) throws NoGPFSFileSystemException {
        CUtilManager.init();
        if (!gpfsFileSystem.booleanValue()) {
            log.error("CUtilManager : attempt to use CUtil native code library JNA wrapping in a non GPFS installation - getFileBlocksSize unavailable");
            throw new NoGPFSFileSystemException("Attempt to use CUtil native code library JNA wrapping in a non GPFS installation - getFileBlocksSize unavailable");
        }
        return CUtil.getFileBlocksSize(fileName);
    }

    public static int setFileGroup(String fileName, String groupName) throws NoGPFSFileSystemException {
        CUtilManager.init();
        if (!gpfsFileSystem.booleanValue()) {
            log.error("CUtilManager : attempt to use CUtil native code library JNA wrapping in a non GPFS installation - setFileGroup unavailable");
            throw new NoGPFSFileSystemException("Attempt to use CUtil native code library JNA wrapping in a non GPFS installation - setFileGroup unavailable");
        }
        return CUtil.setFileGroup(fileName, groupName);
    }
}

