/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.jna;

import com.sun.jna.Library;
import com.sun.jna.Native;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CUtil {
    public static final String JNA_LIBRARY_NAME = "storm_cutil";
    private static final Logger log = LoggerFactory.getLogger(CUtil.class);

    CUtil() {
    }

    public static long getFileBlocksSize(String fileName) {
        return LibcLibrary.INSTANCE.gpfs_stat_get_blocks_size(fileName);
    }

    public static long getFileBlocks(String fileName) {
        return LibcLibrary.INSTANCE.stat_get_blocks(fileName);
    }

    public static int setFileGroup(String fileName, String groupName) {
        int ret = LibcLibrary.INSTANCE.set_file_group(fileName, groupName);
        if (ret != 0) {
            int errno = Native.getLastError();
            log.error("Error setting group name. errno=" + errno);
        }
        return ret;
    }

    private static interface LibcLibrary
    extends Library {
        public static final LibcLibrary INSTANCE = (LibcLibrary)Native.loadLibrary((String)"storm_cutil", LibcLibrary.class);

        public long gpfs_stat_get_blocks_size(String var1);

        public long stat_get_blocks(String var1);

        public int set_file_group(String var1, String var2);
    }
}

