/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.info.model;

import it.grid.storm.info.model.TreeStructureSummary;
import java.util.ArrayList;
import java.util.List;

public class TreeNode {
    private String path = null;
    private int nrChildren = -1;
    private long nrFiles = 0L;
    private long sumSize = 0L;
    private long minSize = 0L;
    private long maxSize = 0L;
    private boolean toCompute = true;
    private long modificationTime = -1L;
    private long checkTime = -1L;
    private long toComputeTime = -1L;
    private long nodeUpdateTime = -1L;
    private long totSize = 0L;
    private long totApparentSize = 0L;
    private int depthFromRoot = -1;
    private TreeStructureSummary tsSummary;
    private TreeNode father = null;
    private TreeNode firstChild = null;
    private TreeNode lastChild = null;
    private TreeNode brother = null;

    public TreeNode(String path) {
        this.path = path;
    }

    public final String getPath() {
        return this.path;
    }

    public final int getDepthFromRoot() {
        return this.depthFromRoot;
    }

    public final TreeStructureSummary getTsSummary() {
        return this.tsSummary;
    }

    public final TreeNode getFather() {
        return this.father;
    }

    public final void setFather(TreeNode father) {
        this.father = father;
    }

    public final void setBrother(TreeNode brother) {
        this.brother = brother;
    }

    public final TreeNode getBrother() {
        return this.brother;
    }

    public final void setNrChildren(int nrChildren) {
        this.nrChildren = nrChildren;
    }

    public final int getNrChildren() {
        return this.nrChildren;
    }

    public final void setNrFiles(long nrFiles) {
        this.nrFiles = nrFiles;
    }

    public final long getNrFiles() {
        return this.nrFiles;
    }

    public final void setSumSize(long sumSize) {
        this.sumSize = sumSize;
    }

    public final long getSumSize() {
        return this.sumSize;
    }

    public final void setMinSize(long minSize) {
        this.minSize = minSize;
    }

    public final long getMinSize() {
        return this.minSize;
    }

    public final void setMaxSize(long maxSize) {
        this.maxSize = maxSize;
    }

    public final long getMaxSize() {
        return this.maxSize;
    }

    public final void setTotSize(long totSize) {
        this.totSize = totSize;
    }

    public final long getTotSize() {
        return this.totSize;
    }

    public final void setTotApparentSize(long totApparentSize) {
        this.totApparentSize = totApparentSize;
    }

    public final long getTotApparentSize() {
        return this.totApparentSize;
    }

    public final void setToCompute(boolean toCompute) {
        this.toCompute = toCompute;
    }

    public final boolean isToCompute() {
        return this.toCompute;
    }

    public final void setModificationTime(long dateModification) {
        this.modificationTime = dateModification;
    }

    public final long getModificationTime() {
        return this.modificationTime;
    }

    public void setCheckTime(long checkTime) {
        this.checkTime = checkTime;
    }

    public long getCheckTime() {
        return this.checkTime;
    }

    public void setToComputeTime(long toComputeTime) {
        this.toComputeTime = toComputeTime;
    }

    public long getToComputeTime() {
        return this.toComputeTime;
    }

    public void setNodeUpdateTime(long nodeUpdateTime) {
        this.nodeUpdateTime = nodeUpdateTime;
    }

    public long getNodeUpdateTime() {
        return this.nodeUpdateTime;
    }

    public final TreeNode getFirstChild() {
        return this.firstChild;
    }

    public final void setFirstChild(TreeNode firstChild) {
        this.firstChild = firstChild;
    }

    public final TreeNode getLastChild() {
        return this.lastChild;
    }

    public final void setLastChild(TreeNode lastChild) {
        this.lastChild = lastChild;
    }

    public final void setDepthFromRoot(int depthFromRoot) {
        this.depthFromRoot = depthFromRoot;
    }

    private void setToComputeUntilRoot() {
        TreeNode cursor = this.father;
        while (cursor != null) {
            if (cursor.toCompute) continue;
            cursor.toCompute = true;
            cursor.setToComputeTime(System.currentTimeMillis());
        }
    }

    public final void addChildNode(TreeNode child) {
        this.setModificationTime(System.currentTimeMillis());
        if (this.firstChild == null) {
            this.firstChild = child;
        }
        if (this.lastChild != null) {
            this.lastChild.setBrother(child);
        }
        this.lastChild = child;
        child.father = this;
        child.depthFromRoot = this.depthFromRoot + 1;
        ++this.nrChildren;
        boolean toSetComp = false;
        if (this.nrChildren > this.tsSummary.getMaxBranches()) {
            this.tsSummary.setMaxBranches(this.nrChildren);
            toSetComp = true;
        }
        if (this.tsSummary.getMaxDepthToLeaves() == 0) {
            this.tsSummary.setMaxDepthToLeaves(1);
            toSetComp = true;
        }
        if (this.tsSummary.getMaxFilePerNode() < child.getNrFiles()) {
            this.tsSummary.setMaxFilePerNode(child.getNrFiles());
            toSetComp = true;
        }
        if (toSetComp) {
            this.setToComputeUntilRoot();
        }
    }

    public final List<TreeNode> getChildren() {
        ArrayList<TreeNode> children = new ArrayList<TreeNode>();
        if (this.firstChild != null) {
            children.add(this.firstChild);
            TreeNode cursor = this.firstChild;
            while (cursor.brother != null) {
                cursor = cursor.brother;
                children.add(cursor);
            }
        }
        return children;
    }

    public final void compute() {
        List<TreeNode> children = this.getChildren();
        if (!children.isEmpty()) {
            int maxDistanceLeaves = -1;
            int maxBranches = -1;
            long maxNodes = -1L;
            for (TreeNode treeNode : children) {
                TreeStructureSummary ts = treeNode.getTsSummary();
                if (ts.getMaxBranches() > maxBranches) {
                    maxBranches = ts.getMaxBranches();
                }
                if (ts.getMaxDepthToLeaves() > maxDistanceLeaves) {
                    maxDistanceLeaves = ts.getMaxDepthToLeaves();
                }
                if (ts.getMaxFilePerNode() <= maxNodes) continue;
                maxNodes = ts.getMaxFilePerNode();
            }
            boolean toSetComp = false;
            if (maxDistanceLeaves > this.tsSummary.getMaxDepthToLeaves()) {
                this.tsSummary.setMaxDepthToLeaves(maxDistanceLeaves);
                toSetComp = true;
            }
            if (maxBranches > this.tsSummary.getMaxBranches()) {
                this.tsSummary.setMaxBranches(maxBranches);
                toSetComp = true;
            }
            if (maxNodes > this.tsSummary.getMaxFilePerNode()) {
                this.tsSummary.setMaxFilePerNode(maxNodes);
                toSetComp = true;
            }
            if (toSetComp) {
                this.setToComputeUntilRoot();
            }
        }
        this.toCompute = false;
        this.setNodeUpdateTime(System.currentTimeMillis());
    }
}

