/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.info.model;

import it.grid.storm.catalogs.ReservedSpaceCatalog;
import it.grid.storm.space.StorageSpaceData;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.stream.XMLStreamException;
import org.codehaus.jettison.mapped.Configuration;
import org.codehaus.jettison.mapped.MappedNamespaceConvention;
import org.codehaus.jettison.mapped.MappedXMLStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpaceStatusSummary {
    protected final String saAlias;
    protected final long totalSpace;
    protected long usedSpace = -1L;
    protected long unavailableSpace = -1L;
    protected long reservedSpace = -1L;
    private static final ReservedSpaceCatalog catalog = new ReservedSpaceCatalog();
    private static final Logger log = LoggerFactory.getLogger(SpaceStatusSummary.class);

    public SpaceStatusSummary(String saAlias, long totalSpace) throws IllegalArgumentException {
        if (totalSpace < 0L || saAlias == null) {
            log.error("Unable to create SpaceStatusSummary. Received illegal parameter: saAlias: " + saAlias + " totalSpace: " + totalSpace);
            throw new IllegalArgumentException("Unable to create SpaceStatusSummary. Received illegal parameter");
        }
        this.saAlias = saAlias;
        this.totalSpace = totalSpace;
    }

    private SpaceStatusSummary(String saAlias, long usedSpace, long unavailableSpace, long reservedSpace, long totalSpace) {
        this.saAlias = saAlias;
        this.usedSpace = usedSpace;
        this.unavailableSpace = unavailableSpace;
        this.reservedSpace = reservedSpace;
        this.totalSpace = totalSpace;
    }

    public static SpaceStatusSummary createFromDB(String saAlias) throws IllegalArgumentException {
        StorageSpaceData storageSpaceData = catalog.getStorageSpaceByAlias(saAlias);
        if (storageSpaceData == null) {
            throw new IllegalArgumentException("Unable to find a storage space row for alias '" + saAlias + "' from storm Database");
        }
        if (!storageSpaceData.isInitialized()) {
            log.warn("Building the SpaceStatusSummary from non initialized space with alias '" + saAlias + "'");
        }
        SpaceStatusSummary summary = new SpaceStatusSummary(saAlias, storageSpaceData.getUsedSpaceSize().value(), storageSpaceData.getUnavailableSpaceSize().value(), storageSpaceData.getReservedSpaceSize().value(), storageSpaceData.getTotalSpaceSize().value());
        return summary;
    }

    public String getSaAlias() {
        return this.saAlias;
    }

    public long getBusySpace() {
        return this.usedSpace + this.reservedSpace + this.unavailableSpace;
    }

    public long getAvailableSpace() {
        return this.totalSpace - this.getBusySpace();
    }

    public long getUsedSpace() {
        return this.usedSpace;
    }

    public long getUnavailableSpace() {
        return this.unavailableSpace;
    }

    public long getReservedSpace() {
        return this.reservedSpace;
    }

    public long getTotalSpace() {
        return this.totalSpace;
    }

    public long getFreeSpace() {
        if (this.totalSpace >= 0L) {
            return this.totalSpace - this.usedSpace;
        }
        return -1L;
    }

    public void setUsedSpace(long usedSpace) {
        this.usedSpace = usedSpace;
    }

    public void setUnavailableSpace(long unavailableSpace) {
        this.unavailableSpace = unavailableSpace;
    }

    public void setReservedSpace(long reservedSpace) {
        this.reservedSpace = reservedSpace;
    }

    public String getJsonFormat() {
        String result = "";
        StringWriter strWriter = new StringWriter();
        Configuration config = new Configuration();
        MappedNamespaceConvention con = new MappedNamespaceConvention(config);
        try {
            MappedXMLStreamWriter w = new MappedXMLStreamWriter(con, (Writer)strWriter);
            w.writeStartDocument();
            w.writeStartElement("sa-status");
            w.writeStartElement("alias");
            w.writeCharacters(this.getSaAlias());
            w.writeEndElement();
            w.writeStartElement("busy-space");
            w.writeCharacters("" + this.getBusySpace());
            w.writeEndElement();
            w.writeStartElement("used-space");
            w.writeCharacters("" + this.getUsedSpace());
            w.writeEndElement();
            w.writeStartElement("unavailable-space");
            w.writeCharacters("" + this.getUnavailableSpace());
            w.writeEndElement();
            w.writeStartElement("reserved-space");
            w.writeCharacters("" + this.getReservedSpace());
            w.writeEndElement();
            w.writeStartElement("total-space");
            w.writeCharacters("" + this.getTotalSpace());
            w.writeEndElement();
            w.writeStartElement("free-space");
            w.writeCharacters("" + this.getFreeSpace());
            w.writeEndElement();
            w.writeStartElement("available-space");
            w.writeCharacters("" + this.getAvailableSpace());
            w.writeEndElement();
            w.writeEndElement();
            w.writeEndDocument();
            w.close();
        }
        catch (XMLStreamException e) {
            log.error("Unable to produce Json representation of the object. XMLStreamException: " + e.getMessage());
        }
        try {
            strWriter.close();
        }
        catch (IOException e) {
            log.error("Unable to close the StringWriter for Json representation of the object. IOException: " + e.getMessage());
        }
        result = strWriter.toString();
        return result;
    }

    public String toString() {
        return "SpaceStatusSummary [getSaAlias()=" + this.getSaAlias() + ", getBusySpace()=" + this.getBusySpace() + ", getAvailableSpace()=" + this.getAvailableSpace() + ", getUsedSpace()=" + this.getUsedSpace() + ", getUnavailableSpace()=" + this.getUnavailableSpace() + ", getReservedSpace()=" + this.getReservedSpace() + ", getTotalSpace()=" + this.getTotalSpace() + ", getFreeSpace()=" + this.getFreeSpace() + "]";
    }
}

