/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.info;

import it.grid.storm.catalogs.ReservedSpaceCatalog;
import it.grid.storm.common.GUID;
import it.grid.storm.common.types.InvalidPFNAttributeException;
import it.grid.storm.common.types.PFN;
import it.grid.storm.common.types.SizeUnit;
import it.grid.storm.config.Configuration;
import it.grid.storm.info.BackgroundDU;
import it.grid.storm.info.BackgroundDUTasks;
import it.grid.storm.info.CatalogUpdater;
import it.grid.storm.info.SAInfoException;
import it.grid.storm.namespace.CapabilityInterface;
import it.grid.storm.namespace.NamespaceDirector;
import it.grid.storm.namespace.NamespaceException;
import it.grid.storm.namespace.VirtualFSInterface;
import it.grid.storm.namespace.model.Quota;
import it.grid.storm.persistence.exceptions.DataAccessException;
import it.grid.storm.persistence.model.TransferObjectDecodingException;
import it.grid.storm.space.DUResult;
import it.grid.storm.space.ExitCode;
import it.grid.storm.space.StorageSpaceData;
import it.grid.storm.space.init.UsedSpaceFile;
import it.grid.storm.space.quota.BackgroundGPFSQuota;
import it.grid.storm.space.quota.QuotaManager;
import it.grid.storm.srm.types.InvalidTSizeAttributesException;
import it.grid.storm.srm.types.InvalidTSpaceTokenAttributesException;
import it.grid.storm.srm.types.TSizeInBytes;
import it.grid.storm.srm.types.TSpaceToken;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpaceInfoManager {
    private final Logger LOG;
    private static final SpaceInfoManager instance = new SpaceInfoManager();
    private int timeOutDurationInSec = 7200;
    private BackgroundDU bDU;
    private AtomicInteger tasksToComplete;
    private AtomicInteger tasksToSave;
    private AtomicInteger success;
    private AtomicInteger failures;
    private AtomicInteger numberOfTasks;
    AtomicBoolean testMode = new AtomicBoolean(false);
    private final int MaxAttempt = 2;
    private CatalogUpdater persist = new CatalogUpdater();
    private final ReservedSpaceCatalog spaceCatalog = new ReservedSpaceCatalog();
    private int quotas = 0;
    private int quotasDefined = 0;
    private final BackgroundDUTasks bDUTasks = new BackgroundDUTasks();
    private int attempt = 1;

    private SpaceInfoManager() {
        this.LOG = LoggerFactory.getLogger(SpaceInfoManager.class);
        List<VirtualFSInterface> vfsS = this.retrieveSAtoInitializeWithQuota();
        this.quotasDefined = vfsS != null ? vfsS.size() : 0;
    }

    public final int getQuotasDefined() {
        return this.quotasDefined;
    }

    public static SpaceInfoManager getInstance() {
        return instance;
    }

    public static boolean isInProgress() {
        boolean result = false;
        if (SpaceInfoManager.getInstance().tasksToComplete.get() > 0) {
            result = true;
        }
        return result;
    }

    public static boolean isInProgress(TSpaceToken spaceToken) {
        boolean result = false;
        if (SpaceInfoManager.getInstance().tasksToComplete.get() > 0) {
            BackgroundDUTasks tasks = SpaceInfoManager.getInstance().bDUTasks;
            Collection<BackgroundDUTasks.BgDUTask> ts = tasks.getTasks();
            for (BackgroundDUTasks.BgDUTask bgDUTask : ts) {
                if (!bgDUTask.getSpaceToken().equals(spaceToken)) continue;
                result = true;
            }
        }
        return result;
    }

    public int updateSpaceUsed() {
        int quotaFailures = 0;
        quotaFailures = this.execGPFSQuota(false, true);
        this.startBackGroundDU();
        return quotaFailures;
    }

    public static int howManyBackgroundDU() {
        return SpaceInfoManager.getInstance().bDUTasks.howManyTask();
    }

    public int howManyQuotas() {
        return this.quotas;
    }

    public int execGPFSQuota(boolean test, boolean bootstrap) {
        int result = 0;
        boolean synchronousQuotaCheck = Configuration.getInstance().getSynchronousQuotaCheckEnabled();
        if (bootstrap) {
            boolean fastBootstrapEnabled = Configuration.getInstance().getFastBootstrapEnabled();
            if (!fastBootstrapEnabled) {
                QuotaManager.getInstance().updateSAwithQuotaSynch(test);
                this.quotas = QuotaManager.getInstance().getHowmanyQuotas();
                this.LOG.info("Executed '" + this.quotas + " mmlsquota in order to update related SAs");
            } else {
                BackgroundGPFSQuota.getInstance().submitGPFSQuota();
                this.LOG.info("Submitted an asynchronous GPFS Quota job");
            }
        } else if (synchronousQuotaCheck) {
            QuotaManager.getInstance().updateSAwithQuotaSynch(test);
            this.quotas = QuotaManager.getInstance().getHowmanyQuotas();
            this.LOG.info("Executed '" + this.quotas + "'  check");
        } else {
            this.LOG.debug("Quota Check is disabled. Submit GPFS Quota job.");
            BackgroundGPFSQuota.getInstance().submitGPFSQuota();
        }
        return result;
    }

    private int startBackGroundDU() {
        int result = 0;
        SpaceInfoManager.getInstance().foundSAtoAnalyze();
        result = SpaceInfoManager.getInstance().bDUTasks.howManyTask();
        this.LOG.debug(String.format("Tasks: %d", result));
        SpaceInfoManager.getInstance().submitTasks(SpaceInfoManager.getInstance().bDUTasks);
        return result;
    }

    public int startTest(List<String> absPaths) {
        int result = 0;
        this.testMode = new AtomicBoolean(true);
        SpaceInfoManager.getInstance().fakeSAtoAnalyze(absPaths);
        result = SpaceInfoManager.getInstance().bDUTasks.howManyTask();
        SpaceInfoManager.getInstance().submitTasks(SpaceInfoManager.getInstance().bDUTasks);
        return result;
    }

    public static int stop() {
        int result = 0;
        SpaceInfoManager.getInstance().stopExecution();
        result = SpaceInfoManager.getInstance().failures.get();
        return result;
    }

    public List<StorageSpaceData> retrieveSSDtoInitializeWithQuota() {
        ArrayList<StorageSpaceData> ssdSet = new ArrayList<StorageSpaceData>();
        List<VirtualFSInterface> vfsSet = this.retrieveSAtoInitializeWithQuota();
        ReservedSpaceCatalog ssdCatalog = new ReservedSpaceCatalog();
        for (VirtualFSInterface vfsEntry : vfsSet) {
            try {
                String spaceTokenDesc = vfsEntry.getSpaceTokenDescription();
                StorageSpaceData ssd = ssdCatalog.getStorageSpaceByAlias(spaceTokenDesc);
                ssdSet.add(ssd);
            }
            catch (NamespaceException e) {
                this.LOG.error("Unable to retrieve virtual file system list. NamespaceException : " + e.getMessage());
            }
        }
        return ssdSet;
    }

    public StorageSpaceData getSSDfromQuotaName(String quotaName) {
        StorageSpaceData ssd = null;
        List<VirtualFSInterface> vfsList = this.retrieveSAtoInitializeWithQuota();
        ReservedSpaceCatalog ssdCatalog = new ReservedSpaceCatalog();
        for (VirtualFSInterface vfsEntry : vfsList) {
            try {
                String qName = vfsEntry.getCapabilities().getQuota().getQuotaElementName();
                if (!qName.equals(quotaName)) continue;
                String spaceTokenDesc = vfsEntry.getSpaceTokenDescription();
                ssd = ssdCatalog.getStorageSpaceByAlias(spaceTokenDesc);
            }
            catch (NamespaceException e) {
                this.LOG.error("Unable to retrieve virtual file system list. NamespaceException : " + e.getMessage());
            }
        }
        return ssd;
    }

    public List<String> retrieveQuotaNamesToUse() {
        ArrayList<String> quotaNames = new ArrayList<String>();
        List<VirtualFSInterface> vfsList = this.retrieveSAtoInitializeWithQuota();
        for (VirtualFSInterface vfsEntry : vfsList) {
            this.LOG.debug("vfsEntry (AliasName): " + vfsEntry.getAliasName());
            String quotaName = vfsEntry.getCapabilities().getQuota().getQuotaElementName();
            this.LOG.debug("Found this quotaName to check: '" + quotaName + "'");
            quotaNames.add(quotaName);
        }
        this.LOG.debug("Number of quotaNames: " + quotaNames.size());
        return quotaNames;
    }

    public List<VirtualFSInterface> retrieveSAtoInitializeWithQuota() {
        ArrayList<VirtualFSInterface> vfsSet = null;
        try {
            vfsSet = new ArrayList<VirtualFSInterface>(NamespaceDirector.getNamespace().getAllDefinedVFS());
        }
        catch (NamespaceException e) {
            this.LOG.error("Unable to get the defined Virtual File Systems. NamespaceException : " + e.getMessage());
            this.LOG.error("Returning an empty list");
            return new ArrayList<VirtualFSInterface>();
        }
        this.LOG.debug("Found '" + vfsSet.size() + "' VFS defined in Namespace.xml");
        ArrayList<VirtualFSInterface> vfsSetQuota = new ArrayList<VirtualFSInterface>();
        if (vfsSet.size() > 0) {
            for (VirtualFSInterface vfsItem : vfsSet) {
                if (!this.gpfsQuotaEnabled(vfsItem)) continue;
                vfsSetQuota.add(vfsItem);
            }
        }
        this.LOG.debug("Number of VFS with Quota enabled: " + vfsSetQuota.size());
        return vfsSetQuota;
    }

    private boolean gpfsQuotaEnabled(VirtualFSInterface vfsItem) {
        boolean result = false;
        if (vfsItem != null) {
            CapabilityInterface cap = null;
            Quota quota = null;
            String fsType = "Unknown";
            try {
                fsType = vfsItem.getFSType();
                if (fsType != null && fsType.trim().toLowerCase().equals("gpfs")) {
                    cap = vfsItem.getCapabilities();
                    if (cap != null) {
                        quota = cap.getQuota();
                    }
                    if (quota != null) {
                        result = quota.getDefined() && quota.getEnabled();
                    }
                }
            }
            catch (NamespaceException e) {
                this.LOG.error("Unable to retrieve virtual file system list. NamespaceException : " + e.getMessage());
            }
        }
        return result;
    }

    private void fakeSAtoAnalyze(List<String> absPaths) {
        ArrayList<StorageSpaceData> toAnalyze = new ArrayList<StorageSpaceData>();
        for (String path : absPaths) {
            path = path + File.separator;
            String pathNorm = FilenameUtils.normalize((String)FilenameUtils.getFullPath((String)path));
            StorageSpaceData ssd = new StorageSpaceData();
            try {
                PFN spaceFN = PFN.make(pathNorm);
                this.LOG.trace("PFN : " + spaceFN);
                ssd.setSpaceToken(TSpaceToken.make(new GUID().toString()));
                ssd.setSpaceFileName(spaceFN);
                toAnalyze.add(ssd);
            }
            catch (InvalidTSpaceTokenAttributesException e) {
                this.LOG.error("Unable to create Space Token. " + e);
            }
            catch (InvalidPFNAttributeException e) {
                this.LOG.error("Unable to create PFN. " + e);
            }
        }
        for (StorageSpaceData ssd : toAnalyze) {
            TSpaceToken sT = ssd.getSpaceToken();
            String absPath = ssd.getSpaceFileNameString();
            try {
                this.bDUTasks.addTask(sT, absPath);
                this.LOG.debug(String.format("Added %s to the DU-Task Queue. (Task queue size:%d)", absPath, this.bDUTasks.howManyTask()));
            }
            catch (SAInfoException e) {
                this.LOG.error("Unable to add task with '" + absPath + "' absolute path." + e.getMessage());
            }
        }
        this.LOG.info(String.format("Background DU tasks size: %d", this.bDUTasks.getTasks().size()));
    }

    private void foundSAtoAnalyze() {
        List<StorageSpaceData> toAnalyze = this.spaceCatalog.getStorageSpaceNotInitialized();
        for (StorageSpaceData ssd : toAnalyze) {
            TSpaceToken sT = ssd.getSpaceToken();
            String absPath = ssd.getSpaceFileNameString();
            if (sT == null || absPath == null) {
                this.LOG.error("Unable to submit DU test, StorageSpaceData returns null values: SpaceToken=" + sT + " , SpaceFileNameString=" + absPath);
                continue;
            }
            try {
                this.bDUTasks.addTask(sT, absPath);
                this.LOG.debug("Added " + absPath + " to the DU-Task Queue. (size:" + this.bDUTasks.howManyTask() + ")");
            }
            catch (SAInfoException e) {
                this.LOG.error("Unable to add task with '" + absPath + "' absolute path." + e.getMessage());
            }
        }
    }

    void stopExecution() {
        this.bDU.stopExecution(true);
        this.persist.stopSaver();
        this.LOG.debug("Stopping Background DU executions.");
    }

    void updateSA(DUResult result) {
        BackgroundDUTasks.BgDUTask task = this.bDUTasks.getBgDUTask(result.getAbsRootPath());
        task.setDuResult(result);
        try {
            this.bDUTasks.updateTask(task);
        }
        catch (SAInfoException e1) {
            this.LOG.error("Something strange happen.." + e1);
        }
        if (result.getCmdResult().equals((Object)ExitCode.SUCCESS)) {
            TSpaceToken st = task.getSpaceToken();
            try {
                this.persist.saveData(st, result);
            }
            catch (SAInfoException e) {
                this.LOG.error("Unable to persist the DU result of '" + result.getAbsRootPath() + "' " + e);
            }
        } else {
            this.LOG.warn(String.format("DU of space with %s token is terminated with status %s", new Object[]{task.getSpaceToken().toString(), result.getCmdResult()}));
        }
        int ttc = this.tasksToComplete.decrementAndGet();
        this.LOG.debug("TaskToComplete: " + ttc);
        if (this.tasksToComplete.get() <= 0) {
            this.LOG.info("All the tasks are completed!");
            for (BackgroundDUTasks.BgDUTask bTask : this.bDUTasks.getTasks()) {
                if (bTask.getDuResult().isSuccess()) {
                    this.success.incrementAndGet();
                    continue;
                }
                bTask.increaseAttempt();
                if (bTask.getAttempt() > 2) {
                    this.LOG.error("Unable to compute Space Used for the SA with root '" + bTask.getAbsPath() + "' for the reason :" + (Object)((Object)bTask.getDuResult().getCmdResult()));
                    this.failures.incrementAndGet();
                    continue;
                }
                try {
                    this.bDUTasks.updateTask(bTask);
                }
                catch (SAInfoException e) {
                    this.LOG.error("Something starnge happen." + e);
                }
            }
            int s = this.success.get();
            int f = this.failures.get();
            int tot = this.numberOfTasks.get();
            int r = tot - s - f;
            this.LOG.debug(String.format("Total DU Tasks are %d (success:%d; to-retry:%d; failure:%d).", tot, s, r, f));
            if (r == 0) {
                this.stopExecution();
            }
        }
    }

    void savedSA(DUResult result) {
        this.tasksToSave.decrementAndGet();
        this.LOG.debug("Result saved..");
    }

    void submitTasks(BackgroundDUTasks tasks) {
        this.bDU = new BackgroundDU(this.timeOutDurationInSec * this.attempt, TimeUnit.SECONDS);
        Collection<BackgroundDUTasks.BgDUTask> tasksToSubmit = tasks.getTasks();
        this.LOG.debug("tasks to submit: " + tasksToSubmit);
        int size = tasksToSubmit.size();
        this.numberOfTasks = new AtomicInteger(size);
        this.tasksToComplete = new AtomicInteger(size);
        this.tasksToSave = new AtomicInteger(size);
        this.failures = new AtomicInteger(0);
        this.success = new AtomicInteger(0);
        this.LOG.info("Submitting " + this.tasksToComplete + " DU tasks.");
        for (BackgroundDUTasks.BgDUTask task : tasksToSubmit) {
            this.bDU.addStorageArea(task.getAbsPath(), task.getTaskId());
        }
        this.LOG.info("Setting fake used space to " + this.tasksToComplete + " DU tasks.");
        this.setFakeUsedSpace(tasksToSubmit);
        this.LOG.info("Start DU background execution");
        this.bDU.startExecution();
    }

    private void setFakeUsedSpace(Collection<BackgroundDUTasks.BgDUTask> tasksToSubmit) {
        ReservedSpaceCatalog spaceCatalog = new ReservedSpaceCatalog();
        for (BackgroundDUTasks.BgDUTask task : tasksToSubmit) {
            TSpaceToken sToken = task.getSpaceToken();
            StorageSpaceData ssd = null;
            try {
                ssd = spaceCatalog.getStorageSpace(sToken);
            }
            catch (TransferObjectDecodingException e) {
                this.LOG.error("Unable to build StorageSpaceData from StorageSpaceTO. TransferObjectDecodingException: " + e.getMessage());
            }
            catch (DataAccessException e) {
                this.LOG.error("Unable to build get StorageSpaceTO. DataAccessException: " + e.getMessage());
            }
            TSizeInBytes totalSize = ssd.getTotalSpaceSize();
            TSizeInBytes fakeUsed = TSizeInBytes.makeEmpty();
            try {
                fakeUsed = TSizeInBytes.make(totalSize.value() / 2L, SizeUnit.BYTES);
            }
            catch (InvalidTSizeAttributesException e) {
                this.LOG.warn("Unable to create Fake Size to set to used_size");
            }
            ssd.setUsedSpaceSize(fakeUsed);
            spaceCatalog.updateStorageSpace(ssd);
        }
    }

    public int initSpaceFromINIFile() {
        List<StorageSpaceData> toAnalyze = this.spaceCatalog.getStorageSpaceNotInitialized();
        ArrayList<String> toAnalyzeAlias = new ArrayList<String>();
        for (StorageSpaceData ssd : toAnalyze) {
            toAnalyzeAlias.add(ssd.getSpaceTokenAlias());
        }
        this.printInitializedStorageAreas(toAnalyzeAlias);
        int storageSpaceUpdated = 0;
        UsedSpaceFile usedSpaceFile = new UsedSpaceFile(toAnalyzeAlias);
        List<UsedSpaceFile.SaUsedSize> saUsedSizeList = usedSpaceFile.getDefinedSizes();
        for (UsedSpaceFile.SaUsedSize saUsedSize : saUsedSizeList) {
            if (saUsedSize.hasUpdateTime()) {
                try {
                    this.updateUsedSpaceOnPersistence(saUsedSize.getSaName(), saUsedSize.getUsedSize(), saUsedSize.getUpdateTime());
                    ++storageSpaceUpdated;
                }
                catch (IllegalArgumentException e) {
                    this.LOG.error("Unable to updated used space on persistence for Storage Area " + saUsedSize.getSaName() + " to value " + saUsedSize.getUsedSize() + " with update time " + saUsedSize.getUpdateTime() + ". IllegalArgumentException: " + e.getMessage());
                }
                continue;
            }
            try {
                this.updateUsedSpaceOnPersistence(saUsedSize.getSaName(), saUsedSize.getUsedSize());
                ++storageSpaceUpdated;
            }
            catch (IllegalArgumentException e) {
                this.LOG.error("Unable to updated used space on persistence for Storage Area " + saUsedSize.getSaName() + " to value " + saUsedSize.getUsedSize() + ". IllegalArgumentException: " + e.getMessage());
            }
        }
        return storageSpaceUpdated;
    }

    private void printInitializedStorageAreas(List<String> saAlias) {
        try {
            for (VirtualFSInterface vfs : NamespaceDirector.getNamespace().getAllDefinedVFS()) {
                if (saAlias.contains(vfs.getSpaceTokenDescription())) continue;
                this.LOG.debug("SA '" + vfs.getAliasName() + "' is already initializated");
            }
        }
        catch (NamespaceException e) {
            this.LOG.error("Unexpected Exception: NamespaceException on getAllDefinedVFS: ", (Throwable)e);
        }
    }

    private void updateUsedSpaceOnPersistence(String saName, Long usedSize) throws IllegalArgumentException {
        if (saName == null || usedSize == null) {
            this.LOG.error("Received null arguments: saName = " + saName + " usedSize = " + usedSize);
            throw new IllegalArgumentException("Received null arguments: saName = " + saName + " usedSize = " + usedSize);
        }
        this.updateUsedSpaceOnPersistence(saName, usedSize, null);
    }

    private void updateUsedSpaceOnPersistence(String saName, Long usedSize, Date updateTime) throws IllegalArgumentException {
        if (saName == null || usedSize == null) {
            this.LOG.error("Received null arguments: saName = " + saName + " usedSize = " + usedSize);
            throw new IllegalArgumentException("Received null arguments: saName = " + saName + " usedSize = " + usedSize);
        }
        StorageSpaceData ssd = this.spaceCatalog.getStorageSpaceByAlias(saName);
        if (ssd != null) {
            try {
                ssd.setUsedSpaceSize(TSizeInBytes.make(usedSize, SizeUnit.BYTES));
            }
            catch (InvalidTSizeAttributesException e) {
                this.LOG.error("Invalid Used Size: " + usedSize + " . InvalidTSizeAttributesException: " + e.getMessage());
                throw new IllegalArgumentException("Invalid Used Size: " + usedSize + " Unable to update Storage Space");
            }
            if (updateTime == null) {
                this.spaceCatalog.updateStorageSpace(ssd);
            } else {
                this.spaceCatalog.updateStorageSpace(ssd, updateTime);
            }
        } else {
            this.LOG.warn("Unable to retrieve StorageSpaceData with Alias: " + saName);
            throw new IllegalArgumentException("Unable to retrieve StorageSpaceData with Alias: " + saName);
        }
        this.LOG.debug("StorageSpace table updated for SA: '" + saName + "' with used size = " + usedSize);
    }
}

