/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.info;

import it.grid.storm.info.SAInfoException;
import it.grid.storm.space.DUResult;
import it.grid.storm.srm.types.TSpaceToken;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackgroundDUTasks {
    private Set<BgDUTask> tasks = new HashSet<BgDUTask>();
    private static final Logger LOG = LoggerFactory.getLogger(BackgroundDUTasks.class);
    private static final AtomicInteger taskId = new AtomicInteger();

    public void addTask(TSpaceToken token, String path) throws SAInfoException {
        BgDUTask task = new BgDUTask(token, true, path);
        this.tasks.add(task);
    }

    public void addTask(BgDUTask task) {
        this.tasks.add(task);
    }

    public void updateTask(BgDUTask task) throws SAInfoException {
        if (!this.tasks.contains(task)) {
            throw new SAInfoException(String.format("DU Task on %s doesn't exist in Task queue", task.absPath));
        }
        this.tasks.remove(task);
        this.tasks.add(task);
    }

    public BgDUTask getBgDUTask(String absRootPath) {
        BgDUTask result = null;
        for (BgDUTask task : this.tasks) {
            if (!FilenameUtils.equalsNormalized((String)task.getAbsPath(), (String)absRootPath)) continue;
            result = task;
        }
        return result;
    }

    public void removeTask(String absRootPath) {
        BgDUTask result = null;
        for (BgDUTask task : this.tasks) {
            if (!FilenameUtils.equalsNormalized((String)task.getAbsPath(), (String)absRootPath)) continue;
            result = task;
        }
        if (result != null) {
            this.tasks.remove(result);
        }
    }

    public void removeSuccessTask() {
        ArrayList<BgDUTask> succTask = new ArrayList<BgDUTask>();
        for (BgDUTask task : this.tasks) {
            if (!task.duResult.isSuccess()) continue;
            succTask.add(task);
        }
        for (BgDUTask t : succTask) {
            this.removeTask(t.getAbsPath());
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("BackgroundDUTasks [tasks=");
        builder.append(this.tasks);
        builder.append("]");
        return builder.toString();
    }

    public Collection<BgDUTask> getTasks() {
        return this.tasks;
    }

    public int howManyTask() {
        return this.tasks.size();
    }

    public void clearTasks() {
        this.tasks.clear();
    }

    class BgDUTask
    implements Comparable<BgDUTask> {
        private boolean isSARoot = false;
        private String absPath;
        private TSpaceToken spaceToken;
        private DUResult duResult;
        private int attempt = 0;

        public BgDUTask(TSpaceToken sToken, boolean root, String absPath) throws SAInfoException {
            String pathNorm = FilenameUtils.normalize((String)FilenameUtils.getFullPath((String)(absPath + File.separator)));
            File cf = new File(pathNorm);
            if (!cf.exists()) {
                throw new SAInfoException(String.format("The path %s doesn't exists.", absPath));
            }
            if (!cf.isDirectory()) {
                throw new SAInfoException(String.format("The path %s is not a directory.", absPath));
            }
            this.absPath = absPath;
            this.isSARoot = root;
            this.spaceToken = sToken;
            taskId.incrementAndGet();
            this.attempt = 1;
        }

        public boolean isSARoot() {
            return this.isSARoot;
        }

        public String getAbsPath() {
            return this.absPath;
        }

        public TSpaceToken getSpaceToken() {
            return this.spaceToken;
        }

        public int getTaskId() {
            return taskId.get();
        }

        public void setDuResult(DUResult duResult) {
            this.duResult = duResult;
        }

        public DUResult getDuResult() {
            return this.duResult;
        }

        public int getAttempt() {
            return this.attempt;
        }

        public void increaseAttempt() {
            ++this.attempt;
        }

        @Override
        public int compareTo(BgDUTask other) {
            int result = -1;
            result = this.getTaskId() < other.getTaskId() ? -1 : (this.getTaskId() > other.getTaskId() ? 1 : (this.equals(other) ? 0 : -1));
            return result;
        }

        public boolean equals(Object obj) {
            if (obj instanceof BgDUTask) {
                BgDUTask other = (BgDUTask)obj;
                if (this.getTaskId() == other.getTaskId()) {
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("BgDUTask [isSARoot=");
            builder.append(this.isSARoot);
            builder.append(", absPath=");
            builder.append(this.absPath);
            builder.append(", spaceToken=");
            builder.append(this.spaceToken);
            builder.append(", duResult=");
            builder.append(this.duResult);
            builder.append(", attempt=");
            builder.append(this.attempt);
            builder.append("]");
            return builder.toString();
        }
    }
}

