/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.info;

import it.grid.storm.concurrency.NamedThreadFactory;
import it.grid.storm.concurrency.TimingThreadPool;
import it.grid.storm.info.SpaceInfoManager;
import it.grid.storm.space.CallableDU;
import it.grid.storm.space.DUResult;
import it.grid.storm.space.ExitCode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackgroundDU {
    private static final Logger LOG = LoggerFactory.getLogger(BackgroundDU.class);
    private List<CallableDU> todoTasks = new ArrayList<CallableDU>();
    private Set<Future<DUResult>> toCheckTasks = new HashSet<Future<DUResult>>();
    private Set<Future<DUResult>> completedTasks = new HashSet<Future<DUResult>>();
    private Set<DUResult> successResults = new HashSet<DUResult>();
    private Set<DUResult> failureResults = new HashSet<DUResult>();
    private long timeoutInSec = 3600L;
    private int poolSize = 2;
    private int maxPoolSize = 5;
    private long keepAliveTime = 10L;
    private final BlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>();
    private final ExecutorService exec = new TimingThreadPool(this.poolSize, this.maxPoolSize, this.keepAliveTime, TimeUnit.SECONDS, this.workQueue, new NamedThreadFactory("DUExecutors"));
    private final CompletionService<DUResult> completionService = new ExecutorCompletionService<DUResult>(this.exec);
    private ExecutorService singleExec = Executors.newFixedThreadPool(1, new NamedThreadFactory("CompletionTask"));
    private Future<?> completionTaskHandle = null;

    public BackgroundDU(long timeOutDuration, TimeUnit timeUnit) {
        this.timeoutInSec = timeUnit.toSeconds(timeOutDuration);
    }

    public void addStorageArea(String saRoot, int taskId) {
        CallableDU task = new CallableDU(saRoot, this.timeoutInSec);
        this.todoTasks.add(task);
    }

    public int howManyTaskToComplete() {
        return this.toCheckTasks.size();
    }

    public int howManyTaskSuccess() {
        return this.successResults.size();
    }

    public int howManyTaskFailure() {
        return this.failureResults.size();
    }

    public Set<DUResult> getSuccessTasks() {
        return this.successResults;
    }

    public Set<DUResult> getFailureTasks() {
        return this.failureResults;
    }

    public void startExecution() {
        int remainingFutures = 0;
        for (CallableDU tasks : this.todoTasks) {
            ++remainingFutures;
            this.toCheckTasks.add(this.completionService.submit(tasks));
        }
        this.todoTasks.clear();
        LOG.info("Submitted all the DU task.");
        this.completionTaskHandle = this.singleExec.submit(new CompletionTask());
    }

    public void poisonCompletionService() {
        this.completionService.submit(CallableDU.getPoisonPill());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopExecution(boolean sweetDead) {
        this.todoTasks.clear();
        long millisecToWait = 1000L;
        if (sweetDead) {
            this.poisonCompletionService();
            millisecToWait = 10000L;
        }
        try {
            this.completionTaskHandle.get(millisecToWait, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException te) {
            LOG.debug("Timeout excep. " + te);
        }
        catch (InterruptedException ie) {
            LOG.debug("Interrupted excep. " + ie);
        }
        catch (ExecutionException ee) {
            LOG.debug("Execution excep. " + ee);
        }
        finally {
            this.completionTaskHandle.cancel(true);
            LOG.debug("Completion task forced to be canceled.");
        }
        try {
            LOG.debug("Shutting down..");
            this.shutdown(false, 1000L);
            LOG.debug("Shutted down!");
        }
        catch (InterruptedException ie) {
            LOG.debug("Interrupted excep. " + ie);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdown(boolean interrupt, long waitMillis) throws InterruptedException {
        if (interrupt) {
            LOG.debug("Tasks killed: " + this.exec.shutdownNow().size());
            LOG.debug("Tasks killed: " + this.singleExec.shutdownNow().size());
        } else {
            this.exec.shutdown();
            this.singleExec.shutdown();
        }
        try {
            this.exec.awaitTermination(waitMillis, TimeUnit.MILLISECONDS);
            this.singleExec.awaitTermination(waitMillis, TimeUnit.MILLISECONDS);
        }
        finally {
            LOG.debug("Tasks killed: " + this.exec.shutdownNow().size());
            LOG.debug("Tasks killed: " + this.singleExec.shutdownNow().size());
        }
        LOG.debug("EXEC is terminated? : " + this.exec.isTerminated());
        LOG.debug("SingleEXEC is terminated? : " + this.singleExec.isTerminated());
    }

    private void processCompletedTask(DUResult duResult) {
        LOG.trace("******* Store the result of DU ('" + duResult.getAbsRootPath() + "')*******");
        LOG.debug("---- DU RESULT of '" + duResult.getAbsRootPath() + "' ----");
        LOG.info(duResult.toString());
        if (duResult.getCmdResult().equals((Object)ExitCode.SUCCESS)) {
            this.successResults.add(duResult);
        } else {
            this.failureResults.add(duResult);
        }
        LOG.debug("------------------------------------------------------");
        SpaceInfoManager.getInstance().updateSA(duResult);
    }

    private class CompletionTask
    implements Runnable {
        private CompletionTask() {
        }

        private boolean completeTask() throws InterruptedException {
            LOG.debug("Checking for complete a task..");
            boolean poison = false;
            DUResult duResult = null;
            try {
                Future completedTask = BackgroundDU.this.completionService.take();
                BackgroundDU.this.completedTasks.add(completedTask);
                LOG.debug("Completed Tasks: " + BackgroundDU.this.completedTasks.size());
                duResult = (DUResult)completedTask.get(1L, TimeUnit.SECONDS);
                LOG.debug("Completed Task : " + duResult.toString());
                if (duResult.isPoisoned()) {
                    LOG.debug("POISONED the DU Completion Service!!!");
                    poison = true;
                } else {
                    BackgroundDU.this.toCheckTasks.remove(completedTask);
                }
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (!(cause instanceof InterruptedException)) {
                    LOG.error("Completion Task failed with unhandled exception", cause);
                }
            }
            catch (TimeoutException e) {
                LOG.info("Completion Task terminated due to a TimeOut. Cause: " + e.getCause().getMessage());
            }
            catch (CancellationException e) {
                LOG.info("Completion Task was cancelled. Cause: " + e.getCause().getMessage());
            }
            if (duResult != null) {
                BackgroundDU.this.processCompletedTask(duResult);
            } else {
                LOG.warn("DU completed but unable to manage the result (something wrong was happen).");
            }
            return poison;
        }

        @Override
        public void run() {
            try {
                boolean poison_pill = false;
                while (!Thread.currentThread().isInterrupted() && !poison_pill) {
                    poison_pill = this.completeTask();
                }
            }
            catch (InterruptedException ie) {
                LOG.info("CompletionTask has been terminated by an interruption. ");
                Thread.currentThread().interrupt();
            }
        }
    }
}

