/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.health;

import it.grid.storm.health.BookKeeper;
import it.grid.storm.health.LogEvent;
import it.grid.storm.health.OperationType;

public class SimpleBookKeeper
extends BookKeeper {
    public static final String KEY = "BK";

    @Override
    public synchronized void addLogEvent(LogEvent logEvent) {
        this.logbook.add(logEvent);
        this.logDebug("Event is added to Log Book (item #" + (this.logbook.size() - 1) + "");
        this.logInfo(logEvent.toString());
    }

    public synchronized int getNumberOfAsynchRequest() {
        int result = 0;
        for (int i = 0; i < this.logbook.size(); ++i) {
            if (((LogEvent)this.logbook.get(i)).getOperationType().isSynchronousOperation()) continue;
            ++result;
        }
        return result;
    }

    public synchronized int getNumberOfSynchRequest() {
        int result = 0;
        for (int i = 0; i < this.logbook.size(); ++i) {
            if (!((LogEvent)this.logbook.get(i)).getOperationType().isSynchronousOperation()) continue;
            ++result;
        }
        return result;
    }

    public synchronized int getNumberOfRequest(OperationType opType) {
        int result = 0;
        for (int i = 0; i < this.logbook.size(); ++i) {
            if (!((LogEvent)this.logbook.get(i)).getOperationType().equals(opType)) continue;
            ++result;
        }
        return result;
    }

    public synchronized long getMeansDuration(OperationType opType) {
        long meanTime = 0L;
        long sumTime = 0L;
        int requestNumber = this.getNumberOfRequest(opType);
        if (requestNumber > 0) {
            for (int i = 0; i < this.logbook.size(); ++i) {
                if (!((LogEvent)this.logbook.get(i)).getOperationType().equals(opType)) continue;
                sumTime += ((LogEvent)this.logbook.get(i)).getDuration();
            }
            meanTime = sumTime / (long)requestNumber;
        }
        return meanTime;
    }

    public synchronized int getNumberOfSuccess(OperationType opType) {
        int result = 0;
        int requestNumber = this.getNumberOfRequest(opType);
        if (requestNumber > 0) {
            for (int i = 0; i < this.logbook.size(); ++i) {
                LogEvent logE = (LogEvent)this.logbook.get(i);
                if (!logE.getOperationType().equals(opType) || !logE.isSuccess()) continue;
                ++result;
            }
        }
        return result;
    }
}

