/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.health;

import it.grid.storm.health.HealthDirector;
import it.grid.storm.health.HealthMonitor;
import it.grid.storm.health.LogEvent;
import it.grid.storm.health.OperationType;
import it.grid.storm.health.PerformanceEvent;
import java.util.ArrayList;
import java.util.Hashtable;
import org.slf4j.Logger;

public class PerformanceStatus {
    private Logger PERF_LOG = HealthDirector.getPerformanceLogger();
    private String pulseNumberStr = "";
    private Hashtable<OperationType, PerformanceEvent> perfStatus = new Hashtable();
    private static int timeWindows;

    public PerformanceStatus(ArrayList<LogEvent> eventToAnalyze) {
        this.PERF_LOG.debug("PERFORMANCE STATUS");
        if (eventToAnalyze != null) {
            this.PERF_LOG.debug("PERFORMANCE STATUS :" + eventToAnalyze.size());
            for (LogEvent event : eventToAnalyze) {
                OperationType ot = event.getOperationType();
                PerformanceEvent pEvent = this.perfStatus.containsKey(ot) ? this.perfStatus.get(event.getOperationType()) : new PerformanceEvent(ot);
                pEvent.addLogEvent(event);
                this.perfStatus.put(ot, pEvent);
            }
        } else {
            this.PERF_LOG.debug("NO EVENTS TO ANALYZE!!!");
        }
    }

    public void setPulseNumber(long number) {
        this.pulseNumberStr = number + "";
        String prefix = "";
        for (int i = 0; i < 6 - this.pulseNumberStr.length(); ++i) {
            prefix = prefix + ".";
        }
        this.pulseNumberStr = prefix + this.pulseNumberStr;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("#" + this.pulseNumberStr + ": ");
        if (this.perfStatus.isEmpty()) {
            result.append("No activity in the last " + timeWindows + " seconds");
        } else {
            result.append("\n=== last " + timeWindows + " seconds ===\n");
            for (PerformanceEvent pEvent : this.perfStatus.values()) {
                result.append(pEvent);
                result.append("\n");
            }
        }
        return result.toString();
    }

    static {
        HealthDirector.getHealthMonitor();
        timeWindows = HealthMonitor.perfGlanceTimeInterval;
    }
}

