/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.health;

import it.grid.storm.health.LogEvent;
import it.grid.storm.health.OperationType;

public class PerformanceEvent {
    private OperationType opType = OperationType.UNDEF;
    private int numberOfOperation = 0;
    private long minExecutionDuration = Long.MAX_VALUE;
    private long maxExecutionDuration = Long.MIN_VALUE;
    private long meanExecutionDuration = 0L;
    private long totExecutionDuration = 0L;

    public PerformanceEvent(OperationType op) {
        this.opType = op;
    }

    public void addLogEvent(LogEvent logEvent) {
        if (logEvent.getOperationType().equals(this.opType)) {
            ++this.numberOfOperation;
            long executionDuration = logEvent.getDuration();
            if (executionDuration < this.minExecutionDuration) {
                this.minExecutionDuration = executionDuration;
            }
            if (executionDuration > this.maxExecutionDuration) {
                this.maxExecutionDuration = executionDuration;
            }
            this.totExecutionDuration += executionDuration;
            this.meanExecutionDuration = this.totExecutionDuration / (long)this.numberOfOperation;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.opType.toString());
        sb.append(" [ ");
        sb.append("#" + this.numberOfOperation);
        sb.append(", ");
        sb.append(" min:" + this.minExecutionDuration);
        sb.append(", ");
        sb.append(" Max:" + this.maxExecutionDuration);
        sb.append(", ");
        sb.append(" Mean:" + this.meanExecutionDuration);
        sb.append(", ");
        sb.append(" TOT:" + this.totExecutionDuration);
        sb.append(" ]");
        return sb.toString();
    }
}

