/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.health;

import it.grid.storm.health.BookKeeper;
import it.grid.storm.health.HealthDirector;
import it.grid.storm.health.LogEvent;
import it.grid.storm.health.PerformanceStatus;
import java.util.ArrayList;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.TimeUnit;

public class PerformanceBookKeeper
extends BookKeeper {
    public static final String KEY = "PERF";
    private static long THOUSAND = 1000L;
    private DelayQueue<LogEvent> timedLogBook = new DelayQueue();
    private int lengthInSeconds = 0;
    private long lengthInMSec = 0L;
    private long visibleToGlancerInMSec = 0L;

    public PerformanceBookKeeper(int timeWindowInSecond, int glancerPeriodInSec) {
        this.lengthInSeconds = timeWindowInSecond;
        this.lengthInMSec = (long)timeWindowInSecond * THOUSAND;
        this.visibleToGlancerInMSec = (long)glancerPeriodInSec * THOUSAND;
    }

    @Override
    public void addLogEvent(LogEvent logEvent) {
        boolean result = this.timedLogBook.offer(logEvent);
        HealthDirector.LOGGER.debug("TimedLOGBOOK (offering result) " + result);
        HealthDirector.LOGGER.debug("TimedLOGBOOK :" + this.timedLogBook.size());
    }

    public long getGlanceWindowInMSec() {
        return this.visibleToGlancerInMSec;
    }

    public int getTimeWindowInSecond() {
        return this.lengthInSeconds;
    }

    public ArrayList<LogEvent> removeZombieEvents() {
        ArrayList<LogEvent> zombies = new ArrayList<LogEvent>();
        int nZombies = this.timedLogBook.drainTo(zombies);
        this.logDebug("Removed " + nZombies + "oldest event in Delayed log book.");
        return zombies;
    }

    public ArrayList<LogEvent> getCompleteSnapshot() {
        this.removeZombieEvents();
        ArrayList<LogEvent> snapshot = new ArrayList<LogEvent>(this.timedLogBook);
        return snapshot;
    }

    public ArrayList<LogEvent> getEventsGlanced(long timeToLiveGraterThan) {
        ArrayList<LogEvent> eGlanced = new ArrayList<LogEvent>();
        this.removeZombieEvents();
        for (LogEvent event : this.timedLogBook) {
            if (event.getDelay(TimeUnit.MILLISECONDS) >= timeToLiveGraterThan) continue;
            eGlanced.add(event);
        }
        return eGlanced;
    }

    public PerformanceStatus getPerformanceStatus(long timeToLiveGraterThan) {
        PerformanceStatus pStatus = new PerformanceStatus(this.getEventsGlanced(timeToLiveGraterThan));
        return pStatus;
    }

    public PerformanceStatus getPerformanceStatus() {
        return this.getPerformanceStatus(this.visibleToGlancerInMSec);
    }
}

