/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.health;

import it.grid.storm.config.Configuration;
import it.grid.storm.health.HealthMonitor;
import it.grid.storm.logging.StoRMLoggers;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;

public class HealthDirector {
    public static final Logger LOGGER = StoRMLoggers.getHBLogger();
    public static final Logger HEARTLOG = StoRMLoggers.getHBLogger();
    private static final Logger BOOKKEEPING = StoRMLoggers.getBKLogger();
    private static final Logger PERFLOG = StoRMLoggers.getPerfLogger();
    private static boolean initialized = false;
    private static HealthMonitor healthMonitorIstance = null;
    private static boolean bookKeepingConfigured = false;
    private static boolean bookKeepingEnabled = false;
    private static boolean performanceMonitorConfigured = false;
    private static boolean performanceMonitorEnabled = false;
    private static long bornInstant = -1L;
    private static String bornInstantStr = null;
    public static int timeToLiveLogEventInSec = Configuration.getInstance().getPerformanceLogbookTimeInterval();

    public static void initializeDirector(boolean testingMode) {
        bookKeepingEnabled = Configuration.getInstance().getBookKeepingEnabled();
        if (bookKeepingEnabled) {
            bookKeepingConfigured = true;
        }
        int statusPeriod = Configuration.getInstance().getHearthbeatPeriod();
        if (testingMode) {
            statusPeriod = 5;
        }
        bornInstant = System.currentTimeMillis();
        Date date = new Date(bornInstant);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy.MM.dd HH.mm.ss");
        bornInstantStr = formatter.format(date);
        healthMonitorIstance = new HealthMonitor(1, statusPeriod);
        performanceMonitorEnabled = Configuration.getInstance().getPerformanceMeasuring();
        if (performanceMonitorEnabled) {
            int glanceTimeInterval = Configuration.getInstance().getPerformanceGlanceTimeInterval();
            LOGGER.debug("----- Performance GLANCE Time Interval = " + glanceTimeInterval);
            LOGGER.debug("----- Performance LOGBOOK Time Interval = " + timeToLiveLogEventInSec);
            healthMonitorIstance.initializePerformanceMonitor(timeToLiveLogEventInSec, glanceTimeInterval);
        }
        initialized = true;
    }

    private static String getHealthPatternLayout() {
        String pattern = "[%d{ISO8601}]: %m%n";
        return pattern;
    }

    private static String getBookKeppingPatternLayout() {
        String pattern = "[%d{ISO8601}]: %-5p [%t] %x -%m%n";
        return pattern;
    }

    private static String getPerformanceMonitoringPatternLayout() {
        String pattern = "[%d{ISO8601}]: %m%n";
        return pattern;
    }

    public static Logger getLogger() {
        return LOGGER;
    }

    public static Logger getHealthLogger() {
        return HEARTLOG;
    }

    public static Logger getBookkeepingLogger() {
        return BOOKKEEPING;
    }

    public static Logger getPerformanceLogger() {
        return PERFLOG;
    }

    public static boolean isBookKeepingConfigured() {
        return bookKeepingConfigured;
    }

    public static boolean isBookKeepingEnabled() {
        return bookKeepingEnabled;
    }

    public static boolean isPerformanceMonitorConfigured() {
        return performanceMonitorConfigured;
    }

    public static boolean isPerformanceMonitorEnabled() {
        return performanceMonitorEnabled;
    }

    public static Logger getBookKeepingLogger() {
        return BOOKKEEPING;
    }

    public static HealthMonitor getHealthMonitor() {
        if (!initialized) {
            HealthDirector.initializeDirector(false);
        }
        return healthMonitorIstance;
    }

    public static HealthMonitor getHealthMonitor(boolean testingMode) {
        if (!initialized) {
            HealthDirector.initializeDirector(testingMode);
        }
        return healthMonitorIstance;
    }

    public static long getBornInstant(boolean testingMode) {
        if (!initialized) {
            HealthDirector.initializeDirector(testingMode);
        }
        return bornInstant;
    }

    public static String getBornInstantStr(boolean testingMode) {
        if (!initialized) {
            HealthDirector.initializeDirector(testingMode);
        }
        return bornInstantStr;
    }

    public static long getBornInstant() {
        if (!initialized) {
            HealthDirector.initializeDirector(false);
        }
        return bornInstant;
    }

    public static String getBornInstantStr() {
        if (!initialized) {
            HealthDirector.initializeDirector(false);
        }
        return bornInstantStr;
    }
}

