/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.health;

import it.grid.storm.health.HealthDirector;
import it.grid.storm.health.OperationType;
import it.grid.storm.health.SimpleBookKeeper;
import it.grid.storm.health.StoRMStatus;
import org.slf4j.Logger;

public class DetectiveGlance {
    private static Logger log = HealthDirector.LOGGER;
    private static long totPtGRequest = 0L;
    private static long totPtPRequest = 0L;
    private static long totSYNCHRequest = 0L;

    private static long getHeapSize() {
        long heapSize = Runtime.getRuntime().totalMemory();
        return heapSize;
    }

    private static long getHeapMaxSize() {
        long heapMaxSize = Runtime.getRuntime().maxMemory();
        return heapMaxSize;
    }

    private static long getHeapFreeSize() {
        long heapFreeSize = Runtime.getRuntime().freeMemory();
        return heapFreeSize;
    }

    public static void addPtGRequests(int nrPtGRequest) {
        totPtGRequest += (long)nrPtGRequest;
    }

    public static void addPtPRequests(int nrPtPRequest) {
        totPtPRequest += (long)nrPtPRequest;
    }

    public static void addSynchRequest(int nrSynchRequest) {
        totSYNCHRequest += (long)nrSynchRequest;
    }

    public StoRMStatus haveaLook() {
        log.debug(" The glange of the Detective..");
        StoRMStatus stormStatus = new StoRMStatus();
        stormStatus.setHeapFreeSize(DetectiveGlance.getHeapFreeSize());
        stormStatus.setMAXHeapSize(DetectiveGlance.getHeapMaxSize());
        stormStatus.setHeapSize(DetectiveGlance.getHeapSize());
        SimpleBookKeeper bk = HealthDirector.getHealthMonitor().getSimpleBookKeeper();
        if (bk != null) {
            int ptgReq = bk.getNumberOfRequest(OperationType.PTG);
            DetectiveGlance.addPtGRequests(ptgReq);
            int ptgSucc = bk.getNumberOfSuccess(OperationType.PTG);
            long meanPtG = bk.getMeansDuration(OperationType.PTG);
            stormStatus.setPtGNumberRequests(ptgReq);
            stormStatus.setPtGSuccessRequests(ptgSucc);
            stormStatus.setPtGMeanDuration(meanPtG);
            stormStatus.setTotalPtGRequest(totPtGRequest);
            int ptpReq = bk.getNumberOfRequest(OperationType.PTP);
            DetectiveGlance.addPtPRequests(ptpReq);
            int ptpSucc = bk.getNumberOfSuccess(OperationType.PTP);
            long meanPtP = bk.getMeansDuration(OperationType.PTP);
            stormStatus.setPtPNumberRequests(ptpReq);
            stormStatus.setPtPSuccessRequests(ptpSucc);
            stormStatus.setPtPMeanDuration(meanPtP);
            stormStatus.setTotalPtPRequest(totPtPRequest);
            int synchRequest = bk.getNumberOfSynchRequest();
            DetectiveGlance.addSynchRequest(synchRequest);
            stormStatus.setSynchRequest(synchRequest);
            stormStatus.calculateLifeTime();
            bk.cleanLogBook();
            log.debug(" .. glance completed.");
        } else {
            log.warn("No SympleBookKeper available from HealtMonitor!");
        }
        return stormStatus;
    }
}

