/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.griduser;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VONameMatchingRule {
    private static final String ADMIT_ALL = ".*";
    private final String voNameString;
    private Pattern voNamePattern = null;

    public VONameMatchingRule(String regularExpressionRule) {
        this.voNameString = regularExpressionRule == null || regularExpressionRule.equals("*") ? ADMIT_ALL : regularExpressionRule;
        this.initPattern();
    }

    public static VONameMatchingRule buildMatchAllVONameMatchingRule() {
        return new VONameMatchingRule(ADMIT_ALL);
    }

    private void initPattern() {
        this.voNamePattern = VONameMatchingRule.isMatchAll(this.voNameString) ? Pattern.compile(ADMIT_ALL) : Pattern.compile(this.voNameString);
    }

    private static boolean isMatchAll(String pattern) {
        return pattern == null || pattern.trim().equals("*") || pattern.trim().equals(ADMIT_ALL);
    }

    public boolean match(String voName) {
        boolean result = false;
        CharSequence voNameSequence = voName.subSequence(0, voName.length());
        Matcher voNameMatcher = this.voNamePattern.matcher(voNameSequence);
        result = voNameMatcher.find();
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(" VONAME=" + this.voNameString);
        return result.toString();
    }

    public boolean isMatchAll() {
        return VONameMatchingRule.isMatchAll(this.voNameString);
    }
}

