/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.griduser;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalUser {
    private static final Logger log = LoggerFactory.getLogger(LocalUser.class);
    private int uid;
    private int[] gids;

    public LocalUser(int uid, int[] gids, long ngids) {
        this.uid = uid;
        this.gids = new int[(int)ngids];
        int i = 0;
        while ((long)i < ngids) {
            this.gids[i] = gids[i];
            ++i;
        }
    }

    public LocalUser(int uid, int gid, int[] supplementaryGids) {
        this.uid = uid;
        this.gids = new int[1 + supplementaryGids.length];
        this.gids[0] = gid;
        for (int i = 1; i <= supplementaryGids.length; ++i) {
            this.gids[i] = supplementaryGids[i - 1];
        }
    }

    public LocalUser(int uid, int gid) {
        this(uid, gid, new int[0]);
    }

    public LocalUser(String uidgids) {
        String[] aux;
        this.uid = 501;
        this.gids = new int[1];
        this.gids[0] = 501;
        if (uidgids != null && (aux = uidgids.split(",")).length >= 2) {
            try {
                int auxuid = Integer.parseInt(aux[0]);
                int[] auxgid = new int[aux.length - 1];
                for (int i = 0; i < aux.length - 1; ++i) {
                    auxgid[i] = Integer.parseInt(aux[i + 1]);
                }
                this.uid = auxuid;
                this.gids = auxgid;
            }
            catch (NumberFormatException e) {
                log.error("LocalUser: Error while setting uid/gid. NFE:" + e);
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.uid);
        for (int i = 0; i < this.gids.length; ++i) {
            sb.append(",");
            sb.append(this.gids[i]);
        }
        return sb.toString();
    }

    public String getLocalUserName() {
        return Integer.toString(this.getUid());
    }

    public int getUid() {
        return this.uid;
    }

    public int[] getGids() {
        return this.gids;
    }

    public int getPrimaryGid() {
        return this.gids[0];
    }
}

