/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.griduser;

import com.sun.jna.LastErrorException;
import it.grid.storm.griduser.CannotMapUserException;
import it.grid.storm.griduser.LocalUser;
import it.grid.storm.griduser.MapperInterface;
import it.grid.storm.jna.lcmaps.LcmapsAccountInterface;
import it.grid.storm.jna.lcmaps.LcmapsInterface;
import it.grid.storm.jna.lcmaps.LcmapsPoolindexInterface;
import it.grid.storm.jna.lcmaps.lcmaps_account_info_t;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LcmapsJNAMapper
implements MapperInterface {
    private static final Object lock = new Object();
    private static final Logger log = LoggerFactory.getLogger(LcmapsJNAMapper.class);
    private lcmaps_account_info_t account = new lcmaps_account_info_t();
    private final String LCMAPS_DEFAULT_LOG_FILE = "/var/log/lcmaps.log";
    private final String LCMAPS_LOG_FILE_PATH_ENV_VARIABLE = "LCMAPS_LOG_FILE";
    private final short LCMAPS_LOG_TYPE = (short)3;

    private String getLcmapsLogFile() {
        String lcmaps_log_file = System.getenv("LCMAPS_LOG_FILE");
        if (lcmaps_log_file == null) {
            lcmaps_log_file = "/var/log/lcmaps.log";
        }
        return lcmaps_log_file.trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LocalUser map(String dn, String[] fqans) throws CannotMapUserException {
        LocalUser mappedUser = null;
        Object object = lock;
        synchronized (object) {
            log.debug("Mapping user with dn = " + dn + " and fqans = " + ArrayUtils.toString((Object)fqans));
            log.debug("Initializing Lcmaps");
            String lcmapsLogFile = this.getLcmapsLogFile();
            log.debug("Lcmaps log file is " + lcmapsLogFile);
            int retVal = LcmapsInterface.INSTANCE.lcmaps_init_and_logfile(lcmapsLogFile, null, (short)3);
            if (retVal != 0) {
                log.error("Unable to initialize lcmaps. Return value is " + retVal);
                throw new CannotMapUserException("Unable to initialize lcmaps. Return value is " + retVal);
            }
            retVal = LcmapsAccountInterface.INSTANCE.lcmaps_account_info_init(this.account);
            if (retVal != 0) {
                log.error("Unable to initialize lcmaps. Return value is " + retVal);
                throw new CannotMapUserException("Unable to initialize lcmaps. Return value is " + retVal);
            }
            int numFqans = fqans == null ? 0 : fqans.length;
            try {
                retVal = LcmapsPoolindexInterface.INSTANCE.lcmaps_return_account_without_gsi(dn, fqans, numFqans, 0, this.account);
            }
            catch (LastErrorException e) {
                log.error("Unable to map user dn <" + dn + "> fqans <" + ArrayUtils.toString((Object)fqans) + "> . LastErrorException: " + e.getMessage() + " , error code = " + e.getErrorCode());
                throw new CannotMapUserException("Unable to initialize lcmaps. Return value is " + retVal);
            }
            if (retVal != 0) {
                log.error("Unable to map user dn <" + dn + "> fqans <" + ArrayUtils.toString((Object)fqans) + "> . Return value is " + retVal);
                throw new CannotMapUserException("Unable to map user dn <" + dn + "> fqans <" + ArrayUtils.toString((Object)fqans) + "> . Return value is " + retVal);
            }
            if (this.account.uid < 0) {
                log.error("Unacceptable lower than zero uid returned by Lcmaps : " + this.account.uid + " . Mapping error");
                throw new CannotMapUserException("Unacceptable lower than zero uid returned by Lcmaps : " + this.account.uid + " . Mapping error");
            }
            if (this.account.npgid < 0 || this.account.nsgid < 0) {
                log.error("Unacceptable primary or secondary gid array size returned by Lcmaps : primary = " + this.account.npgid + ", secondary = " + this.account.nsgid + ",. Mapping error");
                throw new CannotMapUserException("Unacceptable primary or secondary gid array size returned by Lcmaps : primary = " + this.account.npgid + ", secondary = " + this.account.nsgid + ",. Mapping error");
            }
            int[] gids = null;
            int numGids = this.account.npgid + this.account.nsgid;
            if (numGids > this.account.npgid) {
                int gid;
                int i$;
                int len$;
                int[] arr$;
                gids = new int[numGids];
                int index = 0;
                if (this.account.npgid > 0) {
                    arr$ = this.account.pgid_list.getPointer().getIntArray(0L, this.account.npgid);
                    len$ = arr$.length;
                    for (i$ = 0; i$ < len$; ++i$) {
                        gids[index] = gid = arr$[i$];
                        ++index;
                    }
                } else {
                    log.warn("No primary gid returned by Lcmaps! Mapping error");
                }
                arr$ = this.account.sgid_list.getPointer().getIntArray(0L, this.account.nsgid);
                len$ = arr$.length;
                for (i$ = 0; i$ < len$; ++i$) {
                    gids[index] = gid = arr$[i$];
                    ++index;
                }
            } else if (this.account.npgid > 0) {
                gids = this.account.pgid_list.getPointer().getIntArray(0L, this.account.npgid);
            }
            log.info("Mapped user to : <uid=" + this.account.uid + ",gids=" + ArrayUtils.toString((Object)gids) + ">");
            mappedUser = new LocalUser(this.account.uid, gids, numGids);
        }
        return mappedUser;
    }
}

