/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.griduser;

import it.grid.storm.griduser.SubjectAttribute;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FQAN
implements SubjectAttribute {
    private static Pattern fqanPattern = Pattern.compile("/[\\w-\\.]+(/[\\w-\\.]+)*(/Role=[\\w-\\.]+)?(/Capability=[\\w-\\.]+)?");
    private static final char VO_FQAN_ESCAPE_CHAR = '/';
    private String fqan;
    private String vo;
    private String group;
    private String role;
    private String capability;
    private boolean checkFormedness = true;

    public FQAN(String fqan) throws IllegalArgumentException {
        this(fqan, true);
    }

    public FQAN(String fqan, boolean checkFormedness) throws IllegalArgumentException {
        this.checkFormedness = checkFormedness;
        this.setFqan(fqan);
        if (!this.parseFqan(fqan)) {
            throw new IllegalArgumentException("The VO for a FQAN can't be null! FQAN string = " + fqan);
        }
        this.generateFqan();
    }

    public FQAN(String vo, String group, String role, String capability) {
        if (vo == null) {
            throw new IllegalArgumentException("The VO for a FQAN can't be null");
        }
        this.setVo(vo);
        this.setGroup(group);
        this.setRole(role);
        this.setCapability(capability);
        this.generateFqan();
    }

    public static FQAN makeVoFQAN(String voName) {
        return new FQAN('/' + voName);
    }

    public String getVo() {
        return this.vo;
    }

    public String getGroup() {
        StringBuffer sb = new StringBuffer();
        sb.append("/");
        sb.append(this.vo);
        if (this.group != null) {
            sb.append(this.group);
        }
        return sb.toString();
    }

    public String getSubGroup() {
        return this.group;
    }

    public String getRole() {
        return this.role;
    }

    public boolean isRoleNULL() {
        return this.role == null || this.role.toUpperCase().equals("NULL");
    }

    public boolean isCapabilityNULL() {
        return this.capability == null || this.capability.toUpperCase().equals("NULL");
    }

    public String getCapability() {
        return this.capability;
    }

    private void generateFqan() {
        if (this.vo == null) {
            this.fqan = null;
            return;
        }
        StringBuffer bf = new StringBuffer();
        bf.append('/');
        bf.append(this.vo);
        if (this.group != null) {
            bf.append(this.group);
        }
        if (this.role != null) {
            bf.append("/Role=");
            bf.append(this.role);
        }
        if (this.capability != null) {
            bf.append("/Capability=");
            bf.append(this.capability);
        }
        this.fqan = bf.toString();
    }

    private boolean parseFqan(String fqan) {
        Matcher m = fqanPattern.matcher(fqan);
        if (!m.matches()) {
            if (this.checkFormedness) {
                throw new IllegalArgumentException("FQAN '" + fqan + "' is malformed (syntax: /VO[/group[/subgroup(s)]][/Role=role][/Capability=cap])");
            }
            return false;
        }
        this.vo = null;
        this.group = null;
        this.role = null;
        this.capability = null;
        StringTokenizer stk = new StringTokenizer(fqan, "/");
        if (!stk.hasMoreTokens()) {
            return false;
        }
        this.vo = stk.nextToken();
        if (!stk.hasMoreTokens()) {
            return true;
        }
        String tempGroup = "";
        String token = stk.nextToken();
        while (!token.startsWith("Role=") && !token.startsWith("Capability=")) {
            this.group = tempGroup = tempGroup + "/" + token;
            if (!stk.hasMoreTokens()) {
                return true;
            }
            token = stk.nextToken();
        }
        if (token.startsWith("Role=")) {
            this.setRole(token.substring(5));
            if (!stk.hasMoreTokens()) {
                return true;
            }
            token = stk.nextToken();
        }
        if (token.startsWith("Capability=")) {
            this.setCapability(token.substring(11));
        }
        return true;
    }

    private void setCapability(String capability) {
        if (capability != null && !capability.matches("[\\w-\\.]+")) {
            throw new IllegalArgumentException("The capability '" + capability + "' is malformed");
        }
        this.capability = capability;
    }

    private void setFqan(String fqan) {
        this.fqan = fqan;
    }

    private void setGroup(String group) {
        if (group != null && !group.matches("(/[\\w-\\.]+)+")) {
            throw new IllegalArgumentException("The group '" + group + "' is malformed");
        }
        this.group = group;
    }

    private void setRole(String role) {
        if (role != null && !role.matches("[\\w-\\.]+")) {
            throw new IllegalArgumentException("The role '" + role + "' is malformed");
        }
        this.role = role;
        if ("NULL".equalsIgnoreCase(role)) {
            this.role = null;
        }
    }

    private void setVo(String vo) {
        if (vo != null && !vo.matches("[\\w-\\.]+")) {
            throw new IllegalArgumentException("The vo '" + vo + "' is malformed");
        }
        this.vo = vo;
    }

    public int hashCode() {
        if (this.fqan == null) {
            return 0;
        }
        return this.fqan.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof FQAN) {
            FQAN fqan2 = (FQAN)obj;
            return fqan2.fqan == null ? this.fqan == null : fqan2.fqan.equalsIgnoreCase(this.fqan);
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb = sb.append(this.getGroup());
        sb.append("/Role=" + (this.role != null ? this.getRole() : "NULL"));
        if (this.capability != null) {
            sb.append("/Capability=" + this.getCapability());
        }
        return sb.toString();
    }
}

