/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.griduser;

import it.grid.storm.griduser.SubjectAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import javax.security.auth.x500.X500Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistinguishedName
implements SubjectAttribute {
    private static final Logger log = LoggerFactory.getLogger(DistinguishedName.class);
    private String countryName = null;
    private String provinceName = null;
    private String organizationName = null;
    private String localityName = null;
    private String canonizedProxyDN = null;
    private final ArrayList<String> organizationalUnitNames = new ArrayList();
    private final ArrayList<String> commonNames = new ArrayList();
    private final ArrayList<String> domainComponents = new ArrayList();
    private String eMailAddress = null;
    private String distinguishedName = null;
    private X500Principal x500DN = null;

    public DistinguishedName(String stringDN) {
        if (stringDN != null) {
            this.distinguishedName = stringDN;
            int slashIndex = this.distinguishedName.indexOf(47);
            int commaIndex = this.distinguishedName.indexOf(44);
            if (slashIndex > -1) {
                this.parseDNslahed();
                this.buildX500DN();
            }
            if (commaIndex > -1) {
                this.parseDNcommed();
                this.builderWithMap(stringDN);
            }
        } else {
            this.distinguishedName = "empty";
        }
    }

    private void builderWithMap(String stringDN) {
        String[] couples = stringDN.split(",");
        HashMap<String, String> pairs = new HashMap<String, String>();
        for (String couple : couples) {
            if (!couple.contains("=")) continue;
            String key = couple.split("=")[0];
            String value = couple.split("=")[1];
            pairs.put(key, value);
        }
        if (pairs.size() > 0) {
            log.error("To use this functionality (DN rfc 2253) you have to recompile with Java 1.6");
        }
    }

    private void assignAttributes(String[] dnChunk) {
        if (dnChunk != null) {
            int length = dnChunk.length;
            for (int i = 0; i < length; ++i) {
                if (dnChunk[i].startsWith("C=")) {
                    this.countryName = dnChunk[i].substring(2, dnChunk[i].length());
                }
                if (dnChunk[i].startsWith("ST=")) {
                    this.provinceName = dnChunk[i].substring(3, dnChunk[i].length());
                }
                if (dnChunk[i].startsWith("O=")) {
                    this.organizationName = dnChunk[i].substring(2, dnChunk[i].length());
                }
                if (dnChunk[i].startsWith("OU=")) {
                    this.organizationalUnitNames.add(dnChunk[i].substring(3, dnChunk[i].length()));
                }
                if (dnChunk[i].startsWith("L=")) {
                    this.localityName = dnChunk[i].substring(2, dnChunk[i].length());
                }
                if (dnChunk[i].startsWith("CN=")) {
                    this.commonNames.add(dnChunk[i].substring(3, dnChunk[i].length()));
                }
                if (dnChunk[i].startsWith("DC=")) {
                    this.domainComponents.add(dnChunk[i].substring(3, dnChunk[i].length()));
                }
                if (dnChunk[i].startsWith("Email=")) {
                    this.eMailAddress = dnChunk[i].substring(6, dnChunk[i].length());
                }
                if (dnChunk[i].startsWith("E=")) {
                    this.eMailAddress = dnChunk[i].substring(2, dnChunk[i].length());
                }
                if (!dnChunk[i].startsWith("EMailAddress=")) continue;
                this.eMailAddress = dnChunk[i].substring(13, dnChunk[i].length());
            }
        }
    }

    private void parseDNslahed() {
        ArrayList<String> list = new ArrayList<String>();
        String DN = this.distinguishedName;
        boolean stop = false;
        while (!stop) {
            int indexOfEq = DN.lastIndexOf(61);
            if (indexOfEq == -1) {
                stop = true;
                continue;
            }
            String tmpDN = DN.substring(0, indexOfEq);
            int indexOfAttr = tmpDN.lastIndexOf(47);
            list.add(DN.substring(indexOfAttr + 1, DN.length()));
            DN = DN.substring(0, indexOfAttr);
        }
        StringBuffer sb = new StringBuffer();
        String[] attributes = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            if (i == list.size() - 1) {
                sb.append((String)list.get(list.size() - 1 - i));
            } else {
                sb.append((String)list.get(list.size() - 1 - i) + ",");
            }
            attributes[i] = (String)list.get(list.size() - 1 - i);
        }
        this.canonizedProxyDN = sb.toString();
        this.assignAttributes(attributes);
    }

    private void parseDNcommed() {
        String[] attributes = this.distinguishedName.split(",");
        this.assignAttributes(attributes);
    }

    private void buildX500DN() {
        this.x500DN = new X500Principal(this.canonizedProxyDN);
    }

    public String getX500DNString(String format) {
        return this.x500DN != null ? this.x500DN.getName(format) : "";
    }

    public X500Principal getX500DN() {
        return this.x500DN;
    }

    public String getX500DN_rfc1779() {
        return this.x500DN != null ? this.x500DN.getName("RFC1779") : "";
    }

    public String getX500DN_canonical() {
        return this.x500DN != null ? this.x500DN.getName("CANONICAL") : "";
    }

    public String getX500DN_rfc2253() {
        return this.x500DN != null ? this.x500DN.getName("RFC2253") : "";
    }

    public String getCountryName() {
        return this.countryName;
    }

    public String getProvinceName() {
        return this.provinceName;
    }

    public String getOrganizationName() {
        return this.organizationName;
    }

    public ArrayList<String> getOrganizationalUnitNames() {
        return this.organizationalUnitNames;
    }

    public ArrayList<String> getDomainComponents() {
        return this.domainComponents;
    }

    public String getLocalityName() {
        return this.localityName;
    }

    public ArrayList<String> getCommonNames() {
        return this.commonNames;
    }

    public String getEMail() {
        return this.eMailAddress;
    }

    public String getDN() {
        return this.distinguishedName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DistinguishedName)) {
            return false;
        }
        DistinguishedName dn = (DistinguishedName)o;
        return this.x500DN.equals(dn.getX500DN());
    }

    public int hashCode() {
        int result = 17;
        if (this.x500DN != null) {
            result += 31 * this.x500DN.hashCode();
        }
        return result;
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer();
        if (this.countryName != null) {
            result.append("C=" + this.countryName + "\n");
        }
        if (this.provinceName != null) {
            result.append("ST=" + this.provinceName + "\n");
        }
        if (this.organizationName != null) {
            result.append("O=" + this.organizationName + "\n");
        }
        if (this.organizationalUnitNames != null) {
            for (String string : this.organizationalUnitNames) {
                result.append("OU=" + string + "\n");
            }
        }
        if (this.localityName != null) {
            result.append("L=" + this.localityName + "\n");
        }
        if (this.commonNames != null) {
            for (String string : this.commonNames) {
                result.append("CN=" + string + "\n");
            }
        }
        if (this.domainComponents != null) {
            for (String string : this.domainComponents) {
                result.append("DC=" + string + "\n");
            }
        }
        if (this.eMailAddress != null) {
            result.append("EMail=" + this.eMailAddress + "\n");
        }
        return result.toString();
    }
}

