/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.griduser;

import it.grid.storm.common.types.VO;
import it.grid.storm.griduser.CannotMapUserException;
import it.grid.storm.griduser.DistinguishedName;
import it.grid.storm.griduser.FQAN;
import it.grid.storm.griduser.GridUserInterface;
import it.grid.storm.griduser.LocalUser;
import it.grid.storm.griduser.MapperInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGridUser
implements GridUserInterface {
    protected static final Logger log = LoggerFactory.getLogger(AbstractGridUser.class);
    protected DistinguishedName subjectDN = null;
    protected String proxyString = null;
    protected MapperInterface userMapperClass = null;
    protected LocalUser localUser = null;

    protected AbstractGridUser(MapperInterface mapperClass, String distinguishedName) {
        if (mapperClass == null || distinguishedName == null) {
            log.error("Provided null parameter: mapperClass='" + mapperClass + "' distinguishedName='" + distinguishedName + "'");
            throw new IllegalArgumentException("Provided null parameter: mapperClass='" + mapperClass + "' distinguishedName='" + distinguishedName + "'");
        }
        this.userMapperClass = mapperClass;
        this.setDistinguishedName(distinguishedName);
    }

    protected AbstractGridUser(MapperInterface mapperClass, String distinguishedName, String proxy) {
        this(mapperClass, distinguishedName);
        this.setProxyString(proxy);
    }

    void setUserMapper(MapperInterface mapperClass) {
        if (mapperClass == null) {
            throw new IllegalArgumentException("Provided null MapperInterface!");
        }
        this.userMapperClass = mapperClass;
    }

    void setDistinguishedName(String dnString) {
        if (dnString == null) {
            throw new IllegalArgumentException("Provided null DistinguishedName!");
        }
        this.subjectDN = new DistinguishedName(dnString);
    }

    @Override
    public String getDn() {
        String dn = this.subjectDN.getDN();
        return dn;
    }

    @Override
    public DistinguishedName getDistinguishedName() {
        return this.subjectDN;
    }

    void setProxyString(String proxy) {
        this.proxyString = proxy;
    }

    public String getProxyString() {
        return this.proxyString;
    }

    public String getUserCredentials() {
        return this.proxyString;
    }

    @Override
    public LocalUser getLocalUser() throws CannotMapUserException {
        if (this.localUser == null) {
            try {
                this.localUser = this.hasVoms() ? this.userMapperClass.map(this.getDn(), this.getFQANsAsString()) : this.userMapperClass.map(this.getDn(), null);
            }
            catch (CannotMapUserException ex) {
                log.error("Error in mapping '" + this.subjectDN.getX500DN_rfc1779() + "' to a local user: " + ex.getMessage());
                throw ex;
            }
        }
        return this.localUser;
    }

    public abstract String[] getFQANsAsString();

    public abstract FQAN[] getFQANs();

    public abstract boolean hasVoms();

    public abstract VO getVO();
}

