/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.filesystem;

import it.grid.storm.filesystem.MtabRow;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MtabUtil {
    private static final Logger log = LoggerFactory.getLogger(MtabUtil.class);
    private static final String MTAB_FILE_PATH = "/etc/mtab";
    private static final int MTAB_DEVICE_INDEX = 0;
    private static final int MTAB_MOUNT_POINT_INDEX = 1;
    private static final int MTAB_FS_NAME_INDEX = 2;
    private static final int MTAB_MOUNT_OPTIONS_INDEX = 3;
    private static final int MTAB_DUMP_INDEX = 4;
    private static final int MTAB_FSC_ORDER_POSITION_INDEX = 5;

    public static String getFilePath() {
        return MTAB_FILE_PATH;
    }

    public static final int getMtabDeviceIndex() {
        return 0;
    }

    public static int getMountPointIndex() {
        return 1;
    }

    public static int getFsNameIndex() {
        return 2;
    }

    public static final int getMtabMountOptionsIndex() {
        return 3;
    }

    public static final int getMtabDumpIndex() {
        return 4;
    }

    public static final int getMtabFscOrderPositionIndex() {
        return 5;
    }

    protected static boolean skipLineForMountPoints(String line) {
        return line.startsWith("#") || !line.startsWith("/dev/");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getFSMountPoints() throws Exception {
        HashMap<String, String> mountPointToFSMap = new HashMap<String, String>();
        BufferedReader mtab = null;
        try {
            try {
                mtab = new BufferedReader(new FileReader(MtabUtil.getFilePath()));
            }
            catch (FileNotFoundException e) {
                log.error("Unable to find mtab file at " + MtabUtil.getFilePath() + " . FileNotFoundException: " + e.getMessage());
                throw new Exception("Unable to get mount points. mtab file not found");
            }
            try {
                String line;
                while ((line = mtab.readLine()) != null) {
                    if (MtabUtil.skipLineForMountPoints(line)) continue;
                    LinkedList<String> elementsList = MtabUtil.tokenizeLine(line);
                    if (elementsList.size() - 1 < MtabUtil.getMountPointIndex() || elementsList.size() - 1 < MtabUtil.getFsNameIndex()) {
                        log.warn("Unable to produce a valid file system mount point from line '" + line + "' . not enough elements in the tokenized array : " + elementsList.toString() + ". Skipping the line");
                        continue;
                    }
                    mountPointToFSMap.put(elementsList.get(MtabUtil.getMountPointIndex()), elementsList.get(MtabUtil.getFsNameIndex()));
                }
            }
            catch (IOException e) {
                log.error("Unable to read from mtab file at " + MtabUtil.getFilePath() + " . IOException: " + e.getMessage());
                throw new Exception("Unable to get mount points. Erro reading from mtab");
            }
        }
        finally {
            if (mtab != null) {
                try {
                    mtab.close();
                }
                catch (IOException iOException) {}
            }
        }
        return mountPointToFSMap;
    }

    public static List<MtabRow> getRows() throws IOException {
        String line;
        ArrayList<MtabRow> rows = new ArrayList<MtabRow>();
        BufferedReader mtab = new BufferedReader(new FileReader(MtabUtil.getFilePath()));
        while ((line = mtab.readLine()) != null) {
            if (MtabUtil.skipLineForMountPoints(line)) continue;
            log.debug("Creting an mtab row from string '" + line + "'");
            MtabRow row = null;
            try {
                row = MtabUtil.produceRow(line);
            }
            catch (IllegalArgumentException e) {
                log.warn("Unable to produce a valid row from line '" + line + "' . IllegalArgumentException : " + e.getMessage() + ". Skipping the line");
            }
            if (row == null) continue;
            rows.add(row);
        }
        log.debug("Produced " + rows.size() + " mtab rows from file at " + MTAB_FILE_PATH);
        return rows;
    }

    private static MtabRow produceRow(String line) throws IllegalArgumentException {
        LinkedList<String> elementsList = MtabUtil.tokenizeLine(line);
        return new MtabRow(elementsList);
    }

    public static LinkedList<String> tokenizeLine(String line) {
        String[] elementsArray = line.split(" ");
        LinkedList<String> elementsList = new LinkedList<String>(Arrays.asList(elementsArray));
        while (elementsList.remove("")) {
        }
        return elementsList;
    }
}

