/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.filesystem;

import java.util.ArrayList;
import java.util.List;

public class MtabRow {
    private final String device;
    private final String mountPoint;
    private final String fileSystem;
    private final List<String> mountOptions = new ArrayList<String>();
    private final boolean dump;
    private final int fsckOrderPosition;

    public MtabRow(String device, String mountPoint, String fileSystem, List<String> mountOptions, boolean dump, int fsckOrderPosition) {
        if (device == null || device.trim().equals("") || mountPoint == null || mountPoint.trim().equals("") || fileSystem == null || fileSystem.trim().equals("")) {
            throw new IllegalArgumentException("Received invalid arguments : device = " + device + " mountPoint = " + mountPoint + " fileSystem = " + fileSystem);
        }
        this.device = device;
        this.mountPoint = mountPoint;
        this.fileSystem = fileSystem;
        this.mountOptions.addAll(mountOptions);
        this.dump = dump;
        this.fsckOrderPosition = fsckOrderPosition;
    }

    public MtabRow(List<String> elementsList) throws IllegalArgumentException {
        Integer dumpValue;
        if (elementsList.size() < 5) {
            throw new IllegalArgumentException("Received an argument list of few than 5 elements (mandatory) : " + elementsList.toString());
        }
        for (int i = 0; i < 5; ++i) {
            if (elementsList.get(i) != null && elementsList.get(i).trim().length() != 0 || i == 3) continue;
            throw new IllegalArgumentException("Received an argument list where element at index " + i + " is invalid : '" + elementsList.get(i) + "'");
        }
        this.device = elementsList.get(0);
        this.mountPoint = elementsList.get(1);
        this.fileSystem = elementsList.get(2);
        if (elementsList.get(3) != null && elementsList.get(3).trim().length() > 0) {
            String[] mountOptionsArray;
            for (String mountOption : mountOptionsArray = elementsList.get(3).trim().split(",")) {
                if (mountOption.trim().length() <= 0) continue;
                this.mountOptions.add(mountOption.trim());
            }
        }
        try {
            dumpValue = Integer.parseInt(elementsList.get(4));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Received an illegal argument at index 4. It as to be an integer (the dump value), received value : " + elementsList.get(4) + " . NumberFormatException : " + e.getMessage());
        }
        if (dumpValue != 1 && dumpValue != 0) {
            throw new IllegalArgumentException("Received an illegal argument at index 4. It can be only 0 or 1, received value : " + elementsList.get(4));
        }
        this.dump = dumpValue != 0;
        try {
            this.fsckOrderPosition = Integer.parseInt(elementsList.get(5));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Received an illegal argument at index 5. It as to be an integer (the fsck order position value), received value : " + elementsList.get(4) + " . NumberFormatException : " + e.getMessage());
        }
    }

    public final String getDevice() {
        return this.device;
    }

    public final String getMountPoint() {
        return this.mountPoint;
    }

    public final String getFileSystem() {
        return this.fileSystem;
    }

    public final List<String> getMountOptions() {
        return this.mountOptions;
    }

    public final boolean isDump() {
        return this.dump;
    }

    public final int getFsckOrderPosition() {
        return this.fsckOrderPosition;
    }

    public String toString() {
        return "MtabRow [device=" + this.device + ", mountPoint=" + this.mountPoint + ", fileSystem=" + this.fileSystem + ", mountOptions=" + this.mountOptions + ", dump=" + this.dump + ", fsckOrderPosition=" + this.fsckOrderPosition + "]";
    }
}

