/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.filesystem;

import it.grid.storm.checksum.ChecksumManager;
import it.grid.storm.ea.FileNotFoundException;
import it.grid.storm.ea.StormEA;
import it.grid.storm.filesystem.FSException;
import it.grid.storm.filesystem.FileSystemCheckerException;
import it.grid.storm.filesystem.FileSystemCheckerFactory;
import it.grid.storm.filesystem.Filesystem;
import it.grid.storm.filesystem.FilesystemPermission;
import it.grid.storm.griduser.CannotMapUserException;
import it.grid.storm.griduser.LocalUser;
import it.grid.storm.jna.CUtilManager;
import it.grid.storm.jna.NoGPFSFileSystemException;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalFile {
    private static final Logger log = LoggerFactory.getLogger(LocalFile.class);
    private final Filesystem fs;
    private final File localFile;

    public LocalFile(LocalFile parent, String name, Filesystem fs) throws NullPointerException {
        this.localFile = new File(parent.localFile, name);
        assert (this.localFile.isAbsolute()) : "Non-absolute path in constructor File(File,String,Filesystem)";
        assert (null != fs) : "Null filesystem in constructor File(File,String,Filesystem)";
        this.fs = fs;
    }

    public LocalFile(String pathname, Filesystem fs) throws NullPointerException {
        this.localFile = new File(pathname);
        assert (this.localFile.isAbsolute()) : "Non-absolute path in constructor File(String,Filesystem)";
        assert (null != fs) : "Null Filesystem in constructor File(String,Filesystem)";
        this.fs = fs;
    }

    public LocalFile(String parent, String name, Filesystem fs) throws NullPointerException {
        this.localFile = new File(parent, name);
        assert (this.localFile.isAbsolute()) : "Non-absolute path in constructor File(String,String,Filesystem)";
        assert (null != fs) : "Null Filesystem in constructor File(String,String,Filesystem)";
        this.fs = fs;
    }

    public boolean canAccess(LocalUser u, FilesystemPermission accessMode) throws CannotMapUserException {
        return this.fs.canAccess(u, this.localFile.getAbsolutePath(), accessMode);
    }

    public boolean createNewFile() throws IOException, SecurityException {
        return this.localFile.createNewFile();
    }

    public boolean delete() throws SecurityException {
        return this.localFile.delete();
    }

    public boolean exists() throws SecurityException {
        return this.localFile.exists();
    }

    public String getAbsolutePath() {
        return this.localFile.getAbsolutePath();
    }

    public String getDefaultChecksum() {
        try {
            return ChecksumManager.getInstance().getDefaultChecksum(this.localFile.getAbsolutePath());
        }
        catch (FileNotFoundException e) {
            log.warn("Unable to get local file checksum. FileNotFoundException: " + e.getMessage());
            return null;
        }
    }

    public Map<String, String> getChecksums() {
        try {
            return ChecksumManager.getInstance().getChecksums(this.localFile.getAbsolutePath());
        }
        catch (FileNotFoundException e) {
            log.warn("Unable to get local file checksum. FileNotFoundException: " + e.getMessage());
            return new HashMap<String, String>(0);
        }
    }

    public String getChecksumAlgorithm() {
        return ChecksumManager.getInstance().getDefaultAlgorithm();
    }

    public FilesystemPermission getEffectiveGroupPermission(LocalUser u) {
        return this.fs.getEffectiveGroupPermission(u, this.localFile.getAbsolutePath());
    }

    public FilesystemPermission getEffectiveUserPermission(LocalUser u) {
        return this.fs.getEffectiveUserPermission(u, this.localFile.getAbsolutePath());
    }

    public long getExactLastModifiedTime() {
        return this.fs.getExactLastModifiedTime(this.localFile.getAbsolutePath());
    }

    public long getExactSize() {
        return this.fs.getExactSize(this.localFile.getAbsolutePath());
    }

    public FilesystemPermission getGroupPermission(LocalUser u) {
        return this.fs.getGroupPermission(u, this.localFile.getAbsolutePath());
    }

    public long getLastModifiedTime() {
        return this.fs.getLastModifiedTime(this.localFile.getAbsolutePath());
    }

    public LocalFile getParentFile() {
        return new LocalFile(this.localFile.getParentFile().getAbsolutePath(), this.fs);
    }

    public String getPath() {
        return this.localFile.getPath();
    }

    public long getSize() {
        long result = 0L;
        String filename = this.localFile.getAbsolutePath();
        File file = new File(filename);
        if (file.exists()) {
            result = file.length();
        }
        return result;
    }

    public FilesystemPermission getUserPermission(LocalUser u) {
        return this.fs.getUserPermission(u, this.localFile.getAbsolutePath());
    }

    public FilesystemPermission grantGroupPermission(LocalUser u, FilesystemPermission permission) {
        return this.fs.grantGroupPermission(u, this.localFile.getAbsolutePath(), permission);
    }

    public FilesystemPermission grantUserPermission(LocalUser u, FilesystemPermission permission) {
        return this.fs.grantUserPermission(u, this.localFile.getAbsolutePath(), permission);
    }

    public boolean hasChecksum() {
        try {
            return ChecksumManager.getInstance().hasChecksum(this.localFile.getAbsolutePath());
        }
        catch (FileNotFoundException e) {
            log.warn("Unable to verify if local file has the checksum. FileNotFoundException: " + e.getMessage());
            return false;
        }
    }

    public boolean isDirectory() throws SecurityException {
        return this.localFile.isDirectory();
    }

    public boolean isOnDisk() throws FSException {
        boolean isGPFS;
        try {
            isGPFS = FileSystemCheckerFactory.getInstance().createFileSystemChecker().isGPFS(this.localFile);
        }
        catch (IllegalArgumentException e) {
            log.error("Unable to check if file " + this.localFile.getAbsolutePath() + " is on GPFS. IllegalArgumentException " + e.getMessage());
            throw new FSException("Unable to check if file " + this.localFile.getAbsolutePath() + " is on GPFS. IllegalArgumentException " + e.getMessage());
        }
        catch (IllegalStateException e) {
            log.error("Unable to check if file " + this.localFile.getAbsolutePath() + " is on GPFS. IllegalStateException " + e.getMessage());
            throw new FSException("Unable to check if file " + this.localFile.getAbsolutePath() + " is on GPFS. IllegalStateException " + e.getMessage());
        }
        catch (FileSystemCheckerException e) {
            log.error("Unable to check if file " + this.localFile.getAbsolutePath() + " is on GPFS. FileSystemCheckerException " + e.getMessage());
            throw new FSException("Unable to check if file " + this.localFile.getAbsolutePath() + " is on GPFS. FileSystemCheckerException " + e.getMessage());
        }
        if (isGPFS) {
            try {
                long blocksSize = CUtilManager.getFileBlocksSize(this.localFile.getAbsolutePath());
                if (blocksSize >= this.localFile.length()) {
                    log.debug("File is on disk: blockSize=" + blocksSize + " fileSize=" + this.localFile.length() + " file=" + this.localFile.getAbsolutePath());
                    return true;
                }
                log.debug("File is NOT on disk: blockSize=" + blocksSize + " fileSize=" + this.localFile.length() + " file=" + this.localFile.getAbsolutePath());
                return false;
            }
            catch (NoGPFSFileSystemException e) {
                log.error("Unable to retrieve file block size for file " + this.localFile.getAbsolutePath() + " NoGPFSFileSystemException : " + e.getMessage());
                throw new FSException("Unable to retrieve file block size for file " + this.localFile.getAbsolutePath() + " NoGPFSFileSystemException : " + e.getMessage());
            }
        }
        return this.localFile.exists();
    }

    public boolean isOnTape() {
        return StormEA.getMigrated(this.localFile.getAbsolutePath());
    }

    public long length() throws SecurityException {
        return this.localFile.length();
    }

    public LocalFile[] listFiles() {
        File[] _children = this.localFile.listFiles();
        LocalFile[] children = new LocalFile[_children.length];
        for (int i = 0; i < _children.length; ++i) {
            children[i] = new LocalFile(_children[i].getAbsolutePath(), this.fs);
        }
        return children;
    }

    public boolean mkdir() throws SecurityException {
        return this.localFile.mkdir();
    }

    public boolean mkdirs() throws SecurityException {
        return this.localFile.mkdirs();
    }

    public boolean parentExists() {
        File parent = this.localFile.getParentFile();
        assert (null != parent) : "Null parent in " + this.toString();
        return parent.exists();
    }

    public FilesystemPermission removeGroupPermission(LocalUser u) {
        return this.fs.removeGroupPermission(u, this.localFile.getAbsolutePath());
    }

    public FilesystemPermission removeUserPermission(LocalUser u) {
        return this.fs.removeUserPermission(u, this.localFile.getAbsolutePath());
    }

    public boolean renameTo(String newName) throws SecurityException, NullPointerException {
        return this.localFile.renameTo(new File(newName));
    }

    public FilesystemPermission revokeGroupPermission(LocalUser u, FilesystemPermission permission) {
        return this.fs.revokeGroupPermission(u, this.localFile.getAbsolutePath(), permission);
    }

    public FilesystemPermission revokeUserPermission(LocalUser u, FilesystemPermission permission) {
        return this.fs.revokeUserPermission(u, this.localFile.getAbsolutePath(), permission);
    }

    public void setGroupOwnership(String groupName) throws FSException {
        block8: {
            boolean isGPFS;
            try {
                isGPFS = FileSystemCheckerFactory.getInstance().createFileSystemChecker().isGPFS(this.localFile);
            }
            catch (IllegalArgumentException e) {
                log.error("Unable to check is file " + this.localFile.getAbsolutePath() + " is on GPFS. IllegalArgumentException " + e.getMessage());
                throw new FSException("Unable to check is file " + this.localFile.getAbsolutePath() + " is on GPFS. IllegalArgumentException " + e.getMessage());
            }
            catch (IllegalStateException e) {
                log.error("Unable to check is file " + this.localFile.getAbsolutePath() + " is on GPFS. IllegalStateException " + e.getMessage());
                throw new FSException("Unable to check is file " + this.localFile.getAbsolutePath() + " is on GPFS. IllegalStateException " + e.getMessage());
            }
            catch (FileSystemCheckerException e) {
                log.error("Unable to check is file " + this.localFile.getAbsolutePath() + " is on GPFS. FileSystemCheckerException " + e.getMessage());
                throw new FSException("Unable to check is file " + this.localFile.getAbsolutePath() + " is on GPFS. FileSystemCheckerException " + e.getMessage());
            }
            if (isGPFS) {
                try {
                    int returnValue = CUtilManager.setFileGroup(this.localFile.getAbsolutePath(), groupName);
                    if (returnValue != 0) {
                        throw new FSException("Error in CUtilManager.setFileGroup execution . CUtil ErrNo : " + returnValue);
                    }
                    break block8;
                }
                catch (NoGPFSFileSystemException e) {
                    log.error("Unable to set group owner to file " + this.localFile.getAbsolutePath() + " NoGPFSFileSystemException : " + e.getMessage());
                    throw new FSException("Unable to set group owner to file " + this.localFile.getAbsolutePath() + " NoGPFSFileSystemException : " + e.getMessage());
                }
            }
            log.error("Unable to set group owner to file " + this.localFile.getAbsolutePath() + " filesystem is not GPFS! This error should never appair. Please contact StoRM developers");
            throw new FSException("Unable to set group owner to file " + this.localFile.getAbsolutePath() + " filesystem is not GPFS! This error should never appair. Please contact StoRM developers");
        }
    }

    public FilesystemPermission setGroupPermission(LocalUser u, FilesystemPermission permission) {
        return this.fs.setGroupPermission(u, this.localFile.getAbsolutePath(), permission);
    }

    public FilesystemPermission setUserPermission(LocalUser u, FilesystemPermission permission) {
        return this.fs.setUserPermission(u, this.localFile.getAbsolutePath(), permission);
    }

    public String toString() {
        return File.class.toString() + ":" + this.localFile.toString();
    }

    public int truncateFile(long desired_size) {
        return this.fs.truncateFile(this.localFile.getAbsolutePath(), desired_size);
    }
}

