/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.filesystem;

import it.grid.storm.common.types.SizeUnit;
import it.grid.storm.filesystem.LocalFile;
import it.grid.storm.filesystem.SpaceSystem;
import it.grid.storm.srm.types.TSizeInBytes;

public class InvalidSpaceAttributesException
extends Exception {
    private boolean nullGuarSize = false;
    private boolean nullTotSize = false;
    private boolean nullSpaFil = false;
    private boolean nullSS = false;
    private boolean emptyTotSize = false;
    private boolean greater = false;
    private double guaranteed = -1.0;
    private double total = -1.0;

    public InvalidSpaceAttributesException(TSizeInBytes guaranteedSize, TSizeInBytes totalSize, LocalFile spaceFile, SpaceSystem ss) {
        this.nullGuarSize = guaranteedSize == null;
        this.nullTotSize = totalSize == null;
        this.nullSpaFil = spaceFile == null;
        this.nullSS = ss == null;
        this.emptyTotSize = !this.nullTotSize && totalSize.isEmpty();
        boolean bl = this.greater = !this.nullGuarSize && !this.nullTotSize && !guaranteedSize.isEmpty() && !totalSize.isEmpty() && guaranteedSize.getSizeIn(SizeUnit.BYTES) > totalSize.getSizeIn(SizeUnit.BYTES);
        if (this.greater) {
            this.guaranteed = guaranteedSize.getSizeIn(SizeUnit.BYTES);
            this.total = totalSize.getSizeIn(SizeUnit.BYTES);
        }
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("InvalidSpaceAttributesException: nullGuaranteedSize=");
        sb.append(this.nullGuarSize);
        sb.append("; nullTotalSize=");
        sb.append(this.nullTotSize);
        sb.append("; nullSpaceFile=");
        sb.append(this.nullSpaFil);
        sb.append("; nullSpaceSystem=");
        sb.append(this.nullSS);
        sb.append("; emptyTotalSize=");
        sb.append(this.emptyTotSize);
        sb.append("; guaranteedSize greater than totalSize is ");
        sb.append(this.greater);
        if (this.greater) {
            sb.append(" with guaranteed=");
        }
        sb.append(this.guaranteed);
        sb.append(" and total=");
        sb.append(this.total);
        return sb.toString();
    }
}

