/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.filesystem;

import it.grid.storm.filesystem.ReservationException;
import it.grid.storm.filesystem.SpaceSystem;
import it.grid.storm.filesystem.SpaceSystemException;
import it.grid.storm.filesystem.swig.gpfs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GPFSSpaceSystem
implements SpaceSystem {
    private gpfs fs = null;
    private static Logger log = LoggerFactory.getLogger(GPFSSpaceSystem.class);

    public GPFSSpaceSystem(String mountpoint) throws SpaceSystemException {
        if (mountpoint == null) {
            throw new SpaceSystemException("Supplied mountpoint is null!");
        }
        try {
            this.fs = new gpfs(mountpoint);
        }
        catch (Exception e) {
            throw new SpaceSystemException("Unable to instantiate GPFS filesystem on " + mountpoint + "; exception: " + e);
        }
    }

    @Override
    public long reserveSpace(String pathToFile, long size) throws ReservationException {
        try {
            log.debug("GPFSSpaceSystem : pathToFile:" + pathToFile);
            this.fs.prealloc(pathToFile, size);
            return size;
        }
        catch (Exception e) {
            String explanation = "An exception was thrown by the native underlying filesystem: " + e.toString();
            log.debug(explanation);
            throw new ReservationException(explanation);
        }
    }

    @Override
    public long compactSpace(String pathToFile) throws ReservationException {
        String explanation = "Compact Space operation currently not supported!";
        log.debug(explanation);
        throw new ReservationException(explanation);
    }

    @Override
    public void removeSpace(String pathToFile) throws ReservationException {
        String explanation = "Remove Space operation currently not supported!";
        log.debug(explanation);
        throw new ReservationException(explanation);
    }

    @Override
    public long changeSize(String pathToFile, long newSize) throws ReservationException {
        String explanation = "Change Size operation currently not supported!";
        log.debug(explanation);
        throw new ReservationException(explanation);
    }

    public String toString() {
        return "GPFSSpaceSystem";
    }
}

