/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.filesystem;

import java.io.Serializable;

public class FilesystemPermission
implements Serializable {
    static final int EXECUTE = 1;
    static final int WRITE_DATA = 2;
    static final int READ_DATA = 4;
    static final int WRITE_ACL = 8;
    static final int READ_ACL = 16;
    static final int DELETE = 32;
    static final int TRAVERSE_DIRECTORY = 1;
    static final int LIST_DIRECTORY = 4;
    static final int CREATE_SUBDIRECTORY = 64;
    static final int CREATE_FILE = 128;
    static final int DELETE_CHILD = 256;
    static final int NONE = 0;
    static final int ALL = 511;
    public static final FilesystemPermission Read = new FilesystemPermission(4);
    public static final FilesystemPermission ReadWrite = new FilesystemPermission(6);
    public static final FilesystemPermission List = new FilesystemPermission(4);
    public static final FilesystemPermission Traverse = new FilesystemPermission(1);
    public static final FilesystemPermission ListTraverse = new FilesystemPermission(5);
    public static final FilesystemPermission ListTraverseWrite = new FilesystemPermission(7);
    public static final FilesystemPermission None = new FilesystemPermission(0);
    public static final FilesystemPermission Write = new FilesystemPermission(2);
    public static final FilesystemPermission Create = new FilesystemPermission(128);
    public static final FilesystemPermission CreateSubdirectory = new FilesystemPermission(64);
    public static final FilesystemPermission Delete = new FilesystemPermission(32);
    public static final FilesystemPermission ListDirectory = new FilesystemPermission(4);
    protected int permission;

    public FilesystemPermission(FilesystemPermission p) {
        this.permission = p.permission & 0x1FF;
    }

    public FilesystemPermission(int bitfield) {
        this.permission = bitfield & 0x1FF;
    }

    protected FilesystemPermission() {
        this.denyAll();
    }

    public int toFsAclPermission() {
        return this.permission;
    }

    public boolean canReadFile() {
        return 0 != (this.permission & 4);
    }

    public boolean canWriteFile() {
        return 0 != (this.permission & 2);
    }

    public boolean canListDirectory() {
        return 0 != (this.permission & 4);
    }

    public boolean canTraverseDirectory() {
        return 0 != (this.permission & 1);
    }

    public boolean canMakeDirectory() {
        return 0 != (this.permission & 0x40);
    }

    public boolean canCreateNewFile() {
        return 0 != (this.permission & 0x80);
    }

    public boolean canChangeAcl() {
        return 0 != (this.permission & 8);
    }

    public boolean canDelete() {
        return 0 != (this.permission & 0x20);
    }

    public boolean allows(FilesystemPermission other) {
        return other.permission == (this.permission & other.permission);
    }

    public boolean allows(int bitfield) {
        return bitfield == (this.permission & bitfield);
    }

    protected FilesystemPermission denyAll() {
        this.permission = 0;
        return this;
    }

    protected FilesystemPermission denyReadFile() {
        this.permission &= 0xFFFFFFFB;
        return this;
    }

    protected FilesystemPermission denyWriteFile() {
        this.permission &= 0xFFFFFFFD;
        return this;
    }

    protected FilesystemPermission denyChangeAcl() {
        this.permission &= 0xFFFFFFF7;
        return this;
    }

    protected FilesystemPermission denyCreateNewFile() {
        this.permission &= 0xFFFFFF7F;
        return this;
    }

    protected FilesystemPermission denyListDirectory() {
        this.permission &= 0xFFFFFFFB;
        return this;
    }

    protected FilesystemPermission denyTraverseDirectory() {
        this.permission &= 0xFFFFFFFE;
        return this;
    }

    protected FilesystemPermission denyMakeDirectory() {
        this.permission &= 0xFFFFFFBF;
        return this;
    }

    protected FilesystemPermission denyDelete() {
        this.permission &= 0xFFFFFFDF;
        return this;
    }

    public FilesystemPermission deny(FilesystemPermission other) {
        return new FilesystemPermission(this.permission & ~other.permission);
    }

    protected FilesystemPermission permitAll() {
        this.permission = 511;
        return this;
    }

    protected FilesystemPermission permitReadFile() {
        this.permission |= 4;
        return this;
    }

    protected FilesystemPermission permitWriteFile() {
        this.permission |= 2;
        return this;
    }

    protected FilesystemPermission permitChangeAcl() {
        this.permission |= 8;
        return this;
    }

    protected FilesystemPermission permitCreateNewFile() {
        this.permission |= 0x80;
        return this;
    }

    protected FilesystemPermission permitListDirectory() {
        this.permission |= 4;
        return this;
    }

    protected FilesystemPermission permitTraverseDirectory() {
        this.permission |= 1;
        return this;
    }

    protected FilesystemPermission permitMakeDirectory() {
        this.permission |= 0x40;
        return this;
    }

    protected FilesystemPermission permitDelete() {
        this.permission |= 0x20;
        return this;
    }

    public int getInt() {
        return this.permission;
    }

    public String toString() {
        return new Integer(this.permission).toString();
    }
}

