/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.filesystem;

import it.grid.storm.filesystem.AclLockPool;
import it.grid.storm.filesystem.AclLockPoolElement;
import it.grid.storm.filesystem.FilesystemPermission;
import it.grid.storm.filesystem.swig.fs_acl;
import it.grid.storm.filesystem.swig.fs_aclWrap;
import it.grid.storm.filesystem.swig.genericfs;
import it.grid.storm.filesystem.swig.gpfs23_acl;
import it.grid.storm.filesystem.swig.gpfs23_aclWrap;
import it.grid.storm.filesystem.swig.gpfs31_acl;
import it.grid.storm.filesystem.swig.gpfs31_aclWrap;
import it.grid.storm.filesystem.swig.posixfs_acl;
import it.grid.storm.filesystem.swig.posixfs_aclWrap;
import it.grid.storm.griduser.LocalUser;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Filesystem {
    private final genericfs fs;
    private static AclLockPool locks = new AclLockPool();
    private final Logger log;
    private GetGroupPermissionMethod getGroupPermissionMethod = new GetGroupPermissionMethod();
    private GetUserPermissionMethod getUserPermissionMethod = new GetUserPermissionMethod();
    private GetEffectiveGroupPermissionMethod getEffectiveGroupPermissionMethod = new GetEffectiveGroupPermissionMethod();
    private GetEffectiveUserPermissionMethod getEffectiveUserPermissionMethod = new GetEffectiveUserPermissionMethod();
    private GrantGroupPermissionMethod grantGroupPermissionMethod = new GrantGroupPermissionMethod();
    private GrantUserPermissionMethod grantUserPermissionMethod = new GrantUserPermissionMethod();
    private RemoveGroupPermissionMethod removeGroupPermissionMethod = new RemoveGroupPermissionMethod();
    private RemoveUserPermissionMethod removeUserPermissionMethod = new RemoveUserPermissionMethod();
    private RevokeGroupPermissionMethod revokeGroupPermissionMethod = new RevokeGroupPermissionMethod();
    private RevokeUserPermissionMethod revokeUserPermissionMethod = new RevokeUserPermissionMethod();
    private SetGroupPermissionMethod setGroupPermissionMethod = new SetGroupPermissionMethod();
    private SetUserPermissionMethod setUserPermissionMethod = new SetUserPermissionMethod();

    public Filesystem(genericfs nativeFs) {
        assert (null != nativeFs) : "Null nativeFs in Filesystem(NativeFilesystemInterface) constructor";
        this.fs = nativeFs;
        this.log = LoggerFactory.getLogger(Filesystem.class);
        this.getGroupPermissionMethod = new GetGroupPermissionMethod();
        this.getUserPermissionMethod = new GetUserPermissionMethod();
        this.grantGroupPermissionMethod = new GrantGroupPermissionMethod();
        this.grantUserPermissionMethod = new GrantUserPermissionMethod();
        this.revokeGroupPermissionMethod = new RevokeGroupPermissionMethod();
        this.revokeUserPermissionMethod = new RevokeUserPermissionMethod();
        this.setGroupPermissionMethod = new SetGroupPermissionMethod();
    }

    public long getSize(String file) {
        return this.fs.get_size(file);
    }

    public long getLastModifiedTime(String fileOrDirectory) {
        File fileOrDir = new File(fileOrDirectory);
        return fileOrDir.lastModified();
    }

    public long getExactSize(String file) {
        File fileOrDir = new File(file);
        return fileOrDir.length();
    }

    public long getExactLastModifiedTime(String fileOrDirectory) {
        return this.fs.get_exact_last_modification_time(fileOrDirectory);
    }

    public int truncateFile(String filename, long desired_size) {
        return this.fs.truncate_file(filename, desired_size);
    }

    public long getFreeSpace() {
        return this.fs.get_free_space();
    }

    public boolean canAccess(LocalUser u, String fileOrDirectory, FilesystemPermission accessMode) {
        assert (null != u) : "Null LocalUser parameter passed to Filesystem.canAccess()";
        assert (null != fileOrDirectory) : "Null fileOrDirectory parameter passed to Filesystem.canAccess()";
        assert (null != accessMode) : "Null accessMode parameter passed to Filesystem.canAccess()";
        fs_acl acl = this.fs.new_acl();
        acl.load(fileOrDirectory, false);
        return acl.access(accessMode.toFsAclPermission(), u.getUid(), u.getGids());
    }

    public FilesystemPermission getEffectiveGroupPermission(LocalUser u, String fileOrDirectory) {
        return this.getPermissionTemplate(u, fileOrDirectory, this.getEffectiveGroupPermissionMethod);
    }

    public FilesystemPermission getEffectiveUserPermission(LocalUser u, String fileOrDirectory) {
        return this.getPermissionTemplate(u, fileOrDirectory, this.getEffectiveUserPermissionMethod);
    }

    public FilesystemPermission getGroupPermission(LocalUser u, String fileOrDirectory) {
        return this.getPermissionTemplate(u, fileOrDirectory, this.getGroupPermissionMethod);
    }

    public FilesystemPermission getUserPermission(LocalUser u, String fileOrDirectory) {
        return this.getPermissionTemplate(u, fileOrDirectory, this.getUserPermissionMethod);
    }

    public FilesystemPermission grantGroupPermission(LocalUser u, String fileOrDirectory, FilesystemPermission permission) {
        return this.setPermissionTemplate(u, fileOrDirectory, permission, this.grantGroupPermissionMethod);
    }

    public FilesystemPermission grantUserPermission(LocalUser u, String fileOrDirectory, FilesystemPermission permission) {
        return this.setPermissionTemplate(u, fileOrDirectory, permission, this.grantUserPermissionMethod);
    }

    public FilesystemPermission removeGroupPermission(LocalUser u, String fileOrDirectory) {
        return this.removePermissionTemplate(u, fileOrDirectory, this.removeGroupPermissionMethod);
    }

    public FilesystemPermission removeUserPermission(LocalUser u, String fileOrDirectory) {
        return this.removePermissionTemplate(u, fileOrDirectory, this.removeUserPermissionMethod);
    }

    public FilesystemPermission revokeGroupPermission(LocalUser u, String fileOrDirectory, FilesystemPermission permission) {
        return this.setPermissionTemplate(u, fileOrDirectory, permission, this.revokeGroupPermissionMethod);
    }

    public FilesystemPermission revokeUserPermission(LocalUser u, String fileOrDirectory, FilesystemPermission permission) {
        return this.setPermissionTemplate(u, fileOrDirectory, permission, this.revokeUserPermissionMethod);
    }

    public FilesystemPermission setGroupPermission(LocalUser u, String fileOrDirectory, FilesystemPermission permission) {
        return this.setPermissionTemplate(u, fileOrDirectory, permission, this.setGroupPermissionMethod);
    }

    public FilesystemPermission setUserPermission(LocalUser u, String fileOrDirectory, FilesystemPermission permission) {
        return this.setPermissionTemplate(u, fileOrDirectory, permission, this.setUserPermissionMethod);
    }

    private FilesystemPermission getPermissionTemplate(LocalUser u, String fileOrDirectory, GetPermissionMethod permissionMethod) {
        assert (null != u) : "Null LocalUser passed to Filesystem.getPermissionTemplate()";
        assert (null != fileOrDirectory) : "Null fileOrDirectory passed to Filesystem.getPermissionTemplate()";
        assert (null != permissionMethod) : "Null permissionMethod passed to Filesystem.getPermissionTemplate()";
        fs_acl acl = this.fs.new_acl();
        acl.load(fileOrDirectory, false);
        FilesystemPermission permission = permissionMethod.get(acl, u);
        this.deleteAcl(acl);
        return permission;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FilesystemPermission removePermissionTemplate(LocalUser u, String fileOrDirectory, RemovePermissionMethod permissionMethod) {
        FilesystemPermission oldPermission;
        assert (null != u) : "Null LocalUser passed to Filesystem.removePermissionTemplate()";
        assert (null != fileOrDirectory) : "Null fileOrDirectory passed to Filesystem.removePermissionTemplate()";
        assert (null != permissionMethod) : "Null permissionMethod passed to Filesystem.removePermissionTemplate()";
        fs_acl acl = this.fs.new_acl();
        AclLockPoolElement lock = locks.get(fileOrDirectory);
        try {
            lock.acquireUninterruptibly();
            acl.load(fileOrDirectory, false);
            oldPermission = permissionMethod.remove(acl, u);
            acl.enforce(fileOrDirectory);
        }
        finally {
            lock.release();
            locks.remove(fileOrDirectory);
            this.deleteAcl(acl);
        }
        return oldPermission;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FilesystemPermission setPermissionTemplate(LocalUser u, String fileOrDirectory, FilesystemPermission p, SetPermissionMethod setPermissionMethod) {
        FilesystemPermission oldPermission;
        assert (null != u) : "Null LocalUser passed to Filesystem.setPermissionTemplate()";
        assert (null != fileOrDirectory) : "Null fileOrDirectory passed to Filesystem.setPermissionTemplate()";
        assert (null != p) : "Null FilesystemPermission passed to Filesystem.setPermissionTemplate()";
        assert (null != setPermissionMethod) : "Null permissionMethod passed to Filesystem.setPermissionTemplate()";
        fs_acl acl = this.fs.new_acl();
        AclLockPoolElement lock = locks.get(fileOrDirectory);
        try {
            lock.acquireUninterruptibly();
            acl.load(fileOrDirectory, false);
            oldPermission = setPermissionMethod.apply(acl, u, p);
            acl.enforce(fileOrDirectory);
        }
        finally {
            lock.release();
            locks.remove(fileOrDirectory);
            this.deleteAcl(acl);
        }
        return oldPermission;
    }

    private void deleteAcl(fs_acl acl) throws IllegalArgumentException {
        if (acl == null) {
            this.log.error("Received null fs_acl");
            throw new IllegalArgumentException("Received null fs_acl");
        }
        if (acl.getClass().equals(fs_acl.class)) {
            long swigCPtr = fs_aclWrap.getPointer(acl);
            fs_aclWrap.deleteAcl(swigCPtr);
            return;
        }
        if (acl.getClass().equals(posixfs_acl.class)) {
            long swigCPtr = posixfs_aclWrap.getPointer(acl);
            posixfs_aclWrap.deleteAcl(swigCPtr);
            return;
        }
        if (acl.getClass().equals(gpfs23_acl.class)) {
            long swigCPtr = gpfs23_aclWrap.getPointer(acl);
            gpfs23_aclWrap.deleteAcl(swigCPtr);
            return;
        }
        if (acl.getClass().equals(gpfs31_acl.class)) {
            long swigCPtr = gpfs31_aclWrap.getPointer(acl);
            gpfs31_aclWrap.deleteAcl(swigCPtr);
            return;
        }
        this.log.error("Unable to find a wrapper for acl class: " + acl.getClass());
    }

    private class RevokeGroupPermissionMethod
    implements SetPermissionMethod {
        private RevokeGroupPermissionMethod() {
        }

        @Override
        public FilesystemPermission apply(fs_acl a, LocalUser u, FilesystemPermission p) {
            if (a.has_group_perm(u.getPrimaryGid())) {
                return new FilesystemPermission(a.revoke_group_perm(u.getPrimaryGid(), p.toFsAclPermission()));
            }
            return null;
        }
    }

    private class GrantGroupPermissionMethod
    implements SetPermissionMethod {
        private GrantGroupPermissionMethod() {
        }

        @Override
        public FilesystemPermission apply(fs_acl a, LocalUser u, FilesystemPermission p) {
            if (a.has_group_perm(u.getPrimaryGid())) {
                return new FilesystemPermission(a.grant_group_perm(u.getPrimaryGid(), p.toFsAclPermission()));
            }
            a.grant_group_perm(u.getPrimaryGid(), p.toFsAclPermission());
            return null;
        }
    }

    private class SetGroupPermissionMethod
    implements SetPermissionMethod {
        private SetGroupPermissionMethod() {
        }

        @Override
        public FilesystemPermission apply(fs_acl a, LocalUser u, FilesystemPermission p) {
            if (a.has_group_perm(u.getPrimaryGid())) {
                return new FilesystemPermission(a.set_group_perm(u.getPrimaryGid(), p.toFsAclPermission()));
            }
            a.set_group_perm(u.getPrimaryGid(), p.toFsAclPermission());
            return null;
        }
    }

    private class RevokeUserPermissionMethod
    implements SetPermissionMethod {
        private RevokeUserPermissionMethod() {
        }

        @Override
        public FilesystemPermission apply(fs_acl a, LocalUser u, FilesystemPermission p) {
            if (a.has_user_perm(u.getUid())) {
                return new FilesystemPermission(a.revoke_user_perm(u.getUid(), p.toFsAclPermission()));
            }
            return null;
        }
    }

    private class GrantUserPermissionMethod
    implements SetPermissionMethod {
        private GrantUserPermissionMethod() {
        }

        @Override
        public FilesystemPermission apply(fs_acl a, LocalUser u, FilesystemPermission p) {
            if (a.has_user_perm(u.getUid())) {
                return new FilesystemPermission(a.grant_user_perm(u.getUid(), p.toFsAclPermission()));
            }
            a.grant_user_perm(u.getUid(), p.toFsAclPermission());
            return null;
        }
    }

    private class SetUserPermissionMethod
    implements SetPermissionMethod {
        private SetUserPermissionMethod() {
        }

        @Override
        public FilesystemPermission apply(fs_acl a, LocalUser u, FilesystemPermission p) {
            if (a.has_user_perm(u.getUid())) {
                return new FilesystemPermission(a.set_user_perm(u.getUid(), p.toFsAclPermission()));
            }
            a.set_user_perm(u.getUid(), p.toFsAclPermission());
            return null;
        }
    }

    private static interface SetPermissionMethod {
        public FilesystemPermission apply(fs_acl var1, LocalUser var2, FilesystemPermission var3);
    }

    private class RemoveGroupPermissionMethod
    implements RemovePermissionMethod {
        private RemoveGroupPermissionMethod() {
        }

        @Override
        public FilesystemPermission remove(fs_acl a, LocalUser u) {
            assert (a.has_user_perm(u.getUid())) : "Filesystem: removing permission for group " + u.getUid() + "that has no permission associated!";
            return new FilesystemPermission(a.remove_group_perm_not_owner(u.getPrimaryGid()));
        }
    }

    private class RemoveUserPermissionMethod
    implements RemovePermissionMethod {
        private RemoveUserPermissionMethod() {
        }

        @Override
        public FilesystemPermission remove(fs_acl a, LocalUser u) {
            assert (a.has_user_perm(u.getUid())) : "Filesystem: removing permission for user " + u.getUid() + "that has no permission associated!";
            return new FilesystemPermission(a.remove_user_perm_not_owner(u.getUid()));
        }
    }

    private static interface RemovePermissionMethod {
        public FilesystemPermission remove(fs_acl var1, LocalUser var2);
    }

    private class GetEffectiveUserPermissionMethod
    implements GetPermissionMethod {
        private GetEffectiveUserPermissionMethod() {
        }

        @Override
        public FilesystemPermission get(fs_acl a, LocalUser u) {
            if (a.has_user_perm(u.getUid())) {
                return new FilesystemPermission(a.get_user_effective_perm(u.getUid()));
            }
            return null;
        }
    }

    private class GetEffectiveGroupPermissionMethod
    implements GetPermissionMethod {
        private GetEffectiveGroupPermissionMethod() {
        }

        @Override
        public FilesystemPermission get(fs_acl a, LocalUser u) {
            if (a.has_group_perm(u.getPrimaryGid())) {
                return new FilesystemPermission(a.get_group_effective_perm(u.getPrimaryGid()));
            }
            return null;
        }
    }

    private class GetUserPermissionMethod
    implements GetPermissionMethod {
        private GetUserPermissionMethod() {
        }

        @Override
        public FilesystemPermission get(fs_acl a, LocalUser u) {
            if (a.has_user_perm(u.getUid())) {
                return new FilesystemPermission(a.get_user_perm(u.getUid()));
            }
            return null;
        }
    }

    private class GetGroupPermissionMethod
    implements GetPermissionMethod {
        private GetGroupPermissionMethod() {
        }

        @Override
        public FilesystemPermission get(fs_acl a, LocalUser u) {
            if (a.has_group_perm(u.getPrimaryGid())) {
                return new FilesystemPermission(a.get_group_perm(u.getPrimaryGid()));
            }
            return null;
        }
    }

    private static interface GetPermissionMethod {
        public FilesystemPermission get(fs_acl var1, LocalUser var2);
    }
}

