/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.filesystem;

import it.grid.storm.filesystem.FileSystemCheckerException;
import it.grid.storm.filesystem.FileSystemCheckerFromFile;
import it.grid.storm.filesystem.MtabUtil;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemCheckerMtab
extends FileSystemCheckerFromFile {
    private static final Logger log = LoggerFactory.getLogger(FileSystemCheckerMtab.class);
    private static FileSystemCheckerMtab instance = new FileSystemCheckerMtab();

    private FileSystemCheckerMtab() {
        super(log);
    }

    public static FileSystemCheckerMtab getInstance() throws FileSystemCheckerException {
        instance.tryInit();
        return instance;
    }

    @Override
    protected String getFilePath() {
        return MtabUtil.getFilePath();
    }

    @Override
    protected int getFsNameIndex() {
        return MtabUtil.getFsNameIndex();
    }

    @Override
    protected int getMountPointIndex() {
        return MtabUtil.getMountPointIndex();
    }

    @Override
    protected boolean skipLine(String line) {
        return MtabUtil.skipLineForMountPoints(line);
    }

    @Override
    protected LinkedList<String> tokenizeLine(String line) {
        return MtabUtil.tokenizeLine(line);
    }
}

