/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.filesystem;

import it.grid.storm.filesystem.FileSystemCheckerException;
import it.grid.storm.filesystem.FileSystemCheckerFromFile;
import java.util.Arrays;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemCheckerMounts
extends FileSystemCheckerFromFile {
    private static final Logger log = LoggerFactory.getLogger(FileSystemCheckerMounts.class);
    private static final String MOUNTS_FILE_PATH = "/proc/mounts";
    private static final FileSystemCheckerMounts instance = new FileSystemCheckerMounts();

    private FileSystemCheckerMounts() {
        super(log);
    }

    public static FileSystemCheckerMounts getInstance() throws FileSystemCheckerException {
        instance.tryInit();
        return instance;
    }

    @Override
    protected String getFilePath() {
        return MOUNTS_FILE_PATH;
    }

    @Override
    protected int getFsNameIndex() {
        return 2;
    }

    @Override
    protected int getMountPointIndex() {
        return 1;
    }

    @Override
    protected boolean skipLine(String line) {
        return line.startsWith("#") || !line.startsWith("/dev/");
    }

    @Override
    protected LinkedList<String> tokenizeLine(String line) {
        String[] elementsArray = line.split(" ");
        LinkedList<String> elementsList = new LinkedList<String>(Arrays.asList(elementsArray));
        while (elementsList.remove("")) {
        }
        return elementsList;
    }
}

