/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.filesystem;

import it.grid.storm.filesystem.FileSystemChecker;
import it.grid.storm.filesystem.FileSystemCheckerException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;

abstract class FileSystemCheckerFromFile
implements FileSystemChecker {
    private final Logger log;
    private List<String> GPFSMountPoints = null;
    private long initInstant = 0L;
    private static final String GPFS_FILESYSTEM_NAME = "gpfs";

    protected FileSystemCheckerFromFile(Logger log) {
        this.log = log;
    }

    @Override
    public boolean isGPFS(File file) throws IllegalArgumentException, FileSystemCheckerException {
        if (file == null) {
            this.log.error("IsGPFS method invoked with null File parameter!");
            throw new IllegalArgumentException("Provided null File argument");
        }
        this.tryInit();
        return this.evaluate(file.getAbsolutePath());
    }

    protected synchronized void tryInit() throws FileSystemCheckerException {
        if (this.refreshNeeded()) {
            this.init();
        }
    }

    private boolean refreshNeeded() {
        boolean response = false;
        if (this.initInstant == 0L || this.initInstant < new File(this.getFilePath()).lastModified()) {
            response = true;
        }
        return response;
    }

    private void init() throws FileSystemCheckerException {
        this.initInstant = Calendar.getInstance().getTimeInMillis();
        this.GPFSMountPoints = this.listGPFSMountPoints();
    }

    private synchronized boolean evaluate(String filePath) {
        boolean response = false;
        for (String GPFSMountPoint : this.GPFSMountPoints) {
            if (!filePath.startsWith(GPFSMountPoint)) continue;
            response = true;
            break;
        }
        return response;
    }

    private List<String> listGPFSMountPoints() throws FileSystemCheckerException {
        BufferedReader mtab;
        LinkedList<String> mountPointList = new LinkedList<String>();
        try {
            mtab = new BufferedReader(new FileReader(this.getFilePath()));
        }
        catch (FileNotFoundException e) {
            this.log.error("Error while trying to create a reader for mtab file at " + this.getFilePath() + ". FileNotFoundException : " + e.getMessage());
            throw new FileSystemCheckerException("Error while trying to create a reader for mtab file at " + this.getFilePath() + ". FileNotFoundException : " + e.getMessage());
        }
        try {
            String line;
            while ((line = mtab.readLine()) != null) {
                LinkedList<String> elementsList;
                if (this.skipLine(line) || !(elementsList = this.tokenizeLine(line)).get(this.getFsNameIndex()).equals(GPFS_FILESYSTEM_NAME)) continue;
                mountPointList.add(elementsList.get(this.getMountPointIndex()));
            }
        }
        catch (IOException e) {
            this.log.error("Error while trying to read mtab file at " + this.getFilePath() + ". IOException : " + e.getMessage());
            throw new FileSystemCheckerException("Error while trying to read mtab file at " + this.getFilePath() + ". IOException : " + e.getMessage());
        }
        return mountPointList;
    }

    protected abstract String getFilePath();

    protected abstract int getFsNameIndex();

    protected abstract int getMountPointIndex();

    protected abstract LinkedList<String> tokenizeLine(String var1);

    protected abstract boolean skipLine(String var1);
}

