/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.filesystem;

import it.grid.storm.filesystem.FileSystemChecker;
import it.grid.storm.filesystem.FileSystemCheckerException;
import it.grid.storm.filesystem.FileSystemCheckerMountsMonolithic;
import it.grid.storm.filesystem.FileSystemCheckerMtabMonolithic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemCheckerFactory {
    private static Logger log = LoggerFactory.getLogger(FileSystemCheckerFactory.class);
    private final FileSystemCheckerType chosenType;
    private static final FileSystemCheckerType defaultType = FileSystemCheckerType.Mtab;
    private static FileSystemCheckerFactory instance = null;

    private FileSystemCheckerFactory(FileSystemCheckerType type) {
        this.chosenType = type;
    }

    public static FileSystemCheckerFactory getInstance() {
        if (instance == null) {
            log.info("FileSystemCheckerFactory not explicitaly initialized, using default checker type : " + (Object)((Object)defaultType));
            FileSystemCheckerFactory.init(defaultType);
        }
        return instance;
    }

    public static void init(FileSystemCheckerType type) throws IllegalArgumentException, IllegalStateException {
        if (type == null) {
            log.error("Unable to init FileSystemCheckerFactory. Received null FileSystemCheckerType parameter!");
            throw new IllegalArgumentException("Received null FileSystemCheckerType parameter!");
        }
        if (instance == null) {
            instance = new FileSystemCheckerFactory(type);
        } else {
            if (!FileSystemCheckerFactory.instance.chosenType.equals((Object)type)) {
                log.warn("Asked to initialize the already initialized FileSystemCheckerFactory with FileSystemCheckerType " + (Object)((Object)type) + ". Current FileSystemCheckerType is " + (Object)((Object)FileSystemCheckerFactory.instance.chosenType));
                throw new IllegalStateException("Asked to initialize the already initialized FileSystemCheckerFactory with FileSystemCheckerType " + (Object)((Object)type) + ". Current FileSystemCheckerType is " + (Object)((Object)FileSystemCheckerFactory.instance.chosenType));
            }
            log.info("Asked to re-initialize the already initialized FileSystemCheckerFactory, nothing to do");
        }
    }

    public FileSystemChecker createFileSystemChecker() throws IllegalStateException, FileSystemCheckerException {
        switch (this.chosenType) {
            case Mtab: {
                return FileSystemCheckerMtabMonolithic.getInstance();
            }
            case Mounts: {
                return FileSystemCheckerMountsMonolithic.getInstance();
            }
        }
        log.error("No correct FileSystemChecker setted : " + (Object)((Object)this.chosenType) + " unable to create the FileSystemChecker. Available FileSystemCheckerType : " + FileSystemCheckerType.values() + " Please contact StoRM developers");
        throw new IllegalStateException("No correct FileSystemCheckerType setted : " + (Object)((Object)this.chosenType) + ". Available FileSystemCheckerType : " + FileSystemCheckerType.values() + " Please contact StoRM developers");
    }

    public static enum FileSystemCheckerType {
        Mtab,
        Mounts;

    }
}

