/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.ea.remote.resource;

import com.sun.jersey.server.impl.ResponseBuilderImpl;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RequestParameters {
    private static final Logger log = LoggerFactory.getLogger(RequestParameters.class);
    private final String filePathDecoded;
    private String checksumDecoded;

    RequestParameters(Builder builder) {
        this.filePathDecoded = RequestParameters.decodeAndCheckFilePath(builder.filePath);
        this.checksumDecoded = RequestParameters.decodeAndCheckChecksum(builder.checksum);
    }

    private static String decodeAndCheckFilePath(String filePath) throws WebApplicationException, IllegalArgumentException {
        String filePathDecoded;
        if (filePath == null) {
            throw new IllegalArgumentException("Unable to decode file path. Invalid parameters: filePath=" + filePath);
        }
        try {
            filePathDecoded = URLDecoder.decode(filePath, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error("Unable to decode filePath parameter. UnsupportedEncodingException : " + e.getMessage());
            ResponseBuilderImpl responseBuilder = new ResponseBuilderImpl();
            responseBuilder.status(Response.Status.BAD_REQUEST);
            responseBuilder.entity((Object)"Unable to decode filePath paramether, unsupported encoding 'UTF-8'");
            throw new WebApplicationException(responseBuilder.build());
        }
        log.debug("Decoded filePath = " + filePathDecoded);
        if (filePathDecoded == null || filePathDecoded.trim().equals("")) {
            log.error("Unable to evaluate permissions. Some parameters are missing : filePath " + filePathDecoded);
            ResponseBuilderImpl responseBuilder = new ResponseBuilderImpl();
            responseBuilder.status(Response.Status.BAD_REQUEST);
            responseBuilder.entity((Object)"Unable to manage checksum. Some parameters are missing");
            throw new WebApplicationException(responseBuilder.build());
        }
        return filePathDecoded;
    }

    private static String decodeAndCheckChecksum(String checksum) throws WebApplicationException {
        String checksumDecoded;
        if (checksum == null) {
            return null;
        }
        try {
            checksumDecoded = URLDecoder.decode(checksum, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error("Unable to decode checksum parameter. UnsupportedEncodingException : " + e.getMessage());
            ResponseBuilderImpl responseBuilder = new ResponseBuilderImpl();
            responseBuilder.status(Response.Status.BAD_REQUEST);
            responseBuilder.entity((Object)"Unable to decode checksum paramether, unsupported encoding 'UTF-8'");
            throw new WebApplicationException(responseBuilder.build());
        }
        log.debug("Decoded checksum = " + checksumDecoded);
        if (checksum == null || checksum.trim().equals("")) {
            log.error("Unable to evaluate permissions. Some parameters are missing : checksum " + checksumDecoded);
            ResponseBuilderImpl responseBuilder = new ResponseBuilderImpl();
            responseBuilder.status(Response.Status.BAD_REQUEST);
            responseBuilder.entity((Object)"Unable to manage checksum. Some parameters are missing");
            throw new WebApplicationException(responseBuilder.build());
        }
        return checksumDecoded;
    }

    public String getFilePathDecoded() {
        return this.filePathDecoded;
    }

    public String getChecksumDecoded() {
        return this.checksumDecoded;
    }

    public static class Builder {
        private final String filePath;
        private String checksum;

        public Builder(String filePath) throws WebApplicationException {
            this.filePath = filePath;
        }

        public Builder checksum(String checksum) {
            this.checksum = checksum;
            return this;
        }

        public RequestParameters build() {
            return new RequestParameters(this);
        }
    }
}

