/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.ea;

import it.grid.storm.checksum.ChecksumAlgorithm;
import it.grid.storm.ea.AttributeNotFoundException;
import it.grid.storm.ea.ExtendedAttributes;
import it.grid.storm.ea.ExtendedAttributesException;
import it.grid.storm.ea.FileNotFoundException;
import it.grid.storm.ea.NotSupportedException;
import it.grid.storm.jna.ExtendedAttributesImpl;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StormEA {
    private static final Logger log = LoggerFactory.getLogger(StormEA.class);
    private static final String EA_PINNED = "user.storm.pinned";
    private static final String EA_PREMIGRATE = "user.storm.premigrate";
    private static final String EA_CHECKSUM = "user.storm.checksum.";
    private static final String EA_MIGRATED = "user.storm.migrated";
    private static final ExtendedAttributes ea = new ExtendedAttributesImpl();

    public static Map<String, String> getChecksums(String filename) throws FileNotFoundException {
        HashMap<String, String> result = new HashMap<String, String>();
        for (ChecksumAlgorithm checksumAlgorithm : ChecksumAlgorithm.values()) {
            String cksm = null;
            try {
                cksm = StormEA.getChecksum(filename, checksumAlgorithm.toString());
            }
            catch (NotSupportedException e) {
                log.warn("Cannot retrieve checksum EA for algorithm " + (Object)((Object)checksumAlgorithm) + " (operation not supported) from file: " + filename + " NotSupportedException: " + e.getMessage());
            }
            catch (ExtendedAttributesException e) {
                if (e instanceof FileNotFoundException) {
                    throw (FileNotFoundException)e;
                }
                log.warn("Error manipulating EA for algorithm " + (Object)((Object)checksumAlgorithm) + " on file: " + filename + " ExtendedAttributesException: " + e.getMessage());
            }
            if (cksm == null) continue;
            result.put(checksumAlgorithm.toString(), cksm);
        }
        return result;
    }

    public static String getChecksum(String fileName, String algorithm) throws FileNotFoundException, ExtendedAttributesException, NotSupportedException {
        try {
            byte[] byteArray = ea.getXAttr(fileName, EA_CHECKSUM + algorithm.toLowerCase());
            return new String(byteArray);
        }
        catch (AttributeNotFoundException e) {
            return null;
        }
    }

    public static boolean getMigrated(String fileName) {
        try {
            ea.getXAttr(fileName, EA_MIGRATED);
        }
        catch (AttributeNotFoundException e) {
            return false;
        }
        catch (FileNotFoundException e) {
            log.warn("Cannot retrieve checksum EA because file does not exists: " + fileName);
            return false;
        }
        catch (NotSupportedException e) {
            log.warn("Cannot retrieve checksum EA (operation not supported) from file: " + fileName);
            return false;
        }
        catch (ExtendedAttributesException e) {
            log.warn("Cannot retrieve checksum EA from file: " + fileName);
            return false;
        }
        return true;
    }

    public static long getPinned(String fileName) {
        String longString = null;
        try {
            byte[] byteArray = ea.getXAttr(fileName, EA_PINNED);
            if (byteArray == null) {
                return -1L;
            }
            longString = new String(byteArray);
            if (longString != null) {
                log.debug("Retrieved PinLifeTime with value: '" + longString + "' (length:" + longString.length() + ")");
            }
            return Long.decode(longString);
        }
        catch (FileNotFoundException e) {
            log.warn("Cannot retrieve pinned EA because file does not exists: " + fileName);
        }
        catch (NotSupportedException e) {
            log.warn("Cannot retrieve pinned EA (operation not supported) to file: " + fileName);
        }
        catch (AttributeNotFoundException e) {
            log.debug("Cannot retrieve pinned (file is not pinned) EA to file: '" + fileName);
        }
        catch (NumberFormatException e) {
            log.warn("Value of pinned EA is not a number (found '" + longString + "'), assuming -1. File: " + fileName);
        }
        catch (ExtendedAttributesException e) {
            log.warn("Cannot retrieve pinned EA (" + e.getMessage() + ")to file: '" + fileName);
        }
        return -1L;
    }

    public static void removeChecksum(String fileName) {
        try {
            ea.rmXAttr(fileName, EA_CHECKSUM);
        }
        catch (FileNotFoundException e) {
            log.warn("Cannot remove 'user.storm.checksum.' EA because file does not exists: " + fileName);
        }
        catch (AttributeNotFoundException e) {
            log.info("Cannot remove 'user.storm.checksum.' EA because unable to find the attribute (Maybe already removed): " + fileName);
        }
        catch (NotSupportedException e) {
            log.warn("Cannot remove 'user.storm.checksum.' EA (operation not supported) to file: " + fileName);
        }
        catch (ExtendedAttributesException e) {
            log.warn("Cannot remove 'user.storm.checksum.' EA to file: " + fileName);
        }
    }

    public static void removePinned(String fileName) {
        try {
            ea.rmXAttr(fileName, EA_PINNED);
        }
        catch (FileNotFoundException e) {
            log.warn("Cannot remove 'user.storm.pinned' EA because file does not exists: " + fileName);
        }
        catch (AttributeNotFoundException e) {
            log.info("Cannot remove 'user.storm.pinned' EA because unable to find the attribute (Maybe already removed): " + fileName);
        }
        catch (NotSupportedException e) {
            log.warn("Cannot remove 'user.storm.pinned' EA (operation not supported) to file: " + fileName);
        }
        catch (ExtendedAttributesException e) {
            log.warn("Cannot remove 'user.storm.pinned' EA to file: " + fileName);
        }
    }

    public static void setChecksum(String fileName, String checksum, String algorithm) throws FileNotFoundException, NotSupportedException, ExtendedAttributesException {
        ea.setXAttr(fileName, EA_CHECKSUM + algorithm.toLowerCase(), checksum.getBytes());
    }

    public static void setPinned(String fileName, long expirationDateInSEC) {
        long existingPinValueInSEC = StormEA.getPinned(fileName);
        SimpleDateFormat formatter = new SimpleDateFormat("dd MMM yyyy HH:mm:ss");
        if (existingPinValueInSEC >= expirationDateInSEC) {
            log.debug("The file '" + fileName + "' is already Pinned and the pre-existing PinLifeTime is greater than the new one. Nothing is changed in EA. Expiration: " + formatter.format((Object)new Date(existingPinValueInSEC * 1000L)));
            return;
        }
        String longString = String.valueOf(expirationDateInSEC);
        try {
            ea.setXAttr(fileName, EA_PINNED, longString.getBytes());
            if (log.isDebugEnabled()) {
                if (existingPinValueInSEC == -1L) {
                    log.debug("Added the Pinned EA to '" + fileName + "' with expiration: " + formatter.format((Object)new Date(existingPinValueInSEC * 1000L)));
                } else {
                    log.debug("Updated the Pinned EA to '" + fileName + "' with expiration: " + formatter.format((Object)new Date(existingPinValueInSEC * 1000L)));
                }
            }
        }
        catch (FileNotFoundException e) {
            log.warn("Cannot set pinned EA because file does not exists: " + fileName);
        }
        catch (NotSupportedException e) {
            log.warn("Cannot set pinned EA (operation not supported) to file: " + fileName);
        }
        catch (ExtendedAttributesException e) {
            log.warn("Cannot set pinned EA to file: " + fileName);
        }
    }

    public static void setPremigrate(String fileName) {
        try {
            ea.setXAttr(fileName, EA_PREMIGRATE, null);
        }
        catch (FileNotFoundException e) {
            log.warn("Cannot set pre-migrate EA because file does not exists: " + fileName);
        }
        catch (NotSupportedException e) {
            log.warn("Cannot set pre-migrate EA (operation not supported) to file: " + fileName);
        }
        catch (ExtendedAttributesException e) {
            log.warn("Cannot set pre-migrate EA to file: " + fileName);
        }
    }

    public static boolean isPinned(String absoluteFileName) {
        boolean result = false;
        try {
            ea.getXAttr(absoluteFileName, EA_PINNED);
            result = true;
        }
        catch (FileNotFoundException e) {
            log.warn("Cannot check pinned EA because file does not exists: " + absoluteFileName);
        }
        catch (NotSupportedException e) {
            log.warn("Cannot check pinned EA (operation not supported) to file: " + absoluteFileName);
        }
        catch (AttributeNotFoundException e) {
            log.debug("Pinned EA is not attached to file: " + absoluteFileName);
            result = false;
        }
        catch (ExtendedAttributesException e) {
            log.warn("Cannot check pinned EA (" + e.getMessage() + ")to file: '" + absoluteFileName);
        }
        return result;
    }
}

