/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.config;

import it.grid.storm.config.Configuration;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.ini4j.Ini;
import org.ini4j.InvalidFileFormatException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IniReader {
    private static Logger log = LoggerFactory.getLogger(IniReader.class);
    private final String confPath;
    public static final String DEFAULT_CONF_PATH = Configuration.getInstance().configurationDir();
    private List<File> iniFiles = new ArrayList<File>();

    public IniReader() throws IllegalArgumentException {
        this(DEFAULT_CONF_PATH);
    }

    public IniReader(String configurationPath) throws IllegalArgumentException {
        if (configurationPath == null) {
            log.error("Null configurationPath argument provided");
            throw new IllegalArgumentException("Null configurationPath argument provided");
        }
        File confFolder = new File(configurationPath);
        if (!confFolder.isDirectory()) {
            log.error("The provided configurationPath " + configurationPath + " is not a valid directory");
            throw new IllegalArgumentException("The provided configurationPath " + configurationPath + " is not a valid directory");
        }
        this.confPath = configurationPath;
        for (File file : confFolder.listFiles()) {
            if (!file.isFile() || !file.getName().endsWith(".ini") && !file.getName().endsWith(".INI")) continue;
            this.iniFiles.add(file);
        }
        if (this.iniFiles.size() == 0) {
            log.error("The provided configurationPath " + configurationPath + " does not contains ini files");
            throw new IllegalArgumentException("The provided configurationPath " + configurationPath + " does not contains ini files");
        }
    }

    public final String getConfPath() {
        return this.confPath;
    }

    public Ini getIniFile(String iniFileName) throws IllegalArgumentException {
        if (iniFileName == null) {
            log.error("Null iniFileName argument provided");
            throw new IllegalArgumentException("Null iniFileName argument provided");
        }
        Ini ini = null;
        for (File iniFile : this.iniFiles) {
            if (!iniFile.getName().equals(iniFileName.trim())) continue;
            try {
                ini = new Ini((Reader)new FileReader(iniFile));
            }
            catch (InvalidFileFormatException e) {
                log.error("Unable to parse '" + iniFile + "' InvalidFileFormatException: ", (Throwable)e);
            }
            catch (FileNotFoundException e) {
                log.error("Unable to find '" + iniFile + "' FileNotFoundException: ", (Throwable)e);
            }
            catch (IOException e) {
                log.error("IO Exception during load '" + iniFile + "' IOException: ", (Throwable)e);
            }
            break;
        }
        return ini;
    }
}

