/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.config;

import it.grid.storm.config.ConfigReader;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;

public class Configuration {
    private ConfigReader cr = new ConfigReader();
    static Configuration instance = new Configuration();
    private static final String MANAGED_SURLS_KEY = "storm.service.SURL.endpoint";
    private static final String MANAGED_SURL_DEFAULT_PORTS_KEY = "storm.service.SURL.default-ports";
    private static final String SERVICE_HOSTNAME_KEY = "storm.service.FE-public.hostname";
    private static final String SERVICE_PORT_KEY = "storm.service.port";
    private static final String LIST_OF_MACHINE_NAMES_KEY = "storm.service.FE-list.hostnames";
    private static final String LIST_OF_MACHINE_IPS_KEY = "storm.service.FE-list.IPs";
    private static final String DB_DRIVER_KEY = "storm.service.request-db.dbms-vendor";
    private static final String DB_URL_1KEY = "storm.service.request-db.protocol";
    private static final String DB_URL_2KEY = "storm.service.request-db.host";
    private static final String DB_URL_3KEY = "storm.service.request-db.db-name";
    private static final String DB_USER_NAME_KEY = "storm.service.request-db.username";
    private static final String DB_PASSWORD_KEY = "storm.service.request-db.passwd";
    private static final String DB_RECONNECT_PERIOD_KEY = "asynch.db.ReconnectPeriod";
    private static final String DB_RECONNECT_DELAY_KEY = "asynch.db.DelayPeriod";
    private static final String CLEANING_INITIAL_DELAY_KEY = "gc.pinnedfiles.cleaning.delay";
    private static final String CLEANING_TIME_INTERVAL_KEY = "gc.pinnedfiles.cleaning.interval";
    private static final String FILE_DEFAULT_SIZE_KEY = "fileSize.default";
    private static final String FILE_LIFETIME_DEFAULT_KEY = "fileLifetime.default";
    private static final String PIN_LIFETIME_DEFAULT_KEY = "pinLifetime.default";
    private static final String PIN_LIFETIME_MAXIMUM_KEY = "pinLifetime.maximum";
    private static final String TRANSIT_INITIAL_DELAY_KEY = "transit.delay";
    private static final String TRANSIT_TIME_INTERVAL_KEY = "transit.interval";
    private static final String PICKING_INITIAL_DELAY_KEY = "asynch.PickingInitialDelay";
    private static final String PICKING_TIME_INTERVAL_KEY = "asynch.PickingTimeInterval";
    private static final String PICKING_MAX_BATCH_SIZE_KEY = "asynch.PickingMaxBatchSize";
    private static final String SRMCLIENT_PUT_TOTAL_RETRY_TIME_KEY = "asynch.srmclient.retrytime";
    private static final String SRMCLIENT_PUT_TIME_OUT_KEY = "asynch.srmclient.timeout";
    private static final String SRMCLIENT_PUT_SLEEP_TIME_KEY = "asynch.srmclient.sleeptime";
    private static final String SRMCLIENT_PUT_DONE_SLEEP_TIME_KEY = "asynch.srmclient.putdone.sleeptime";
    private static final String SRMCLIENT_PUT_DONE_TIME_OUT_KEY = "asynch.srmclient.putdone.timeout";
    private static final String MAX_XMLRPC_THREAD_KEY = "synchcall.xmlrpc.maxthread";
    private static final String LIST_OF_DEFAULT_SPACE_TOKEN_KEY = "storm.service.defaultSpaceTokens";
    private static final String GRIDFTP_TRANSFER_CLIENT_KEY = "asynch.gridftpclient";
    private static final String SRMCLIENT_KEY = "asynch.srmclient";
    private static final String COMMAND_SERVER_BINDING_PORT_KEY = "storm.commandserver.port";
    private static final String SERIAL_SCHEDULER_KEY = "scheduler.serial";
    private static final String BE_PERSISTENCE_DB_VENDOR_KEY = "persistence.internal-db.dbms-vendor";
    private static final String BE_PERSISTENCE_DBMS_URL_1KEY = "persistence.internal-db.host";
    private static final String BE_PERSISTENCE_DBMS_URL_2KEY = "storm.service.request-db.host";
    private static final String BE_PERSISTENCE_DB_NAME_KEY = "persistence.internal-db.db-name";
    private static final String BE_PERSISTENCEDB_USER_NAME_1KEY = "persistence.internal-db.username";
    private static final String BE_PERSISTENCEDB_USER_NAME_2KEY = "storm.service.request-db.username";
    private static final String BE_PERSISTENCE_DB_PASSWORD_1KEY = "persistence.internal-db.passwd";
    private static final String BE_PERSISTENCE_DB_PASSWORD_2KEY = "storm.service.request-db.passwd";
    private static final String BE_PERSISTENCE_POOL_DB_KEY = "persistence.internal-db.connection-pool";
    private static final String BE_PERSISTENCE_POOL_DB_MAX_ACTIVE_KEY = "persistence.internal-db.connection-pool.maxActive";
    private static final String BE_PERSISTENCE_POOL_DB_MAX_WAIT_KEY = "persistence.internal-db.connection-pool.maxWait";
    private static final String XMLRPC_SERVER_PORT_KEY = "synchcall.xmlrpc.unsecureServerPort";
    private static final String LS_MAX_NUMBER_OF_ENTRY_KEY = "synchcall.directoryManager.maxLsEntry";
    private static final String LS_ALL_LEVEL_RECURSIVE_KEY = "synchcall.directoryManager.default.AllLevelRecursive";
    private static final String LS_NUM_OF_LEVELS_KEY = "synchcall.directoryManager.default.Levels";
    private static final String LS_OFFSET_KEY = "synchcall.directoryManager.default.Offset";
    private static final String PTP_CORE_POOL_SIZE_KEY = "scheduler.chunksched.ptp.workerCorePoolSize";
    private static final String PTP_MAX_POOL_SIZE_KEY = "scheduler.chunksched.ptp.workerMaxPoolSize";
    private static final String PTP_QUEUE_SIZE_KEY = "scheduler.chunksched.ptp.queueSize";
    private static final String PTG_CORE_POOL_SIZE_KEY = "scheduler.chunksched.ptg.workerCorePoolSize";
    private static final String PTG_MAX_POOL_SIZE_KEY = "scheduler.chunksched.ptg.workerMaxPoolSize";
    private static final String PTG_QUEUE_SIZE_KEY = "scheduler.chunksched.ptg.queueSize";
    private static final String COPY_CORE_POOL_SIZE_KEY = "scheduler.chunksched.copy.workerCorePoolSize";
    private static final String COPY_MAX_POOL_SIZE_KEY = "scheduler.chunksched.copy.workerMaxPoolSize";
    private static final String COPY_QUEUE_SIZE_KEY = "scheduler.chunksched.copy.queueSize";
    private static final String BOL_CORE_POOL_SIZE_KEY = "scheduler.chunksched.bol.workerCorePoolSize";
    private static final String BOL_MAX_POOL_SIZE_KEY = "scheduler.chunksched.bol.workerMaxPoolSize";
    private static final String BOL_QUEUE_SIZE_KEY = "scheduler.chunksched.bol.queueSize";
    private static final String CORE_POOL_SIZE_KEY = "scheduler.crusher.workerCorePoolSize";
    private static final String MAX_POOL_SIZE_KEY = "scheduler.crusher.workerMaxPoolSize";
    private static final String QUEUE_SIZE_KEY = "scheduler.crusher.queueSize";
    private static final String NAMESPACE_CONFIG_FILENAME_KEY = "namespace.filename";
    private static final String NAMESPACE_SCHEMA_FILENAME_KEY = "namespace.schema.filename";
    private static final String NAMESPACE_CONFIG_REFRESH_RATE_IN_SECONDS_KEY = "namespace.refreshrate";
    private static final String NAMESPACE_AUTOMATIC_RELOADING_KEY = "namespace.automatic-config-reload";
    private static final String GRIDFTP_TIME_OUT_KEY = "asynch.srmcopy.gridftp.timeout";
    private static final String SRM22CLIENT_PIN_LIFE_TIME_KEY = "SRM22Client.PinLifeTime";
    private static final String PROXY_HOME_KEY = "proxy.home";
    private static final String AUTOMATIC_DIRECTORY_CREATION_KEY = "directory.automatic-creation";
    private static final String DEFAULT_OVERWRITE_MODE_KEY = "default.overwrite";
    private static final String DEFAULT_FILE_STORAGE_TYPE_KEY = "default.storagetype";
    private static final String PURGE_BATCH_SIZE_KEY = "purge.size";
    private static final String EXPIRED_REQUEST_TIME_KEY = "expired.request.time";
    private static final String REQUEST_PURGER_DELAY_KEY = "purge.delay";
    private static final String REQUEST_PURGER_PERIOD_KEY = "purge.interval";
    private static final String EXPIRED_REQUEST_PURGING_KEY = "purging";
    private static final String EXTRA_SLASHES_FOR_FILE_TURL_KEY = "extraslashes.file";
    private static final String EXTRA_SLASHES_FOR_RFIO_TURL_KEY = "extraslashes.rfio";
    private static final String EXTRA_SLASHES_FOR_GSIFTP_TURL_KEY = "extraslashes.gsiftp";
    private static final String EXTRA_SLASHES_FOR_ROOT_TURL_KEY = "extraslashes.root";
    private static final String PING_VALUES_PROPERTIES_FILENAME_KEY = "ping-properties.filename";
    private static final String HEARTHBEAT_PERIOD_KEY = "health.electrocardiogram.period";
    private static final String PERFORMANCE_GLANCE_TIME_INTERVAL_KEY = "health.performance.glance.timeInterval";
    private static final String PERFORMANCE_LOGBOOK_TIME_INTERVAL_KEY = "health.performance.logbook.timeInterval";
    private static final String PERFORMANCE_MEASURING_KEY = "health.performance.mesauring.enabled";
    private static final String BOOK_KEEPING_ENABLED_KEY = "health.bookkeeping.enabled";
    private static final String ENABLE_WRITE_PERM_ON_DIRECTORY_KEY = "directory.writeperm";
    private static final String MAX_LOOP_KEY = "abort.maxloop";
    private static final String GRID_USER_MAPPER_CLASSNAME_KEY = "griduser.mapper.classname";
    private static final String AUTHZ_DB_PATH_KEY = "authzdb.path";
    private static final String REFRESH_RATE_AUTHZDB_FILES_IN_SECONDS_KEY = "authzdb.refreshrate";
    private static final String CHECKSUM_ALGORITHM_KEY = "checksum.algorithm";
    private static final String RECALL_TABLE_TESTING_MODE_KEY = "tape.recalltable.service.test-mode";
    private static final String REST_SERVICES_PORT_KEY = "storm.rest.services.port";
    private static final String RETRY_VALUE_KEY_KEY = "tape.recalltable.service.param.retry-value";
    private static final String STATUS_KEY_KEY = "tape.recalltable.service.param.status";
    private static final String TASKOVER_KEY_KEY = "tape.recalltable.service.param.takeover";
    private static final String GRIDHTTPS_ENABLED_KEY = "gridhttps.enabled";
    private static final String GRIDHTTPS_PLUGIN_CLASSNAME_KEY = "gridhttps.plugin.classname";
    private static final String STORM_PROPERTIES_VERSION_KEY = "storm.properties.version";
    private static final String GROUP_TAPE_READ_BUFFER_KEY = "tape.buffer.group.read";
    private static final String GROUP_TAPE_WRITE_BUFFER_KEY = "tape.buffer.group.write";
    private static final String TAPE_SUPPORT_ENABLED_KEY = "tape.support.enabled";
    private static final String SYNCHRONOUS_QUOTA_CHECK_ENABLED_KEY = "info.quota-check.enabled";
    private static final String GPFS_QUOTA_REFRESH_PERIOD_KEY = "info.quota.refresh.period";
    private static final String FAST_BOOTSTRAP_ENABLED_KEY = "bootstrap.fast.enabled";
    private static final String SERVER_POOL_STATUS_CHECK_TIMEOUT_KEY = "server-pool.status-check.timeout";
    private static final String SANITY_CHECK_ENABLED_KEY = "sanity-check.enabled";

    private Configuration() {
    }

    public static Configuration getInstance() {
        return instance;
    }

    public void setConfigReader(ConfigReader cr) {
        if (cr != null) {
            this.cr = cr;
        }
    }

    public String configurationDir() {
        return this.cr.configurationDirectory();
    }

    public String namespaceConfigPath() {
        String storm_home = System.getProperty("user.dir");
        String configDir = storm_home + File.separator + "etc";
        return configDir;
    }

    public String[] getManagedSURLs() {
        String[] defaultValue = new String[]{"UNDEFINED_SERVICE_ENDPOINT"};
        if (!this.cr.getConfiguration().containsKey(MANAGED_SURLS_KEY)) {
            return defaultValue;
        }
        return this.cr.getConfiguration().getStringArray(MANAGED_SURLS_KEY);
    }

    public Integer[] getManagedSurlDefaultPorts() {
        Integer[] portsArray;
        if (!this.cr.getConfiguration().containsKey(MANAGED_SURL_DEFAULT_PORTS_KEY)) {
            portsArray = new Integer[]{8444};
        } else {
            String[] portString = this.cr.getConfiguration().getStringArray(MANAGED_SURL_DEFAULT_PORTS_KEY);
            ArrayList<Integer> ports = new ArrayList<Integer>();
            for (String port : portString) {
                ports.add(Integer.parseInt(port.trim()));
            }
            portsArray = ports.toArray(new Integer[0]);
        }
        return portsArray;
    }

    public String getServiceHostname() {
        String defaultValue = "UNDEFINED_STORM_HOSTNAME";
        if (!this.cr.getConfiguration().containsKey(SERVICE_HOSTNAME_KEY)) {
            return defaultValue;
        }
        return this.cr.getConfiguration().getString(SERVICE_HOSTNAME_KEY);
    }

    public int getServicePort() {
        int defaultValue = 8444;
        if (!this.cr.getConfiguration().containsKey(SERVICE_PORT_KEY)) {
            return defaultValue;
        }
        return this.cr.getConfiguration().getInt(SERVICE_PORT_KEY);
    }

    public List<String> getListOfMachineNames() {
        if (this.cr.getConfiguration().containsKey(LIST_OF_MACHINE_NAMES_KEY)) {
            String[] names = this.cr.getConfiguration().getStringArray(LIST_OF_MACHINE_NAMES_KEY);
            for (int i = 0; i < names.length; ++i) {
                names[i] = names[i].trim().toLowerCase();
            }
            return Arrays.asList(names);
        }
        return Arrays.asList("localhost");
    }

    public List<String> getListOfMachineIPs() {
        if (this.cr.getConfiguration().containsKey(LIST_OF_MACHINE_IPS_KEY)) {
            String[] names = this.cr.getConfiguration().getString(LIST_OF_MACHINE_IPS_KEY).split(";");
            for (int i = 0; i < names.length; ++i) {
                names[i] = names[i].trim().toLowerCase();
            }
            return Arrays.asList(names);
        }
        return Arrays.asList("127.0.0.1");
    }

    public String getDBDriver() {
        if (!this.cr.getConfiguration().containsKey(DB_DRIVER_KEY)) {
            return "com.mysql.jdbc.Driver";
        }
        String vendor = this.cr.getConfiguration().getString(DB_DRIVER_KEY);
        String driver = "";
        if (vendor.toLowerCase().equals("mysql")) {
            driver = "com.mysql.jdbc.Driver";
        } else {
            System.err.println("CONFIG ERROR 'RDBMS Vendor ('" + vendor + "')unknown.' ");
        }
        return driver;
    }

    public String getDBURL() {
        String prefix = "";
        String host = "";
        String name = "";
        prefix = !this.cr.getConfiguration().containsKey(DB_URL_1KEY) ? "jdbc:mysql://" : this.cr.getConfiguration().getString(DB_URL_1KEY);
        host = !this.cr.getConfiguration().containsKey("storm.service.request-db.host") ? "localhost" : this.cr.getConfiguration().getString("storm.service.request-db.host");
        name = !this.cr.getConfiguration().containsKey(DB_URL_3KEY) ? "storm_db" : this.cr.getConfiguration().getString(DB_URL_3KEY);
        return prefix + host + "/" + name;
    }

    public String getDBUserName() {
        if (!this.cr.getConfiguration().containsKey("storm.service.request-db.username")) {
            return "storm";
        }
        return this.cr.getConfiguration().getString("storm.service.request-db.username");
    }

    public String getDBPassword() {
        if (!this.cr.getConfiguration().containsKey("storm.service.request-db.passwd")) {
            return "storm";
        }
        return this.cr.getConfiguration().getString("storm.service.request-db.passwd");
    }

    public long getDBReconnectPeriod() {
        if (!this.cr.getConfiguration().containsKey(DB_RECONNECT_PERIOD_KEY)) {
            return 18000L;
        }
        return this.cr.getConfiguration().getLong(DB_RECONNECT_PERIOD_KEY);
    }

    public long getDBReconnectDelay() {
        if (!this.cr.getConfiguration().containsKey(DB_RECONNECT_DELAY_KEY)) {
            return 30L;
        }
        return this.cr.getConfiguration().getLong(DB_RECONNECT_DELAY_KEY);
    }

    public long getCleaningInitialDelay() {
        if (!this.cr.getConfiguration().containsKey(CLEANING_INITIAL_DELAY_KEY)) {
            return 10L;
        }
        return this.cr.getConfiguration().getLong(CLEANING_INITIAL_DELAY_KEY);
    }

    public long getCleaningTimeInterval() {
        if (!this.cr.getConfiguration().containsKey(CLEANING_TIME_INTERVAL_KEY)) {
            return 300L;
        }
        return this.cr.getConfiguration().getLong(CLEANING_TIME_INTERVAL_KEY);
    }

    public long getFileDefaultSize() {
        if (!this.cr.getConfiguration().containsKey(FILE_DEFAULT_SIZE_KEY)) {
            return 1000000L;
        }
        return this.cr.getConfiguration().getLong(FILE_DEFAULT_SIZE_KEY);
    }

    public long getFileLifetimeDefault() {
        if (!this.cr.getConfiguration().containsKey(FILE_LIFETIME_DEFAULT_KEY)) {
            return 3600L;
        }
        return this.cr.getConfiguration().getLong(FILE_LIFETIME_DEFAULT_KEY);
    }

    public long getPinLifetimeDefault() {
        if (!this.cr.getConfiguration().containsKey(PIN_LIFETIME_DEFAULT_KEY)) {
            return 259200L;
        }
        return this.cr.getConfiguration().getLong(PIN_LIFETIME_DEFAULT_KEY);
    }

    public long getPinLifetimeMaximum() {
        if (!this.cr.getConfiguration().containsKey(PIN_LIFETIME_MAXIMUM_KEY)) {
            return 1814400L;
        }
        return this.cr.getConfiguration().getLong(PIN_LIFETIME_MAXIMUM_KEY);
    }

    public long getTransitInitialDelay() {
        if (!this.cr.getConfiguration().containsKey(TRANSIT_INITIAL_DELAY_KEY)) {
            return 10L;
        }
        return this.cr.getConfiguration().getLong(TRANSIT_INITIAL_DELAY_KEY);
    }

    public long getTransitTimeInterval() {
        if (!this.cr.getConfiguration().containsKey(TRANSIT_TIME_INTERVAL_KEY)) {
            return 300L;
        }
        return this.cr.getConfiguration().getLong(TRANSIT_TIME_INTERVAL_KEY);
    }

    public long getPickingInitialDelay() {
        if (!this.cr.getConfiguration().containsKey(PICKING_INITIAL_DELAY_KEY)) {
            return 1L;
        }
        return this.cr.getConfiguration().getLong(PICKING_INITIAL_DELAY_KEY);
    }

    public long getPickingTimeInterval() {
        if (!this.cr.getConfiguration().containsKey(PICKING_TIME_INTERVAL_KEY)) {
            return 2L;
        }
        return this.cr.getConfiguration().getLong(PICKING_TIME_INTERVAL_KEY);
    }

    public int getPickingMaxBatchSize() {
        if (!this.cr.getConfiguration().containsKey(PICKING_MAX_BATCH_SIZE_KEY)) {
            return 100;
        }
        return this.cr.getConfiguration().getInt(PICKING_MAX_BATCH_SIZE_KEY);
    }

    public long getSRMClientPutTotalRetryTime() {
        if (!this.cr.getConfiguration().containsKey(SRMCLIENT_PUT_TOTAL_RETRY_TIME_KEY)) {
            return 60L;
        }
        return this.cr.getConfiguration().getLong(SRMCLIENT_PUT_TOTAL_RETRY_TIME_KEY);
    }

    public long getSRMClientPutTimeOut() {
        if (!this.cr.getConfiguration().containsKey(SRMCLIENT_PUT_TIME_OUT_KEY)) {
            return 180L;
        }
        return this.cr.getConfiguration().getLong(SRMCLIENT_PUT_TIME_OUT_KEY);
    }

    public long getSRMClientPutSleepTime() {
        if (!this.cr.getConfiguration().containsKey(SRMCLIENT_PUT_SLEEP_TIME_KEY)) {
            return 5L;
        }
        return this.cr.getConfiguration().getLong(SRMCLIENT_PUT_SLEEP_TIME_KEY);
    }

    public long getSRMClientPutDoneSleepTime() {
        if (!this.cr.getConfiguration().containsKey(SRMCLIENT_PUT_DONE_SLEEP_TIME_KEY)) {
            return 1L;
        }
        return this.cr.getConfiguration().getLong(SRMCLIENT_PUT_DONE_SLEEP_TIME_KEY);
    }

    public long getSRMClientPutDoneTimeOut() {
        if (!this.cr.getConfiguration().containsKey(SRMCLIENT_PUT_DONE_TIME_OUT_KEY)) {
            return 60L;
        }
        return this.cr.getConfiguration().getLong(SRMCLIENT_PUT_DONE_TIME_OUT_KEY);
    }

    public int getMaxXMLRPCThread() {
        if (!this.cr.getConfiguration().containsKey(MAX_XMLRPC_THREAD_KEY)) {
            return 100;
        }
        return this.cr.getConfiguration().getInt(MAX_XMLRPC_THREAD_KEY);
    }

    public List<String> getListOfDefaultSpaceToken() {
        if (this.cr.getConfiguration().containsKey(LIST_OF_DEFAULT_SPACE_TOKEN_KEY)) {
            String[] namesArray = this.cr.getConfiguration().getStringArray(LIST_OF_DEFAULT_SPACE_TOKEN_KEY);
            if (namesArray == null) {
                return new ArrayList<String>();
            }
            return Arrays.asList(namesArray);
        }
        return new ArrayList<String>();
    }

    public String getGridFTPTransferClient() {
        if (!this.cr.getConfiguration().containsKey(GRIDFTP_TRANSFER_CLIENT_KEY)) {
            return "it.grid.storm.asynch.NaiveGridFTPTransferClient";
        }
        return this.cr.getConfiguration().getString(GRIDFTP_TRANSFER_CLIENT_KEY);
    }

    public String getSRMClient() {
        if (!this.cr.getConfiguration().containsKey(SRMCLIENT_KEY)) {
            return "it.grid.storm.asynch.SRM22Client";
        }
        return this.cr.getConfiguration().getString(SRMCLIENT_KEY);
    }

    public int getCommandServerBindingPort() {
        if (!this.cr.getConfiguration().containsKey(COMMAND_SERVER_BINDING_PORT_KEY)) {
            return 4444;
        }
        return this.cr.getConfiguration().getInt(COMMAND_SERVER_BINDING_PORT_KEY);
    }

    public boolean getSerialScheduler() {
        if (!this.cr.getConfiguration().containsKey(SERIAL_SCHEDULER_KEY)) {
            return false;
        }
        return this.cr.getConfiguration().getBoolean(SERIAL_SCHEDULER_KEY);
    }

    public String getBEPersistenceDBVendor() {
        if (!this.cr.getConfiguration().containsKey(BE_PERSISTENCE_DB_VENDOR_KEY)) {
            return "mysql";
        }
        return this.cr.getConfiguration().getString(BE_PERSISTENCE_DB_VENDOR_KEY);
    }

    public String getBEPersistenceDBMSUrl() {
        if (!this.cr.getConfiguration().containsKey(BE_PERSISTENCE_DBMS_URL_1KEY)) {
            if (!this.cr.getConfiguration().containsKey("storm.service.request-db.host")) {
                return "localhost";
            }
            return this.cr.getConfiguration().getString("storm.service.request-db.host");
        }
        return this.cr.getConfiguration().getString(BE_PERSISTENCE_DBMS_URL_1KEY);
    }

    public String getBEPersistenceDBName() {
        if (!this.cr.getConfiguration().containsKey(BE_PERSISTENCE_DB_NAME_KEY)) {
            return "storm_be_ISAM";
        }
        return this.cr.getConfiguration().getString(BE_PERSISTENCE_DB_NAME_KEY);
    }

    public String getBEPersistenceDBUserName() {
        if (!this.cr.getConfiguration().containsKey(BE_PERSISTENCEDB_USER_NAME_1KEY)) {
            if (!this.cr.getConfiguration().containsKey("storm.service.request-db.username")) {
                return "storm";
            }
            return this.cr.getConfiguration().getString("storm.service.request-db.username");
        }
        return this.cr.getConfiguration().getString(BE_PERSISTENCEDB_USER_NAME_1KEY);
    }

    public String getBEPersistenceDBPassword() {
        if (!this.cr.getConfiguration().containsKey(BE_PERSISTENCE_DB_PASSWORD_1KEY)) {
            if (!this.cr.getConfiguration().containsKey("storm.service.request-db.passwd")) {
                return "storm";
            }
            return this.cr.getConfiguration().getString("storm.service.request-db.passwd");
        }
        return this.cr.getConfiguration().getString(BE_PERSISTENCE_DB_PASSWORD_1KEY);
    }

    public boolean getBEPersistencePoolDB() {
        if (!this.cr.getConfiguration().containsKey(BE_PERSISTENCE_POOL_DB_KEY)) {
            return false;
        }
        return this.cr.getConfiguration().getBoolean(BE_PERSISTENCE_POOL_DB_KEY);
    }

    public int getBEPersistencePoolDBMaxActive() {
        if (!this.cr.getConfiguration().containsKey(BE_PERSISTENCE_POOL_DB_MAX_ACTIVE_KEY)) {
            return 10;
        }
        return this.cr.getConfiguration().getInt(BE_PERSISTENCE_POOL_DB_MAX_ACTIVE_KEY);
    }

    public int getBEPersistencePoolDBMaxWait() {
        if (!this.cr.getConfiguration().containsKey(BE_PERSISTENCE_POOL_DB_MAX_WAIT_KEY)) {
            return 50;
        }
        return this.cr.getConfiguration().getInt(BE_PERSISTENCE_POOL_DB_MAX_WAIT_KEY);
    }

    public int getXmlRpcServerPort() {
        if (!this.cr.getConfiguration().containsKey(XMLRPC_SERVER_PORT_KEY)) {
            return 8080;
        }
        return this.cr.getConfiguration().getInt(XMLRPC_SERVER_PORT_KEY);
    }

    public int getLSMaxNumberOfEntry() {
        if (!this.cr.getConfiguration().containsKey(LS_MAX_NUMBER_OF_ENTRY_KEY)) {
            return 500;
        }
        return this.cr.getConfiguration().getInt(LS_MAX_NUMBER_OF_ENTRY_KEY);
    }

    public boolean getLSallLevelRecursive() {
        if (!this.cr.getConfiguration().containsKey(LS_ALL_LEVEL_RECURSIVE_KEY)) {
            return false;
        }
        return this.cr.getConfiguration().getBoolean(LS_ALL_LEVEL_RECURSIVE_KEY);
    }

    public int getLSnumOfLevels() {
        if (!this.cr.getConfiguration().containsKey(LS_NUM_OF_LEVELS_KEY)) {
            return 1;
        }
        return this.cr.getConfiguration().getInt(LS_NUM_OF_LEVELS_KEY);
    }

    public int getLSoffset() {
        if (!this.cr.getConfiguration().containsKey(LS_OFFSET_KEY)) {
            return 0;
        }
        return this.cr.getConfiguration().getInt(LS_OFFSET_KEY);
    }

    public int getPtPCorePoolSize() {
        if (!this.cr.getConfiguration().containsKey(PTP_CORE_POOL_SIZE_KEY)) {
            return 50;
        }
        return this.cr.getConfiguration().getInt(PTP_CORE_POOL_SIZE_KEY);
    }

    public int getPtPMaxPoolSize() {
        if (!this.cr.getConfiguration().containsKey(PTP_MAX_POOL_SIZE_KEY)) {
            return 200;
        }
        return this.cr.getConfiguration().getInt(PTP_MAX_POOL_SIZE_KEY);
    }

    public int getPtPQueueSize() {
        if (!this.cr.getConfiguration().containsKey(PTP_QUEUE_SIZE_KEY)) {
            return 1000;
        }
        return this.cr.getConfiguration().getInt(PTP_QUEUE_SIZE_KEY);
    }

    public int getPtGCorePoolSize() {
        if (!this.cr.getConfiguration().containsKey(PTG_CORE_POOL_SIZE_KEY)) {
            return 50;
        }
        return this.cr.getConfiguration().getInt(PTG_CORE_POOL_SIZE_KEY);
    }

    public int getPtGMaxPoolSize() {
        if (!this.cr.getConfiguration().containsKey(PTG_MAX_POOL_SIZE_KEY)) {
            return 200;
        }
        return this.cr.getConfiguration().getInt(PTG_MAX_POOL_SIZE_KEY);
    }

    public int getPtGQueueSize() {
        if (!this.cr.getConfiguration().containsKey(PTG_QUEUE_SIZE_KEY)) {
            return 2000;
        }
        return this.cr.getConfiguration().getInt(PTG_QUEUE_SIZE_KEY);
    }

    public int getCopyCorePoolSize() {
        if (!this.cr.getConfiguration().containsKey(COPY_CORE_POOL_SIZE_KEY)) {
            return 10;
        }
        return this.cr.getConfiguration().getInt(COPY_CORE_POOL_SIZE_KEY);
    }

    public int getCopyMaxPoolSize() {
        if (!this.cr.getConfiguration().containsKey(COPY_MAX_POOL_SIZE_KEY)) {
            return 50;
        }
        return this.cr.getConfiguration().getInt(COPY_MAX_POOL_SIZE_KEY);
    }

    public int getCopyQueueSize() {
        if (!this.cr.getConfiguration().containsKey(COPY_QUEUE_SIZE_KEY)) {
            return 500;
        }
        return this.cr.getConfiguration().getInt(COPY_QUEUE_SIZE_KEY);
    }

    public int getBoLCorePoolSize() {
        if (!this.cr.getConfiguration().containsKey(BOL_CORE_POOL_SIZE_KEY)) {
            return 50;
        }
        return this.cr.getConfiguration().getInt(BOL_CORE_POOL_SIZE_KEY);
    }

    public int getBoLMaxPoolSize() {
        if (!this.cr.getConfiguration().containsKey(BOL_MAX_POOL_SIZE_KEY)) {
            return 200;
        }
        return this.cr.getConfiguration().getInt(BOL_MAX_POOL_SIZE_KEY);
    }

    public int getBoLQueueSize() {
        if (!this.cr.getConfiguration().containsKey(BOL_QUEUE_SIZE_KEY)) {
            return 2000;
        }
        return this.cr.getConfiguration().getInt(BOL_QUEUE_SIZE_KEY);
    }

    public int getCorePoolSize() {
        if (!this.cr.getConfiguration().containsKey(CORE_POOL_SIZE_KEY)) {
            return 10;
        }
        return this.cr.getConfiguration().getInt(CORE_POOL_SIZE_KEY);
    }

    public int getMaxPoolSize() {
        if (!this.cr.getConfiguration().containsKey(MAX_POOL_SIZE_KEY)) {
            return 50;
        }
        return this.cr.getConfiguration().getInt(MAX_POOL_SIZE_KEY);
    }

    public int getQueueSize() {
        if (!this.cr.getConfiguration().containsKey(QUEUE_SIZE_KEY)) {
            return 2000;
        }
        return this.cr.getConfiguration().getInt(QUEUE_SIZE_KEY);
    }

    public String getNamespaceConfigFilename() {
        if (!this.cr.getConfiguration().containsKey(NAMESPACE_CONFIG_FILENAME_KEY)) {
            return "namespace.xml";
        }
        return this.cr.getConfiguration().getString(NAMESPACE_CONFIG_FILENAME_KEY);
    }

    public String getNamespaceSchemaFilename() {
        if (!this.cr.getConfiguration().containsKey(NAMESPACE_SCHEMA_FILENAME_KEY)) {
            return "Schema UNKNOWN!";
        }
        return this.cr.getConfiguration().getString(NAMESPACE_SCHEMA_FILENAME_KEY);
    }

    public int getNamespaceConfigRefreshRateInSeconds() {
        if (!this.cr.getConfiguration().containsKey(NAMESPACE_CONFIG_REFRESH_RATE_IN_SECONDS_KEY)) {
            return 3;
        }
        return this.cr.getConfiguration().getInt(NAMESPACE_CONFIG_REFRESH_RATE_IN_SECONDS_KEY);
    }

    public boolean getNamespaceAutomaticReloading() {
        if (!this.cr.getConfiguration().containsKey(NAMESPACE_AUTOMATIC_RELOADING_KEY)) {
            return false;
        }
        return this.cr.getConfiguration().getBoolean(NAMESPACE_AUTOMATIC_RELOADING_KEY);
    }

    public int getGridFTPTimeOut() {
        if (!this.cr.getConfiguration().containsKey(GRIDFTP_TIME_OUT_KEY)) {
            return 15000;
        }
        return this.cr.getConfiguration().getInt(GRIDFTP_TIME_OUT_KEY);
    }

    public int getSRM22ClientPinLifeTime() {
        if (!this.cr.getConfiguration().containsKey(SRM22CLIENT_PIN_LIFE_TIME_KEY)) {
            return 259200;
        }
        return this.cr.getConfiguration().getInt(SRM22CLIENT_PIN_LIFE_TIME_KEY);
    }

    public String getProxyHome() {
        if (!this.cr.getConfiguration().containsKey(PROXY_HOME_KEY)) {
            return "/opt/storm/var/proxies";
        }
        return this.cr.getConfiguration().getString(PROXY_HOME_KEY);
    }

    public boolean getAutomaticDirectoryCreation() {
        if (!this.cr.getConfiguration().containsKey(AUTOMATIC_DIRECTORY_CREATION_KEY)) {
            return false;
        }
        return this.cr.getConfiguration().getBoolean(AUTOMATIC_DIRECTORY_CREATION_KEY);
    }

    public String getDefaultOverwriteMode() {
        if (!this.cr.getConfiguration().containsKey(DEFAULT_OVERWRITE_MODE_KEY)) {
            return "N";
        }
        return this.cr.getConfiguration().getString(DEFAULT_OVERWRITE_MODE_KEY);
    }

    public String getDefaultFileStorageType() {
        if (!this.cr.getConfiguration().containsKey(DEFAULT_FILE_STORAGE_TYPE_KEY)) {
            return "V";
        }
        return this.cr.getConfiguration().getString(DEFAULT_FILE_STORAGE_TYPE_KEY);
    }

    public int getPurgeBatchSize() {
        if (!this.cr.getConfiguration().containsKey(PURGE_BATCH_SIZE_KEY)) {
            return 800;
        }
        return this.cr.getConfiguration().getInt(PURGE_BATCH_SIZE_KEY);
    }

    public long getExpiredRequestTime() {
        if (!this.cr.getConfiguration().containsKey(EXPIRED_REQUEST_TIME_KEY)) {
            return 604800L;
        }
        return this.cr.getConfiguration().getInt(EXPIRED_REQUEST_TIME_KEY);
    }

    public int getRequestPurgerDelay() {
        if (!this.cr.getConfiguration().containsKey(REQUEST_PURGER_DELAY_KEY)) {
            return 10;
        }
        return this.cr.getConfiguration().getInt(REQUEST_PURGER_DELAY_KEY);
    }

    public int getRequestPurgerPeriod() {
        if (!this.cr.getConfiguration().containsKey(REQUEST_PURGER_PERIOD_KEY)) {
            return 600;
        }
        return this.cr.getConfiguration().getInt(REQUEST_PURGER_PERIOD_KEY);
    }

    public boolean getExpiredRequestPurging() {
        if (!this.cr.getConfiguration().containsKey(EXPIRED_REQUEST_PURGING_KEY)) {
            return true;
        }
        return this.cr.getConfiguration().getBoolean(EXPIRED_REQUEST_PURGING_KEY);
    }

    public String getExtraSlashesForFileTURL() {
        if (!this.cr.getConfiguration().containsKey(EXTRA_SLASHES_FOR_FILE_TURL_KEY)) {
            return "";
        }
        return this.cr.getConfiguration().getString(EXTRA_SLASHES_FOR_FILE_TURL_KEY);
    }

    public String getExtraSlashesForRFIOTURL() {
        if (!this.cr.getConfiguration().containsKey(EXTRA_SLASHES_FOR_RFIO_TURL_KEY)) {
            return "";
        }
        return this.cr.getConfiguration().getString(EXTRA_SLASHES_FOR_RFIO_TURL_KEY);
    }

    public String getExtraSlashesForGsiFTPTURL() {
        if (!this.cr.getConfiguration().containsKey(EXTRA_SLASHES_FOR_GSIFTP_TURL_KEY)) {
            return "";
        }
        return this.cr.getConfiguration().getString(EXTRA_SLASHES_FOR_GSIFTP_TURL_KEY);
    }

    public String getExtraSlashesForROOTTURL() {
        if (!this.cr.getConfiguration().containsKey(EXTRA_SLASHES_FOR_ROOT_TURL_KEY)) {
            return "/";
        }
        return this.cr.getConfiguration().getString(EXTRA_SLASHES_FOR_ROOT_TURL_KEY);
    }

    public String getPingValuesPropertiesFilename() {
        if (!this.cr.getConfiguration().containsKey(PING_VALUES_PROPERTIES_FILENAME_KEY)) {
            return "ping-values.properties";
        }
        return this.cr.getConfiguration().getString(PING_VALUES_PROPERTIES_FILENAME_KEY);
    }

    public int getHearthbeatPeriod() {
        if (!this.cr.getConfiguration().containsKey(HEARTHBEAT_PERIOD_KEY)) {
            return 60;
        }
        return this.cr.getConfiguration().getInt(HEARTHBEAT_PERIOD_KEY);
    }

    public int getPerformanceGlanceTimeInterval() {
        if (!this.cr.getConfiguration().containsKey(PERFORMANCE_GLANCE_TIME_INTERVAL_KEY)) {
            return 15;
        }
        return this.cr.getConfiguration().getInt(PERFORMANCE_GLANCE_TIME_INTERVAL_KEY);
    }

    public int getPerformanceLogbookTimeInterval() {
        if (!this.cr.getConfiguration().containsKey(PERFORMANCE_LOGBOOK_TIME_INTERVAL_KEY)) {
            return 15;
        }
        return this.cr.getConfiguration().getInt(PERFORMANCE_LOGBOOK_TIME_INTERVAL_KEY);
    }

    public boolean getPerformanceMeasuring() {
        if (!this.cr.getConfiguration().containsKey(PERFORMANCE_MEASURING_KEY)) {
            return false;
        }
        return this.cr.getConfiguration().getBoolean(PERFORMANCE_MEASURING_KEY);
    }

    public boolean getBookKeepingEnabled() {
        if (!this.cr.getConfiguration().containsKey(BOOK_KEEPING_ENABLED_KEY)) {
            return false;
        }
        return this.cr.getConfiguration().getBoolean(BOOK_KEEPING_ENABLED_KEY);
    }

    public boolean getEnableWritePermOnDirectory() {
        if (!this.cr.getConfiguration().containsKey(ENABLE_WRITE_PERM_ON_DIRECTORY_KEY)) {
            return false;
        }
        return this.cr.getConfiguration().getBoolean(ENABLE_WRITE_PERM_ON_DIRECTORY_KEY, false);
    }

    public int getMaxLoop() {
        if (!this.cr.getConfiguration().containsKey(MAX_LOOP_KEY)) {
            return 10;
        }
        return this.cr.getConfiguration().getInt(MAX_LOOP_KEY);
    }

    public String getGridUserMapperClassname() {
        if (!this.cr.getConfiguration().containsKey(GRID_USER_MAPPER_CLASSNAME_KEY)) {
            return "it.grid.storm.griduser.StormLcmapsJNAMapper";
        }
        return this.cr.getConfiguration().getString(GRID_USER_MAPPER_CLASSNAME_KEY);
    }

    public String getAuthzDBPath() {
        if (!this.cr.getConfiguration().containsKey(AUTHZ_DB_PATH_KEY)) {
            return this.cr.configurationDirectory();
        }
        return this.cr.getConfiguration().getString(AUTHZ_DB_PATH_KEY);
    }

    public int getRefreshRateAuthzDBfilesInSeconds() {
        if (!this.cr.getConfiguration().containsKey(REFRESH_RATE_AUTHZDB_FILES_IN_SECONDS_KEY)) {
            return 5;
        }
        return this.cr.getConfiguration().getInt(REFRESH_RATE_AUTHZDB_FILES_IN_SECONDS_KEY);
    }

    public String getChecksumAlgorithm() {
        if (this.cr.getConfiguration().containsKey(CHECKSUM_ALGORITHM_KEY)) {
            return this.cr.getConfiguration().getString(CHECKSUM_ALGORITHM_KEY);
        }
        return "Adler32";
    }

    public boolean getRecallTableTestingMode() {
        if (this.cr.getConfiguration().containsKey(RECALL_TABLE_TESTING_MODE_KEY)) {
            return this.cr.getConfiguration().getBoolean(RECALL_TABLE_TESTING_MODE_KEY);
        }
        return false;
    }

    public int getRestServicesPort() {
        if (!this.cr.getConfiguration().containsKey(REST_SERVICES_PORT_KEY)) {
            return 9998;
        }
        return this.cr.getConfiguration().getInt(REST_SERVICES_PORT_KEY);
    }

    public String getRetryValueKey() {
        if (!this.cr.getConfiguration().containsKey(RETRY_VALUE_KEY_KEY)) {
            return "retry-value";
        }
        return this.cr.getConfiguration().getString(RETRY_VALUE_KEY_KEY);
    }

    public String getStatusKey() {
        if (!this.cr.getConfiguration().containsKey(STATUS_KEY_KEY)) {
            return "status";
        }
        return this.cr.getConfiguration().getString(STATUS_KEY_KEY);
    }

    public String getTaskoverKey() {
        if (!this.cr.getConfiguration().containsKey(TASKOVER_KEY_KEY)) {
            return "first";
        }
        return this.cr.getConfiguration().getString(TASKOVER_KEY_KEY);
    }

    public boolean getGridhttpsEnabled() {
        if (!this.cr.getConfiguration().containsKey(GRIDHTTPS_ENABLED_KEY)) {
            return false;
        }
        return this.cr.getConfiguration().getBoolean(GRIDHTTPS_ENABLED_KEY);
    }

    public String getStoRMPropertiesVersion() {
        if (!this.cr.getConfiguration().containsKey(STORM_PROPERTIES_VERSION_KEY)) {
            return "No version specified";
        }
        return this.cr.getConfiguration().getString(STORM_PROPERTIES_VERSION_KEY);
    }

    public boolean getTapeSupportEnabled() {
        if (!this.cr.getConfiguration().containsKey(TAPE_SUPPORT_ENABLED_KEY)) {
            return false;
        }
        return this.cr.getConfiguration().getBoolean(TAPE_SUPPORT_ENABLED_KEY);
    }

    public String getGroupTapeReadBuffer() {
        if (!this.cr.getConfiguration().containsKey(GROUP_TAPE_READ_BUFFER_KEY)) {
            return "storm-SA-read";
        }
        return this.cr.getConfiguration().getString(GROUP_TAPE_READ_BUFFER_KEY);
    }

    public String getGroupTapeWriteBuffer() {
        if (!this.cr.getConfiguration().containsKey(GROUP_TAPE_WRITE_BUFFER_KEY)) {
            return "storm-SA-write";
        }
        return this.cr.getConfiguration().getString(GROUP_TAPE_WRITE_BUFFER_KEY);
    }

    public String getGRIDHTTPSPluginClassName() {
        if (!this.cr.getConfiguration().containsKey(GRIDHTTPS_PLUGIN_CLASSNAME_KEY)) {
            return "it.grid.storm.https.HTTPSPluginInterfaceStub";
        }
        return this.cr.getConfiguration().getString(GRIDHTTPS_PLUGIN_CLASSNAME_KEY);
    }

    public boolean getSynchronousQuotaCheckEnabled() {
        if (!this.cr.getConfiguration().containsKey(SYNCHRONOUS_QUOTA_CHECK_ENABLED_KEY)) {
            return false;
        }
        return this.cr.getConfiguration().getBoolean(SYNCHRONOUS_QUOTA_CHECK_ENABLED_KEY);
    }

    public int getGPFSQuotaRefreshPeriod() {
        if (!this.cr.getConfiguration().containsKey(GPFS_QUOTA_REFRESH_PERIOD_KEY)) {
            return 900;
        }
        return this.cr.getConfiguration().getInt(GPFS_QUOTA_REFRESH_PERIOD_KEY);
    }

    public boolean getFastBootstrapEnabled() {
        if (!this.cr.getConfiguration().containsKey(FAST_BOOTSTRAP_ENABLED_KEY)) {
            return true;
        }
        return this.cr.getConfiguration().getBoolean(FAST_BOOTSTRAP_ENABLED_KEY);
    }

    public Long getServerPoolStatusCheckTimeout() {
        if (!this.cr.getConfiguration().containsKey(SERVER_POOL_STATUS_CHECK_TIMEOUT_KEY)) {
            return new Long(20000L);
        }
        return new Long(this.cr.getConfiguration().getLong(SERVER_POOL_STATUS_CHECK_TIMEOUT_KEY));
    }

    public boolean getSanityCheckEnabled() {
        if (!this.cr.getConfiguration().containsKey(SANITY_CHECK_ENABLED_KEY)) {
            return true;
        }
        return new Boolean(this.cr.getConfiguration().getBoolean(SANITY_CHECK_ENABLED_KEY));
    }

    public String toString() {
        StringBuilder configurationStringBuilder = new StringBuilder();
        try {
            String value;
            Method[] methods = instance.getClass().getDeclaredMethods();
            Field[] fields = instance.getClass().getDeclaredFields();
            HashMap<String, String> methodKeyMap = new HashMap<String, String>();
            for (Field field : fields) {
                String fieldName = field.getName();
                if (!fieldName.endsWith("KEY") || !field.getType().equals(String.class)) continue;
                String mapKey = "get" + fieldName.substring(0, fieldName.lastIndexOf("_")).replaceAll("_", "").toLowerCase();
                if (methodKeyMap.containsKey(mapKey)) {
                    value = (String)methodKeyMap.get(mapKey);
                    methodKeyMap.put(mapKey, value + " , " + (String)field.get(instance));
                    continue;
                }
                methodKeyMap.put(mapKey, (String)field.get(instance));
            }
            Object field = null;
            Object[] dummyArray = new Object[]{};
            for (Method method : methods) {
                if (!method.getName().substring(0, 3).equals("get") || method.getName().equals("getInstance") || method.getModifiers() != 1) continue;
                field = method.invoke((Object)instance, dummyArray);
                if (field.getClass().isArray()) {
                    field = ArrayUtils.toString((Object)field);
                }
                if ((value = (String)methodKeyMap.get(method.getName().toLowerCase())) == null) {
                    configurationStringBuilder.insert(0, "!! Unable to find method " + method.getName() + " in methode key map!");
                } else {
                    configurationStringBuilder.append("Property " + value + " : ");
                }
                if (field.getClass().equals(String.class)) {
                    field = '\'' + (String)field + '\'';
                }
                configurationStringBuilder.append(method.getName() + "() == " + field.toString() + "\n");
            }
            return configurationStringBuilder.toString();
        }
        catch (Exception e) {
            if (e.getClass().isAssignableFrom(InvocationTargetException.class)) {
                configurationStringBuilder.insert(0, "!!! Cannot do toString! Got an Exception: " + e.getCause() + "\n");
            } else {
                configurationStringBuilder.insert(0, "!!! Cannot do toString! Got an Exception: " + e + "\n");
            }
            return configurationStringBuilder.toString();
        }
    }
}

