/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.config;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.reloading.FileChangedReloadingStrategy;
import org.apache.commons.configuration.reloading.ReloadingStrategy;

public class ConfigReader {
    private Configuration c = this.makeEmptyConfiguration();
    private String configurationPathname = "";
    private int refresh = 0;

    public ConfigReader() {
        this.makeEmptyConfiguration();
    }

    public ConfigReader(String configurationPathname, int refresh) {
        if (configurationPathname != null) {
            if (refresh < 0) {
                refresh = 0;
            }
            this.refresh = refresh;
            this.configurationPathname = configurationPathname;
            System.out.println("Reading configuration file " + configurationPathname + " and setting refresh rate to " + refresh + " seconds.");
            try {
                FileChangedReloadingStrategy strategy = new FileChangedReloadingStrategy();
                strategy.setRefreshDelay((long)refresh);
                PropertiesConfiguration properties = new PropertiesConfiguration(configurationPathname);
                System.out.println("Properties read from file:");
                Iterator i = properties.getKeys();
                while (i.hasNext()) {
                    String key = (String)i.next();
                    System.out.println(key + "=" + properties.getProperty(key).toString());
                }
                properties.setReloadingStrategy((ReloadingStrategy)strategy);
                this.c = new CompositeConfiguration();
                ((CompositeConfiguration)this.c).addConfiguration((Configuration)properties);
                System.out.println("Configuration file read. Full list of values in use follows; a copy has also been written to the logs.");
            }
            catch (ConfigurationException e) {
                this.c = this.makeEmptyConfiguration();
                System.out.println("************************************************************************");
                System.out.println("            ATTENTION! Reading of configuration file failed!");
                System.out.println("************************************************************************");
                System.out.println("Full list of values in use follows: please check it! A copy has also");
                System.out.println("been written to the logs.");
                System.err.println("************************************************************************");
                System.err.println("ATTENTION! Reading of configuration file " + configurationPathname + " failed! " + (Object)((Object)e));
                System.err.println("ATTENTION! Please check standard output or logs for exact configuration in use!");
                System.err.println("************************************************************************");
            }
        } else {
            System.err.println("WARNING!!! Null configuration pathname supplied: this could be a programming bug! Please check standard output or logs for exact configuration in use!");
        }
    }

    public Configuration getConfiguration() {
        return this.c;
    }

    public String configurationDirectory() {
        if (this.configurationPathname.equals("")) {
            return "";
        }
        int lastSlash = this.configurationPathname.lastIndexOf(File.separator);
        if (lastSlash == -1) {
            return "";
        }
        return this.configurationPathname.substring(0, lastSlash + 1);
    }

    private Configuration makeEmptyConfiguration() {
        return new AbstractConfiguration(){

            protected void addPropertyDirect(String key, Object obj) {
            }

            public void clearProperty(String key) {
            }

            public boolean containsKey(String key) {
                return false;
            }

            public Iterator getKeys() {
                return new ArrayList().iterator();
            }

            protected Object getPropertyDirect(String key) {
                return new Object();
            }

            public boolean isEmpty() {
                return true;
            }

            public Object getProperty(String key) {
                return new Object();
            }
        };
    }
}

