/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.common.types;

import java.io.Serializable;

public abstract class TimeUnit
implements Serializable {
    public static TimeUnit EMPTY = new TimeUnit(){

        @Override
        public double conversionFactor() {
            return -1.0;
        }

        public String toString() {
            return "none";
        }

        public int hashCode() {
            return -1;
        }
    };
    public static TimeUnit SECONDS = new TimeUnit(){

        @Override
        public double conversionFactor() {
            return 1.0;
        }

        public String toString() {
            return "seconds";
        }

        public int hashCode() {
            return 1;
        }
    };
    public static TimeUnit MINUTES = new TimeUnit(){

        @Override
        public double conversionFactor() {
            return 60.0;
        }

        public String toString() {
            return "minutes";
        }

        public int hashCode() {
            return 2;
        }
    };
    public static TimeUnit HOURS = new TimeUnit(){

        @Override
        public double conversionFactor() {
            return 3600.0;
        }

        public String toString() {
            return "hours";
        }

        public int hashCode() {
            return 3;
        }
    };
    public static TimeUnit DAYS = new TimeUnit(){

        @Override
        public double conversionFactor() {
            return 86400.0;
        }

        public String toString() {
            return "days";
        }

        public int hashCode() {
            return 4;
        }
    };
    public static TimeUnit WEEKS = new TimeUnit(){

        @Override
        public double conversionFactor() {
            return 604800.0;
        }

        public String toString() {
            return "weeks";
        }

        public int hashCode() {
            return 5;
        }
    };

    public static TimeUnit createTimeUnit(String unit) {
        String input = unit.toLowerCase();
        if (input.equals("seconds") || input.equals("sec")) {
            return SECONDS;
        }
        if (input.equals("minutes") || input.equals("min")) {
            return MINUTES;
        }
        if (input.equals("hours") || input.equals("h")) {
            return HOURS;
        }
        if (input.equals("days") || input.equals("d")) {
            return DAYS;
        }
        if (input.equals("weeks") || input.equals("week")) {
            return WEEKS;
        }
        return EMPTY;
    }

    private TimeUnit() {
    }

    public abstract double conversionFactor();
}

