/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.common.types;

import it.grid.storm.common.types.InvalidStFNAttributeException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public class StFN {
    private ArrayList<String> name = new ArrayList();
    private boolean directory = false;
    private boolean empty = true;
    public static final String PNAME_PATH = "path";

    private StFN(ArrayList<String> name, boolean empty, boolean dir) {
        this.name = name;
        this.empty = empty;
        this.directory = dir;
    }

    public static StFN makeEmpty() {
        return new StFN(new ArrayList<String>(), true, false);
    }

    public static StFN make(String name) throws InvalidStFNAttributeException {
        if (StFN.invalid(name)) {
            throw new InvalidStFNAttributeException(name);
        }
        return new StFN(StFN.normalize(name), false, StFN.checkDirectory(name));
    }

    private static boolean checkDirectory(String path) {
        if (path != null) {
            return path.endsWith("/");
        }
        return false;
    }

    private static boolean invalid(String name) {
        boolean wrong = name == null || name.equals("") || name.charAt(0) != '/';
        return wrong;
    }

    private static ArrayList<String> normalize(String s) {
        String[] pieces = s.split("/");
        ArrayList<String> auxList = new ArrayList<String>();
        int pos = 0;
        String aux = null;
        String[] arr$ = pieces;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String piece;
            aux = piece = arr$[i$];
            if ((aux = aux.trim()).equals("")) continue;
            auxList.add(pos++, aux);
        }
        return auxList;
    }

    public Collection<StFN> getParents() {
        ArrayList<StFN> aux = new ArrayList<StFN>();
        if (this.empty) {
            return aux;
        }
        int size = this.name.size();
        if (size == 0 || size == 1) {
            return aux;
        }
        for (int i = 1; i < size; ++i) {
            aux.add(new StFN(new ArrayList<String>(this.name.subList(0, i)), false, true));
        }
        return aux;
    }

    public StFN getParent() {
        if (this.empty) {
            return StFN.makeEmpty();
        }
        int size = this.name.size();
        if (size == 0 || size == 1) {
            return StFN.makeEmpty();
        }
        return new StFN(new ArrayList<String>(this.name.subList(0, size - 1)), false, true);
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public String getValue() {
        return this.toString();
    }

    public String toString() {
        if (this.empty) {
            return "Empty StFN";
        }
        int size = this.name.size();
        if (size == 0) {
            return "/";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("/");
        Iterator<String> i = this.name.iterator();
        while (i.hasNext()) {
            sb.append(i.next());
            if (!i.hasNext()) continue;
            sb.append("/");
        }
        if (this.directory) {
            sb.append("/");
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StFN)) {
            return false;
        }
        StFN po = (StFN)o;
        if (po.empty && this.empty) {
            return true;
        }
        if (!this.empty && !po.empty && this.name.size() == 0 && po.name.size() == 0) {
            return true;
        }
        return !this.empty && !po.empty && this.directory == po.directory && this.name.equals(po.name);
    }

    public int hashCode() {
        if (this.empty) {
            return 0;
        }
        int hash = 17;
        if (this.name.size() != 0) {
            hash = 31 * hash + this.name.hashCode();
        }
        hash = 31 * hash + (this.directory ? 1 : 0);
        return hash;
    }

    public void encode(Map<String, String> param, String name) {
        param.put(name, this.toString());
    }
}

