/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.common.types;

import java.io.Serializable;

public abstract class SizeUnit
implements Serializable {
    public static final SizeUnit BYTES = new SizeUnit(){

        @Override
        public double conversionFactor() {
            return 1.0;
        }

        public String toString() {
            return "Bytes";
        }

        public int hashCode() {
            return 1;
        }
    };
    public static final SizeUnit KILOBYTES = new SizeUnit(){

        @Override
        public double conversionFactor() {
            return 1000.0;
        }

        public String toString() {
            return "KB";
        }

        public int hashCode() {
            return 2;
        }
    };
    public static final SizeUnit MEGABYTES = new SizeUnit(){

        @Override
        public double conversionFactor() {
            return 1000000.0;
        }

        public String toString() {
            return "MB";
        }

        public int hashCode() {
            return 3;
        }
    };
    public static final SizeUnit GIGABYTES = new SizeUnit(){

        @Override
        public double conversionFactor() {
            return MEGABYTES.conversionFactor() * 1000.0;
        }

        public String toString() {
            return "GB";
        }

        public int hashCode() {
            return 4;
        }
    };
    public static final SizeUnit TERABYTES = new SizeUnit(){

        @Override
        public double conversionFactor() {
            return GIGABYTES.conversionFactor() * 1000.0;
        }

        public String toString() {
            return "TB";
        }

        public int hashCode() {
            return 5;
        }
    };
    public static final SizeUnit EMPTY = new SizeUnit(){

        @Override
        public double conversionFactor() {
            return 0.0;
        }

        public String toString() {
            return "EMPTY";
        }

        public int hashCode() {
            return 0;
        }
    };

    public static SizeUnit createSizeUnit(String unit) {
        String input = unit.toLowerCase();
        if (input.toLowerCase().equals("byte")) {
            return BYTES;
        }
        if (input.toLowerCase().equals("kb")) {
            return KILOBYTES;
        }
        if (input.toLowerCase().equals("mb")) {
            return MEGABYTES;
        }
        if (input.toLowerCase().equals("gb")) {
            return GIGABYTES;
        }
        if (input.toLowerCase().equals("tb")) {
            return TERABYTES;
        }
        return EMPTY;
    }

    private SizeUnit() {
    }

    public abstract double conversionFactor();
}

