/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.common.types;

import it.grid.storm.common.types.InvalidPortAttributeException;

public class Port {
    private int port;
    private boolean empty = true;

    private Port(int port, boolean empty) {
        this.port = port;
        this.empty = empty;
    }

    public static Port makeEmpty() {
        return new Port(-1, true);
    }

    public static Port make(int port) throws InvalidPortAttributeException {
        if (port < 0 || port > 65535) {
            throw new InvalidPortAttributeException(port);
        }
        return new Port(port, false);
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public int toInt() {
        if (this.empty) {
            return -1;
        }
        return this.port;
    }

    public int getValue() {
        return this.port;
    }

    public String toString() {
        if (this.empty) {
            return "Empty Port";
        }
        return "" + this.port;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Port)) {
            return false;
        }
        Port po = (Port)o;
        if (po.empty && this.empty) {
            return true;
        }
        return !po.empty && !this.empty && this.port == po.port;
    }

    public int hashCode() {
        if (this.empty) {
            return -1;
        }
        int hash = 17;
        return 37 * hash + this.port;
    }
}

