/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.common.types;

import it.grid.storm.common.types.InvalidEndPointAttributeException;
import java.util.ArrayList;
import java.util.Iterator;

public class EndPoint {
    private ArrayList name = new ArrayList();
    private boolean empty = true;
    private boolean directory = false;

    private EndPoint(ArrayList name, boolean empty) {
        this.name = name;
        this.empty = empty;
    }

    public static EndPoint makeEmpty() {
        return new EndPoint(new ArrayList(), true);
    }

    public static EndPoint make(String name) throws InvalidEndPointAttributeException {
        if (EndPoint.invalid(name)) {
            throw new InvalidEndPointAttributeException(name);
        }
        return new EndPoint(EndPoint.normalize(name), false);
    }

    private static boolean invalid(String name) {
        boolean wrong = name == null || name.equals("") || name.charAt(0) != '/';
        return wrong;
    }

    private static ArrayList normalize(String s) {
        String[] pieces = s.split("/");
        ArrayList<String> auxList = new ArrayList<String>();
        int pos = 0;
        String aux = null;
        for (int k = 0; k < pieces.length; ++k) {
            aux = pieces[k];
            if ((aux = aux.trim()).equals("")) continue;
            auxList.add(pos++, aux);
        }
        return auxList;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public String toString() {
        if (this.empty) {
            return "Empty EndPoint";
        }
        int size = this.name.size();
        if (size == 0) {
            return "/";
        }
        StringBuffer sb = new StringBuffer();
        Iterator i = this.name.iterator();
        while (i.hasNext()) {
            sb.append("/");
            sb.append(i.next());
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EndPoint)) {
            return false;
        }
        EndPoint po = (EndPoint)o;
        if (po.empty && this.empty) {
            return true;
        }
        if (!this.empty && !po.empty && this.name.size() == 0 && po.name.size() == 0) {
            return true;
        }
        return !this.empty && !po.empty && this.name.equals(po.name);
    }

    public int hashCode() {
        if (this.empty) {
            return 0;
        }
        int hash = 17;
        if (this.name.size() == 0) {
            return hash;
        }
        return 37 * hash + this.name.hashCode();
    }
}

