/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.checksum;

import it.grid.storm.config.Configuration;
import it.grid.storm.ea.ExtendedAttributesException;
import it.grid.storm.ea.FileNotFoundException;
import it.grid.storm.ea.NotSupportedException;
import it.grid.storm.ea.StormEA;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChecksumManager {
    private static final Logger log = LoggerFactory.getLogger(ChecksumManager.class);
    private static volatile ChecksumManager instance = null;
    private String defaultAlgorithm = Configuration.getInstance().getChecksumAlgorithm().toLowerCase();

    private ChecksumManager() {
    }

    public static synchronized ChecksumManager getInstance() {
        if (instance == null) {
            instance = new ChecksumManager();
        }
        return instance;
    }

    public String getDefaultAlgorithm() {
        return this.defaultAlgorithm;
    }

    public String getDefaultChecksum(String fileName) throws FileNotFoundException {
        log.debug("Requesting checksum for file: " + fileName);
        String checksum = null;
        try {
            checksum = StormEA.getChecksum(fileName, this.defaultAlgorithm);
        }
        catch (NotSupportedException e) {
            log.warn("Cannot retrieve checksum EA for default algorithm " + this.defaultAlgorithm + " (operation not supported) from file: " + fileName + " NotSupportedException: " + e.getMessage());
        }
        catch (ExtendedAttributesException e) {
            if (e instanceof FileNotFoundException) {
                throw (FileNotFoundException)e;
            }
            log.warn("Error manipulating EA for default algorithm " + this.defaultAlgorithm + " on file: " + fileName + " ExtendedAttributesException: " + e.getMessage());
        }
        return checksum;
    }

    public boolean hasChecksum(String fileName) throws FileNotFoundException {
        String value = null;
        try {
            value = StormEA.getChecksum(fileName, this.defaultAlgorithm);
        }
        catch (NotSupportedException e) {
            log.warn("Cannot retrieve checksum EA for default algorithm " + this.defaultAlgorithm + " (operation not supported) from file: " + fileName + " NotSupportedException: " + e.getMessage());
        }
        catch (ExtendedAttributesException e) {
            if (e instanceof FileNotFoundException) {
                throw (FileNotFoundException)e;
            }
            log.warn("Error manipulating EA for default algorithm " + this.defaultAlgorithm + " on file: " + fileName + " ExtendedAttributesException: " + e.getMessage());
        }
        return value != null;
    }

    public Map<String, String> getChecksums(String fileName) throws FileNotFoundException {
        return StormEA.getChecksums(fileName);
    }
}

