/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.check.sanity.filesystem;

import it.grid.storm.check.Check;
import it.grid.storm.check.CheckResponse;
import it.grid.storm.check.CheckStatus;
import it.grid.storm.check.GenericCheckException;
import it.grid.storm.ea.ExtendedAttributes;
import it.grid.storm.ea.ExtendedAttributesException;
import it.grid.storm.jna.ExtendedAttributesImpl;
import it.grid.storm.namespace.NamespaceDirector;
import it.grid.storm.namespace.NamespaceException;
import it.grid.storm.namespace.VirtualFSInterface;
import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamespaceFSExtendedAttributeUsageCheck
implements Check {
    private static final Logger log = LoggerFactory.getLogger(NamespaceFSExtendedAttributeUsageCheck.class);
    private static final String CHECK_NAME = "NamespaceFSEATest";
    private static final String CHECK_DESCRIPTION = "This check tries to use file system extended attributes on all the file systems declared in namespace.xml";
    private static final int MAX_FILE_CREATION_ATTEMPTS = 10;
    private static final String TEST_FILE_INFIX = "EA-check-file-N_";
    private static final String CHECK_ATTRIBUTE_NAME = "user.Are.you.a.check";
    private static final String CHECK_ATTRIBUTE_VALUE = "Yes.I.am";
    private final ExtendedAttributes extendedAttribute = new ExtendedAttributesImpl();
    private static final boolean criticalCheck = true;

    @Override
    public CheckResponse execute() throws GenericCheckException {
        CheckStatus status = CheckStatus.SUCCESS;
        String errorMessage = "";
        try {
            for (VirtualFSInterface vfs : NamespaceDirector.getNamespace().getAllDefinedVFS()) {
                File checkFile;
                String fsRootPath = vfs.getRootPath().trim();
                if (fsRootPath.charAt(fsRootPath.length() - 1) != File.separatorChar) {
                    fsRootPath = fsRootPath + File.separatorChar;
                }
                try {
                    checkFile = this.provideCheckFile(fsRootPath, TEST_FILE_INFIX);
                }
                catch (GenericCheckException e) {
                    log.warn("Unable to obtain a check temporary file. GenericCheckException : " + e.getMessage());
                    errorMessage = errorMessage + "Unable to obtain a check temporary file. GenericCheckException : " + e.getMessage() + "; ";
                    status = CheckStatus.INDETERMINATE;
                    continue;
                }
                boolean currentResponse = this.checkEA(checkFile);
                if (!currentResponse) {
                    log.warn("Check on VFS " + vfs.getAliasName() + " to add EA on file " + checkFile.getAbsolutePath() + " failed. File System type =" + vfs.getFSType() + " , root path =" + fsRootPath);
                    errorMessage = errorMessage + "Check on VFS " + vfs.getAliasName() + " to add EA on file " + checkFile.getAbsolutePath() + " failed. File System type =" + vfs.getFSType() + " , root path =" + fsRootPath + "; ";
                }
                log.debug("Check response for path " + fsRootPath + " is " + (currentResponse ? "success" : "failure"));
                status = CheckStatus.and(status, currentResponse);
                log.debug("Partial result is " + status.toString());
                if (checkFile.delete()) continue;
                log.warn("Unable to delete the temporary file used for the check " + checkFile.getAbsolutePath());
            }
        }
        catch (NamespaceException e) {
            log.warn("Unable to proceede. NamespaceException : " + e.getMessage());
            errorMessage = errorMessage + "Unable to proceede. NamespaceException : " + e.getMessage() + "; ";
            status = CheckStatus.INDETERMINATE;
        }
        return new CheckResponse(status, errorMessage);
    }

    private File provideCheckFile(String rootPath, String infix) throws GenericCheckException {
        boolean fileAvailable = false;
        File checkFile = null;
        for (int attempCount = 1; attempCount <= 10 && !fileAvailable; ++attempCount) {
            checkFile = new File(rootPath + infix + attempCount + "-" + Calendar.getInstance().getTimeInMillis());
            if (checkFile.exists()) {
                if (checkFile.isFile()) {
                    fileAvailable = true;
                    log.debug("A good check temporary file already exists at " + checkFile.getAbsolutePath());
                    continue;
                }
                log.warn("Unable to create check file, it already exists but is not a simple file : " + checkFile.getAbsolutePath());
                continue;
            }
            try {
                fileAvailable = checkFile.createNewFile();
                if (!fileAvailable) continue;
                log.debug("Created check temporary file at " + checkFile.getAbsolutePath());
                continue;
            }
            catch (IOException e) {
                log.warn("Unable to create the check file : " + checkFile.getAbsolutePath() + ". IOException: " + e.getMessage());
            }
        }
        if (!fileAvailable) {
            log.warn("Unable to create check file, reaced maximum iterations at path : " + checkFile.getAbsolutePath());
            throw new GenericCheckException("Unable to create the check file for root path '" + rootPath + "'");
        }
        return checkFile;
    }

    private boolean checkEA(File file) {
        boolean response = false;
        log.debug("Testing extended attribute management on file " + file.getAbsolutePath());
        try {
            log.debug("Trying to set the extended attribute user.Are.you.a.check to value Yes.I.am on file " + file.getAbsolutePath());
            this.extendedAttribute.setXAttr(file.getAbsolutePath(), CHECK_ATTRIBUTE_NAME, CHECK_ATTRIBUTE_VALUE.getBytes());
            log.debug("Trying to get the extended attribute user.Are.you.a.check from file " + file.getAbsolutePath());
            String value = new String(this.extendedAttribute.getXAttr(file.getAbsolutePath(), CHECK_ATTRIBUTE_NAME));
            log.debug("Returned value is '" + value + "'");
            log.debug("Trying to remove the extended attribute user.Are.you.a.check from file " + file.getAbsolutePath());
            this.extendedAttribute.rmXAttr(file.getAbsolutePath(), CHECK_ATTRIBUTE_NAME);
            if (!CHECK_ATTRIBUTE_VALUE.equals(value)) {
                log.warn("Undesired behaviour! The returned extended attribute value '" + value + "' differs from the one setted '" + CHECK_ATTRIBUTE_VALUE + "'");
            } else {
                response = true;
            }
        }
        catch (ExtendedAttributesException e) {
            log.warn("Unable to manage extended attributes on file " + file.getAbsolutePath() + " ExtendedAttributesException : " + e.getMessage());
        }
        return response;
    }

    @Override
    public String getName() {
        return CHECK_NAME;
    }

    @Override
    public String getDescription() {
        return CHECK_DESCRIPTION;
    }

    @Override
    public boolean isCritical() {
        return true;
    }
}

