/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.check.sanity.filesystem;

import it.grid.storm.check.Check;
import it.grid.storm.check.CheckResponse;
import it.grid.storm.check.CheckStatus;
import it.grid.storm.check.GenericCheckException;
import it.grid.storm.filesystem.Filesystem;
import it.grid.storm.filesystem.FilesystemPermission;
import it.grid.storm.griduser.CannotMapUserException;
import it.grid.storm.griduser.DistinguishedName;
import it.grid.storm.griduser.GridUserInterface;
import it.grid.storm.griduser.LocalUser;
import it.grid.storm.namespace.NamespaceDirector;
import it.grid.storm.namespace.NamespaceException;
import it.grid.storm.namespace.VirtualFSInterface;
import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamespaceFSExtendedACLUsageCheck
implements Check {
    private static final Logger log = LoggerFactory.getLogger(NamespaceFSExtendedACLUsageCheck.class);
    private static final String CHECK_NAME = "NamespaceFSEACLTest";
    private static final String CHECK_DESCRIPTION = "This check tries to use file system extended ACL on all the file systems declared in namespace.xml";
    private static final int MAX_FILE_CREATION_ATTEMPTS = 10;
    private static final GridUserInterface TEST_USER = new FakeGridUser("/C=IT/O=INFN/L=CNAF/CN=Fake User");
    private static LocalUser TEST_LOCAL_USER = null;
    private static final FilesystemPermission TEST_PERMISSION = FilesystemPermission.ListTraverseWrite;
    private static final String TEST_FILE_INFIX = "ACL-check-file-N_";
    private static final boolean criticalCheck = true;

    @Override
    public CheckResponse execute() throws GenericCheckException {
        CheckStatus status = CheckStatus.SUCCESS;
        String errorMessage = "";
        try {
            TEST_LOCAL_USER = TEST_USER.getLocalUser();
        }
        catch (CannotMapUserException e) {
            log.warn("Unable to obtain local user for test user " + TEST_USER);
            throw new GenericCheckException("Unable to obtain local user for test user " + TEST_USER);
        }
        try {
            for (VirtualFSInterface vfs : NamespaceDirector.getNamespace().getAllDefinedVFS()) {
                File checkFile;
                String fsRootPath = vfs.getRootPath().trim();
                if (fsRootPath.charAt(fsRootPath.length() - 1) != File.separatorChar) {
                    fsRootPath = fsRootPath + File.separatorChar;
                }
                try {
                    checkFile = this.provideCheckFile(fsRootPath, TEST_FILE_INFIX);
                }
                catch (GenericCheckException e) {
                    log.warn("Unable to obtain a check temporary file. GenericCheckException : " + e.getMessage());
                    errorMessage = errorMessage + "Unable to obtain a check temporary file. GenericCheckException : " + e.getMessage() + "; ";
                    status = CheckStatus.INDETERMINATE;
                    continue;
                }
                Filesystem filesystem = vfs.getFilesystem();
                boolean currentResponse = this.checkEACL(checkFile, filesystem);
                if (!currentResponse) {
                    log.error("Check on VFS " + vfs.getAliasName() + " to add an extended ACL on file " + checkFile.getAbsolutePath() + " failed. File System type =" + vfs.getFSType() + " , root path =" + fsRootPath);
                    errorMessage = errorMessage + "Check on VFS " + vfs.getAliasName() + " to add an extended ACL on file " + checkFile.getAbsolutePath() + " failed. File System type =" + vfs.getFSType() + " , root path =" + fsRootPath + "; ";
                }
                log.debug("Check response for path " + fsRootPath + " is " + (currentResponse ? "success" : "failure"));
                status = CheckStatus.and(status, currentResponse);
                log.debug("Partial result is " + status.toString());
                if (checkFile.delete()) continue;
                log.warn("Unable to delete the temporary file used for the check " + checkFile.getAbsolutePath());
            }
        }
        catch (NamespaceException e) {
            log.warn("Unable to proceede. NamespaceException : " + e.getMessage());
            errorMessage = errorMessage + "Unable to proceede. NamespaceException : " + e.getMessage() + "; ";
            status = CheckStatus.INDETERMINATE;
        }
        return new CheckResponse(status, errorMessage);
    }

    private File provideCheckFile(String rootPath, String infix) throws GenericCheckException {
        boolean fileAvailable = false;
        File checkFile = null;
        for (int attempCount = 1; attempCount <= 10 && !fileAvailable; ++attempCount) {
            checkFile = new File(rootPath + infix + attempCount + "-" + Calendar.getInstance().getTimeInMillis());
            if (checkFile.exists()) {
                if (checkFile.isFile()) {
                    fileAvailable = true;
                    log.debug("A good check temporary file already exists at " + checkFile.getAbsolutePath());
                    continue;
                }
                log.warn("Unable to create check file, it already exists but is not a simple file : " + checkFile.getAbsolutePath());
                continue;
            }
            try {
                fileAvailable = checkFile.createNewFile();
                if (!fileAvailable) continue;
                log.debug("Created check temporary file at " + checkFile.getAbsolutePath());
                continue;
            }
            catch (IOException e) {
                log.warn("Unable to create the check file : " + checkFile.getAbsolutePath() + ". IOException: " + e.getMessage());
            }
        }
        if (!fileAvailable) {
            log.warn("Unable to create check file, reaced maximum iterations at path : " + checkFile.getAbsolutePath());
            throw new GenericCheckException("Unable to create the check file for root path '" + rootPath + "'");
        }
        return checkFile;
    }

    private boolean checkEACL(File file, Filesystem filesystem) {
        boolean response = true;
        log.debug("Testing extended attribute management on file " + file.getAbsolutePath());
        FilesystemPermission oldPermisssion = filesystem.getGroupPermission(TEST_LOCAL_USER, file.getAbsolutePath());
        if (oldPermisssion == null) {
            oldPermisssion = FilesystemPermission.None;
        }
        FilesystemPermission testPermission = TEST_PERMISSION.deny(oldPermisssion);
        log.debug("Trying to set the extended ACL " + testPermission + " to group " + TEST_LOCAL_USER.getPrimaryGid() + " on file " + file.getAbsolutePath());
        filesystem.grantGroupPermission(TEST_LOCAL_USER, file.getAbsolutePath(), testPermission);
        log.debug("Original group permission : " + oldPermisssion);
        log.debug("Trying to get the extended ACL  of group " + TEST_LOCAL_USER.getPrimaryGid() + " from file " + file.getAbsolutePath());
        FilesystemPermission currentPermission = filesystem.getGroupPermission(TEST_LOCAL_USER, file.getAbsolutePath());
        if (currentPermission == null) {
            currentPermission = FilesystemPermission.None;
        }
        log.debug("Returned value is '" + currentPermission + "'");
        log.debug("Trying to remove the extended group ACL " + testPermission + " from file " + file.getAbsolutePath());
        FilesystemPermission previousPermission = filesystem.revokeGroupPermission(TEST_LOCAL_USER, file.getAbsolutePath(), testPermission);
        if (previousPermission == null) {
            previousPermission = FilesystemPermission.None;
        }
        log.debug("Revoked group permission is : " + previousPermission);
        if (currentPermission.getInt() != previousPermission.getInt()) {
            log.warn("Undesired behaviour! The revoked extended group ACL value '" + previousPermission + "' differs from the one setted '" + currentPermission + "'");
            response &= false;
        } else {
            response &= true;
        }
        currentPermission = filesystem.getGroupPermission(TEST_LOCAL_USER, file.getAbsolutePath());
        if (currentPermission == null) {
            currentPermission = FilesystemPermission.None;
        }
        log.debug("Final group permission is : " + currentPermission);
        if (currentPermission.getInt() != oldPermisssion.getInt()) {
            log.warn("Undesired behaviour! The final extended group ACL value '" + currentPermission + "' differs from the original '" + oldPermisssion + "'");
            response &= false;
        } else {
            response &= true;
        }
        oldPermisssion = filesystem.getUserPermission(TEST_LOCAL_USER, file.getAbsolutePath());
        if (oldPermisssion == null) {
            oldPermisssion = FilesystemPermission.None;
        }
        testPermission = TEST_PERMISSION.deny(oldPermisssion);
        log.debug("Trying to set the extended ACL " + testPermission + " to user " + TEST_LOCAL_USER.getUid() + " on file " + file.getAbsolutePath());
        filesystem.grantUserPermission(TEST_LOCAL_USER, file.getAbsolutePath(), testPermission);
        log.debug("Original user permission : " + oldPermisssion);
        log.debug("Trying to get the extended ACL  of user " + TEST_LOCAL_USER.getUid() + " from file " + file.getAbsolutePath());
        currentPermission = filesystem.getUserPermission(TEST_LOCAL_USER, file.getAbsolutePath());
        if (currentPermission == null) {
            currentPermission = FilesystemPermission.None;
        }
        log.debug("Returned value is '" + currentPermission + "'");
        log.debug("Trying to remove the extended user ACL " + testPermission + " from file " + file.getAbsolutePath());
        previousPermission = filesystem.revokeUserPermission(TEST_LOCAL_USER, file.getAbsolutePath(), testPermission);
        if (previousPermission == null) {
            previousPermission = FilesystemPermission.None;
        }
        log.debug("Revoked user permission is : " + previousPermission);
        if (currentPermission.getInt() != previousPermission.getInt()) {
            log.warn("Undesired behaviour! The removed extended user ACL value '" + previousPermission + "' differs from the one setted '" + currentPermission + "'");
            response &= false;
        } else {
            response &= true;
        }
        currentPermission = filesystem.getUserPermission(TEST_LOCAL_USER, file.getAbsolutePath());
        if (currentPermission == null) {
            currentPermission = FilesystemPermission.None;
        }
        log.debug("Final user permission is : " + currentPermission);
        if (currentPermission.getInt() != oldPermisssion.getInt()) {
            log.warn("Undesired behaviour! The final extended user ACL value '" + currentPermission + "' differs from the original '" + oldPermisssion + "'");
            response &= false;
        } else {
            response &= true;
        }
        return response;
    }

    @Override
    public String getName() {
        return CHECK_NAME;
    }

    @Override
    public String getDescription() {
        return CHECK_DESCRIPTION;
    }

    @Override
    public boolean isCritical() {
        return true;
    }

    private static class FakeGridUser
    implements GridUserInterface {
        private DistinguishedName dn;

        public FakeGridUser(String dn) {
            this.setDN(dn);
        }

        private void setDN(String dnString) {
            this.dn = new DistinguishedName(dnString);
        }

        @Override
        public String getDn() {
            return this.dn.toString();
        }

        @Override
        public LocalUser getLocalUser() throws CannotMapUserException {
            return new LocalUser(0, 0);
        }

        @Override
        public DistinguishedName getDistinguishedName() {
            return this.dn;
        }

        public String toString() {
            return "Fake Grid User (no VOMS): '" + this.getDistinguishedName().getX500DN_rfc1779() + "'";
        }
    }
}

