/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.check;

import it.grid.storm.check.Check;
import it.grid.storm.check.CheckManager;
import it.grid.storm.check.sanity.filesystem.NamespaceFSAssociationCheck;
import it.grid.storm.check.sanity.filesystem.NamespaceFSExtendedACLUsageCheck;
import it.grid.storm.check.sanity.filesystem.NamespaceFSExtendedAttributeUsageCheck;
import it.grid.storm.filesystem.MtabUtil;
import it.grid.storm.namespace.NamespaceDirector;
import it.grid.storm.namespace.NamespaceException;
import it.grid.storm.namespace.VirtualFSInterface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleCheckManager
extends CheckManager {
    private static final Logger log = LoggerFactory.getLogger(SimpleCheckManager.class);
    private ArrayList<Check> checks = new ArrayList();

    @Override
    protected Logger getLogger() {
        return log;
    }

    @Override
    protected void loadChecks() {
        try {
            this.checks.add(this.getNamespaceFSAssociationCheck());
        }
        catch (IllegalStateException e) {
            log.warn("Skipping NamespaceFSAssociationCheck. IllegalStateException: " + e.getMessage());
        }
        this.checks.add(new NamespaceFSExtendedAttributeUsageCheck());
        this.checks.add(new NamespaceFSExtendedACLUsageCheck());
    }

    private Check getNamespaceFSAssociationCheck() throws IllegalStateException {
        Collection<VirtualFSInterface> vfsSet;
        Map<String, String> mountPoints;
        try {
            mountPoints = MtabUtil.getFSMountPoints();
        }
        catch (Exception e) {
            log.error("Unable to get filesystem mount points. Exception: " + e.getMessage());
            throw new IllegalStateException("Unable to get filesystem mount points");
        }
        log.debug("Retrieved MountPoints: " + this.printMapCoupples(mountPoints));
        try {
            vfsSet = NamespaceDirector.getNamespace().getAllDefinedVFS();
        }
        catch (NamespaceException e) {
            log.error("Unexpected NamespaceException during vfsSet retriving " + e.getMessage() + " . Unable to add NamespaceFSAssociationCheck");
            throw new IllegalStateException("Unexpected NamespaceException from getAllDefinedVFS");
        }
        return new NamespaceFSAssociationCheck(mountPoints, vfsSet);
    }

    private String printMapCoupples(Map<String, String> map) {
        String output = "";
        for (Map.Entry<String, String> couple : map.entrySet()) {
            if (output.trim().length() != 0) {
                output = output + " ; ";
            }
            output = output + "<" + couple.getKey() + "," + couple.getValue() + ">";
        }
        return output;
    }

    @Override
    protected List<Check> prepareSchedule() {
        return this.checks;
    }
}

