/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.catalogs;

import it.grid.storm.catalogs.JiTData;
import it.grid.storm.config.Configuration;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VolatileAndJiTDAO {
    private static final Logger log = LoggerFactory.getLogger(VolatileAndJiTDAO.class);
    private final String driver = Configuration.getInstance().getDBDriver();
    private final String url = Configuration.getInstance().getDBURL();
    private final String password = Configuration.getInstance().getDBPassword();
    private final String name = Configuration.getInstance().getDBUserName();
    private Connection con = null;
    private static final VolatileAndJiTDAO dao = new VolatileAndJiTDAO();
    private Timer clock = null;
    private TimerTask clockTask = null;
    private final long period = Configuration.getInstance().getDBReconnectPeriod() * 1000L;
    private final long delay = Configuration.getInstance().getDBReconnectDelay() * 1000L;
    private boolean reconnect = false;

    private VolatileAndJiTDAO() {
        this.setUpConnection();
        this.clock = new Timer();
        this.clockTask = new TimerTask(){

            @Override
            public void run() {
                VolatileAndJiTDAO.this.reconnect = true;
            }
        };
        this.clock.scheduleAtFixedRate(this.clockTask, this.delay, this.period);
    }

    public static VolatileAndJiTDAO getInstance() {
        return dao;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJiT(String filename, int uid, int gid, int acl, long start, long pinLifetime) {
        if (!this.checkConnection()) {
            log.error("VolatileAndJiTDAO. addJiT:  unable to get a valid connection!");
            return;
        }
        String sql = "INSERT INTO jit(file,uid,gid,acl,start,pinLifetime) VALUES(?,?,?,?,FROM_UNIXTIME(?),?)";
        PreparedStatement stmt = null;
        try {
            stmt = this.con.prepareStatement(sql);
            this.logWarnings(this.con.getWarnings());
            stmt.setString(1, filename);
            this.logWarnings(stmt.getWarnings());
            stmt.setInt(2, uid);
            this.logWarnings(stmt.getWarnings());
            stmt.setInt(3, gid);
            this.logWarnings(stmt.getWarnings());
            stmt.setInt(4, acl);
            this.logWarnings(stmt.getWarnings());
            stmt.setLong(5, start);
            this.logWarnings(stmt.getWarnings());
            stmt.setLong(6, pinLifetime);
            this.logWarnings(stmt.getWarnings());
            log.debug("VolatileAndJiTDAO. addJiT: " + stmt.toString());
            stmt.execute();
        }
        catch (SQLException e) {
            log.error("VolatileAndJiTDAO! Error in addJiT: " + e);
        }
        finally {
            this.close(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVolatile(String filename, long start, long fileLifetime) {
        if (!this.checkConnection()) {
            log.error("VolatileAndJiTDAO. addVolatile:  unable to get a valid connection!");
            return;
        }
        String sql = "INSERT INTO volatile(file,start,fileLifetime) VALUES(?,FROM_UNIXTIME(?),?)";
        PreparedStatement stmt = null;
        try {
            stmt = this.con.prepareStatement(sql);
            this.logWarnings(this.con.getWarnings());
            stmt.setString(1, filename);
            this.logWarnings(stmt.getWarnings());
            stmt.setLong(2, start);
            this.logWarnings(stmt.getWarnings());
            stmt.setLong(3, fileLifetime);
            this.logWarnings(stmt.getWarnings());
            log.debug("VolatileAndJiTDAO. addVolatile: " + stmt.toString());
            stmt.execute();
        }
        catch (SQLException e) {
            log.error("VolatileAndJiTDAO! Error in addVolatile: " + e);
        }
        finally {
            this.close(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(String filename) {
        boolean result;
        if (!this.checkConnection()) {
            log.error("VolatileAndJiTDAO. exists:  unable to get a valid connection!");
            return false;
        }
        String sql = "SELECT ID FROM volatile WHERE file=? LIMIT 1";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.con.prepareStatement(sql);
            this.logWarnings(this.con.getWarnings());
            stmt.setString(1, filename);
            this.logWarnings(stmt.getWarnings());
            log.debug("VolatileAndJiTDAO - existsOnVolatile - " + stmt.toString());
            rs = stmt.executeQuery();
            this.logWarnings(stmt.getWarnings());
            result = rs.next();
            this.close(rs);
            this.close(stmt);
        }
        catch (SQLException e) {
            log.error("VolatileAndJiTDAO! Error in existsOnVolatile: ", (Throwable)e);
            result = false;
        }
        finally {
            this.close(rs);
            this.close(stmt);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceUpdateJiT(String filename, int uid, int acl, long start, long pinLifetime) {
        if (!this.checkConnection()) {
            log.error("VolatileAndJiTDAO. forceUpdateJiT:  unable to get a valid connection!");
            return;
        }
        String sql = "UPDATE jit SET start=FROM_UNIXTIME(?), pinLifetime=? WHERE file=? AND uid=? AND acl=?";
        PreparedStatement stmt = null;
        try {
            stmt = this.con.prepareStatement(sql);
            this.logWarnings(this.con.getWarnings());
            stmt.setLong(1, start);
            this.logWarnings(stmt.getWarnings());
            stmt.setLong(2, pinLifetime);
            this.logWarnings(stmt.getWarnings());
            stmt.setString(3, filename);
            this.logWarnings(stmt.getWarnings());
            stmt.setInt(4, uid);
            this.logWarnings(stmt.getWarnings());
            stmt.setInt(5, acl);
            this.logWarnings(stmt.getWarnings());
            log.debug("VolatileAndJiTDAO. forceUpdateJiT: " + stmt.toString());
            int n = stmt.executeUpdate();
            log.debug("VolatileAndJiTDAO. " + n + " jit entries forced updated.");
        }
        catch (SQLException e) {
            log.error("VolatileAndJiTDAO! Error in forceUpdateJiT: " + e);
        }
        finally {
            this.close(stmt);
        }
    }

    public int numberJiT(String filename, int uid, int acl) {
        if (!this.checkConnection()) {
            log.error("VolatileAndJiTDAO. numberJiT:  unable to get a valid connection!");
            return -1;
        }
        String sql = "SELECT COUNT(ID) FROM jit WHERE file=? AND uid=? AND acl=?";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.con.prepareStatement(sql);
            this.logWarnings(this.con.getWarnings());
            stmt.setString(1, filename);
            this.logWarnings(stmt.getWarnings());
            stmt.setInt(2, uid);
            this.logWarnings(stmt.getWarnings());
            stmt.setInt(3, acl);
            this.logWarnings(stmt.getWarnings());
            log.debug("VolatileAndJiTDAO. numberJiT: " + stmt.toString());
            rs = stmt.executeQuery();
            this.logWarnings(stmt.getWarnings());
            int n = -1;
            if (rs.next()) {
                n = rs.getInt(1);
            } else {
                log.error("VolatileAndJiTDAO! Unexpected situation in numberJiT: result set empty!");
            }
            this.close(rs);
            this.close(stmt);
            return n;
        }
        catch (SQLException e) {
            log.error("VolatileAndJiTDAO! Error in numberJiT: " + e);
            this.close(rs);
            this.close(stmt);
            return -1;
        }
    }

    public int numberVolatile(String filename) {
        if (!this.checkConnection()) {
            log.error("VolatileAndJiTDAO. numberVolatile:  unable to get a valid connection!");
            return -1;
        }
        String sql = "SELECT COUNT(ID) FROM volatile WHERE file=?";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.con.prepareStatement(sql);
            this.logWarnings(this.con.getWarnings());
            stmt.setString(1, filename);
            this.logWarnings(stmt.getWarnings());
            log.debug("VolatileAndJiTDAO. numberVolatile: " + stmt.toString());
            rs = stmt.executeQuery();
            this.logWarnings(stmt.getWarnings());
            int n = -1;
            if (rs.next()) {
                n = rs.getInt(1);
            } else {
                log.error("VolatileAndJiTDAO! Unexpected situation in numberVolatile: result set empty!");
            }
            this.close(rs);
            this.close(stmt);
            return n;
        }
        catch (SQLException e) {
            log.error("VolatileAndJiTDAO! Error in numberVolatile: " + e);
            this.close(rs);
            this.close(stmt);
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllJiTsOn(String filename) {
        if (!this.checkConnection()) {
            log.error("VolatileAndJiTDAO. removeAllJiTsOn:  unable to get a valid connection!");
            return;
        }
        String sql = "DELETE FROM jit WHERE file=?";
        PreparedStatement stmt = null;
        try {
            stmt = this.con.prepareStatement(sql);
            this.logWarnings(this.con.getWarnings());
            stmt.setString(1, filename);
            this.logWarnings(stmt.getWarnings());
            log.debug("VolatileAndJiTDAO. removeJiT: " + stmt.toString());
            int n = stmt.executeUpdate();
            log.debug("VolatileAndJiTDAO. removeJiT: " + n + " entries removed");
        }
        catch (SQLException e) {
            log.error("VolatileAndJiTDAO! Error in removeJiT: " + e);
        }
        finally {
            this.close(stmt);
        }
    }

    public Collection[] removeExpired(long time) {
        if (!this.checkConnection()) {
            log.error("VolatileAndJiTDAO. removeExpired:  unable to get a valid connection!");
            return new Collection[]{new ArrayList(), new ArrayList()};
        }
        String vol = "SELECT ID,file FROM volatile WHERE (UNIX_TIMESTAMP(start)+fileLifetime<?)";
        String jit = "SELECT ID,file,acl,uid,gid FROM jit WHERE (UNIX_TIMESTAMP(start)+pinLifetime<?)";
        String delvol = "DELETE FROM volatile WHERE ID IN ";
        String deljit = "DELETE FROM jit WHERE ID IN ";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.con.prepareStatement(vol);
            this.logWarnings(this.con.getWarnings());
            stmt.setLong(1, time);
            this.logWarnings(stmt.getWarnings());
            log.debug("VolatileAndJiTDAO. removeExpired: " + stmt.toString());
            rs = stmt.executeQuery();
            this.logWarnings(stmt.getWarnings());
            ArrayList<String> volat = new ArrayList<String>();
            ArrayList<Long> volatid = new ArrayList<Long>();
            while (rs.next()) {
                volatid.add(new Long(rs.getLong("ID")));
                volat.add(rs.getString("file"));
            }
            int nvolat = volatid.size();
            this.close(rs);
            this.close(stmt);
            if (nvolat > 0) {
                jit = jit + " OR file IN " + this.makeFileString(volat);
            }
            stmt = this.con.prepareStatement(jit);
            this.logWarnings(this.con.getWarnings());
            stmt.setLong(1, time);
            this.logWarnings(stmt.getWarnings());
            log.debug("VolatileAndJiTDAO. removeExpired: " + stmt.toString());
            rs = stmt.executeQuery();
            this.logWarnings(stmt.getWarnings());
            ArrayList<JiTData> track = new ArrayList<JiTData>();
            ArrayList<Long> trackid = new ArrayList<Long>();
            JiTData aux = null;
            while (rs.next()) {
                trackid.add(new Long(rs.getLong("ID")));
                aux = new JiTData(rs.getString("file"), rs.getInt("acl"), rs.getInt("uid"), rs.getInt("gid"));
                track.add(aux);
            }
            int njit = trackid.size();
            this.close(rs);
            this.close(stmt);
            ArrayList volcol = new ArrayList();
            ArrayList jitcol = new ArrayList();
            try {
                this.con.setAutoCommit(false);
                this.logWarnings(this.con.getWarnings());
                int deletedvol = 0;
                if (nvolat > 0) {
                    delvol = delvol + this.makeIDString(volatid);
                    stmt = this.con.prepareStatement(delvol);
                    this.logWarnings(this.con.getWarnings());
                    log.debug("VolatileAndJiTDAO. removeExpired: " + stmt.toString());
                    deletedvol = stmt.executeUpdate();
                    this.logWarnings(stmt.getWarnings());
                    this.close(stmt);
                }
                int deletedjit = 0;
                if (njit > 0) {
                    deljit = deljit + this.makeIDString(trackid);
                    stmt = this.con.prepareStatement(deljit);
                    this.logWarnings(this.con.getWarnings());
                    log.debug("VolatileAndJiTDAO. removeExpired: " + stmt.toString());
                    deletedjit = stmt.executeUpdate();
                    this.logWarnings(stmt.getWarnings());
                    this.close(stmt);
                }
                this.con.commit();
                this.logWarnings(this.con.getWarnings());
                this.con.setAutoCommit(true);
                this.logWarnings(this.con.getWarnings());
                log.debug("VolatileAndJiTDAO. Removed " + deletedvol + " volatile catalogue entries and " + deletedjit + " jit catalogue entries.");
                volcol = volat;
                jitcol = track;
            }
            catch (SQLException e) {
                log.error("VolatileAndJiTDAO! Unable to complete removeExpired... rolling back! " + e);
                this.rollback(this.con);
                this.close(stmt);
            }
            return new Collection[]{volcol, jitcol};
        }
        catch (SQLException e) {
            this.close(rs);
            this.close(stmt);
            log.error("VolatileAndJiTDAO! Unable to complete removeExpired! " + e);
            return new Collection[]{new ArrayList(), new ArrayList()};
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeVolatile(String filename) {
        if (!this.checkConnection()) {
            log.error("VolatileAndJiTDAO. removeVolatile:  unable to get a valid connection!");
            return;
        }
        String sql = "DELETE FROM volatile WHERE file=?";
        PreparedStatement stmt = null;
        try {
            stmt = this.con.prepareStatement(sql);
            this.logWarnings(this.con.getWarnings());
            stmt.setString(1, filename);
            this.logWarnings(stmt.getWarnings());
            log.debug("VolatileAndJiTDAO. removeVolatile: " + stmt.toString());
            int n = stmt.executeUpdate();
            log.debug("VolatileAndJiTDAO. removeVolatile: " + n + " entries removed.");
        }
        catch (SQLException e) {
            log.error("VolatileAndJiTDAO! Error in removeVolatile: " + e);
        }
        finally {
            this.close(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateJiT(String filename, int uid, int acl, long start, long pinLifetime) {
        if (!this.checkConnection()) {
            log.error("VolatileAndJiTDAO. updateJiT:  unable to get a valid connection!");
            return;
        }
        String sql = "UPDATE jit SET start=FROM_UNIXTIME(?), pinLifetime=? WHERE file=? AND uid=? AND acl=? AND (UNIX_TIMESTAMP(start)+pinLifetime<?)";
        PreparedStatement stmt = null;
        try {
            stmt = this.con.prepareStatement(sql);
            this.logWarnings(this.con.getWarnings());
            stmt.setLong(1, start);
            this.logWarnings(stmt.getWarnings());
            stmt.setLong(2, pinLifetime);
            this.logWarnings(stmt.getWarnings());
            stmt.setString(3, filename);
            this.logWarnings(stmt.getWarnings());
            stmt.setInt(4, uid);
            this.logWarnings(stmt.getWarnings());
            stmt.setInt(5, acl);
            this.logWarnings(stmt.getWarnings());
            stmt.setLong(6, start + pinLifetime);
            this.logWarnings(stmt.getWarnings());
            log.debug("VolatileAndJiTDAO. updateJiT: " + stmt.toString());
            int n = stmt.executeUpdate();
            log.debug("VolatileAndJiTDAO. " + n + " jit entries updated.");
        }
        catch (SQLException e) {
            log.error("VolatileAndJiTDAO! Error in updateJiT: " + e);
        }
        finally {
            this.close(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateVolatile(String filename, long start, long fileLifetime) {
        if (!this.checkConnection()) {
            log.error("VolatileAndJiTDAO. updateVolatile:  unable to get a valid connection!");
            return;
        }
        String sql = "UPDATE volatile SET file=?, start=FROM_UNIXTIME(?), fileLifetime=? WHERE file=? AND (UNIX_TIMESTAMP(start)+fileLifetime<?)";
        PreparedStatement stmt = null;
        try {
            stmt = this.con.prepareStatement(sql);
            this.logWarnings(this.con.getWarnings());
            stmt.setString(1, filename);
            this.logWarnings(stmt.getWarnings());
            stmt.setLong(2, start);
            this.logWarnings(stmt.getWarnings());
            stmt.setLong(3, fileLifetime);
            this.logWarnings(stmt.getWarnings());
            stmt.setString(4, filename);
            this.logWarnings(stmt.getWarnings());
            stmt.setLong(5, start + fileLifetime);
            this.logWarnings(stmt.getWarnings());
            log.debug("VolatileAndJiTDAO. updateVolatile: " + stmt.toString());
            int n = stmt.executeUpdate();
            log.debug("VolatileAndJiTDAO. " + n + " volatile entries updated.");
        }
        catch (SQLException e) {
            log.error("VolatileAndJiTDAO! Error in updateVolatile: " + e);
        }
        finally {
            this.close(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateVolatile(String fileName, long fileStart) {
        if (!this.checkConnection()) {
            log.error("VolatileAndJiTDAO. updateVolatile:  unable to get a valid connection!");
            return;
        }
        String sql = "UPDATE volatile SET start=FROM_UNIXTIME(?) WHERE file=?";
        PreparedStatement stmt = null;
        try {
            stmt = this.con.prepareStatement(sql);
            this.logWarnings(this.con.getWarnings());
            stmt.setLong(1, fileStart);
            this.logWarnings(stmt.getWarnings());
            stmt.setString(2, fileName);
            this.logWarnings(stmt.getWarnings());
            log.debug("VolatileAndJiTDAO. updateVolatile: " + stmt.toString());
            int n = stmt.executeUpdate();
            log.debug("VolatileAndJiTDAO. " + n + " volatile entries updated.");
        }
        catch (SQLException e) {
            log.error("VolatileAndJiTDAO! Error in updateVolatile: " + e);
        }
        finally {
            this.close(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Long> volatileInfoOn(String filename) {
        if (!this.checkConnection()) {
            log.error("VolatileAndJiTDAO. volatileInfoOn:  unable to get a valid connection!");
            return new ArrayList<Long>();
        }
        String sql = "SELECT UNIX_TIMESTAMP(start), fileLifetime FROM volatile WHERE file=?";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<Long> aux = new ArrayList<Long>();
        try {
            stmt = this.con.prepareStatement(sql);
            this.logWarnings(this.con.getWarnings());
            stmt.setString(1, filename);
            this.logWarnings(stmt.getWarnings());
            log.debug("VolatileAndJiTDAO - infoOnVolatile - " + stmt.toString());
            rs = stmt.executeQuery();
            this.logWarnings(stmt.getWarnings());
            if (rs.next()) {
                aux.add(new Long(rs.getLong("UNIX_TIMESTAMP(start)")));
                aux.add(new Long(rs.getLong("fileLifetime")));
            } else {
                log.debug("VolatileAndJiTDAO! infoOnVolatile did not find " + filename);
            }
            this.close(rs);
            this.close(stmt);
        }
        catch (SQLException e) {
            log.error("VolatileAndJiTDAO! Error in infoOnVolatile: " + e);
        }
        finally {
            this.close(rs);
            this.close(stmt);
        }
        return aux;
    }

    private boolean checkConnection() {
        boolean response = true;
        if (this.reconnect) {
            log.debug("VolatileAndJiTDAO: reconnecting to DB. ");
            this.takeDownConnection();
            response = this.setUpConnection();
            if (response) {
                this.reconnect = false;
            }
        }
        return response;
    }

    private void close(ResultSet rset) {
        if (rset != null) {
            try {
                rset.close();
            }
            catch (Exception e) {
                log.error("VolatileAndJiTDAO! Unable to close ResultSet - Exception: " + e);
            }
        }
    }

    private void close(Statement stmt) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (Exception e) {
                log.error("VolatileAndJiTDAO! Unable to close Statement " + stmt.toString() + " - Exception: " + e);
            }
        }
    }

    private void logWarnings(SQLWarning warning) {
        if (warning != null) {
            log.debug("VolatileAndJiTDAO: " + warning.toString());
            while ((warning = warning.getNextWarning()) != null) {
                log.debug("VolatileAndJiTDAO: " + warning.toString());
            }
        }
    }

    private String makeFileString(Collection files) {
        StringBuffer sb = new StringBuffer("(");
        Iterator i = files.iterator();
        while (i.hasNext()) {
            sb.append("'");
            sb.append((String)i.next());
            sb.append("'");
            if (!i.hasNext()) continue;
            sb.append(",");
        }
        sb.append(")");
        return sb.toString();
    }

    private String makeIDString(Collection rowids) {
        StringBuffer sb = new StringBuffer("(");
        Iterator i = rowids.iterator();
        while (i.hasNext()) {
            sb.append(i.next());
            if (!i.hasNext()) continue;
            sb.append(",");
        }
        sb.append(")");
        return sb.toString();
    }

    private void rollback(Connection con) {
        if (con != null) {
            try {
                con.rollback();
                this.logWarnings(con.getWarnings());
                log.error("VolatileAndJiTDAO! Roll back successful!");
            }
            catch (SQLException e3) {
                log.error("VolatileAndJiTDAO! Roll back failed! " + e3);
            }
        }
    }

    private boolean setUpConnection() {
        boolean response = false;
        try {
            Class.forName(this.driver);
            this.con = DriverManager.getConnection(this.url, this.name, this.password);
            if (this.con == null) {
                log.error("VolatileAndJiTDAO! DriverManager returned a null Connection!");
            } else {
                response = this.con.isValid(0);
                this.logWarnings(this.con.getWarnings());
            }
        }
        catch (ClassNotFoundException e) {
            log.error("VolatileAndJiTDAO! Exception in setUpconnection! " + e);
        }
        catch (SQLException e) {
            log.error("VolatileAndJiTDAO! Exception in setUpConnection! " + e);
        }
        catch (Exception e) {
            log.error("VolatileAndJiTDAO! Exception in setUpConnection! " + e);
        }
        return response;
    }

    private void takeDownConnection() {
        if (this.con != null) {
            try {
                this.con.close();
            }
            catch (Exception e) {
                log.error("VolatileAndJiTDAO! Exception in takeDownConnection! " + e);
            }
        }
    }
}

