/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.catalogs;

import it.grid.storm.acl.AclManager;
import it.grid.storm.acl.AclManagerFSAndHTTPS;
import it.grid.storm.catalogs.JiTData;
import it.grid.storm.catalogs.VolatileAndJiTDAO;
import it.grid.storm.common.types.PFN;
import it.grid.storm.common.types.TimeUnit;
import it.grid.storm.config.Configuration;
import it.grid.storm.filesystem.FilesystemPermission;
import it.grid.storm.filesystem.LocalFile;
import it.grid.storm.griduser.LocalUser;
import it.grid.storm.namespace.NamespaceDirector;
import it.grid.storm.srm.types.TLifeTimeInSeconds;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VolatileAndJiTCatalog {
    private static final Logger log = LoggerFactory.getLogger(VolatileAndJiTCatalog.class);
    private static final VolatileAndJiTCatalog cat = new VolatileAndJiTCatalog();
    private static final VolatileAndJiTDAO dao = VolatileAndJiTDAO.getInstance();
    private final Timer cleaner = new Timer();
    private final long delay = Configuration.getInstance().getCleaningInitialDelay() * 1000L;
    private final long period = Configuration.getInstance().getCleaningTimeInterval() * 1000L;
    private final long defaultFileLifetime = Configuration.getInstance().getFileLifetimeDefault();
    private final long floor = Configuration.getInstance().getPinLifetimeDefault();
    private final long ceiling = Configuration.getInstance().getPinLifetimeMaximum();

    private VolatileAndJiTCatalog() {
        TimerTask cleaningTask = new TimerTask(){

            @Override
            public void run() {
                VolatileAndJiTCatalog.this.purge();
            }
        };
        this.cleaner.scheduleAtFixedRate(cleaningTask, this.delay, this.period);
    }

    public static VolatileAndJiTCatalog getInstance() {
        return cat;
    }

    public synchronized boolean exists(PFN pfn) {
        return dao.exists(pfn.getValue());
    }

    public synchronized boolean expireGetJiTs(PFN pfn, LocalUser localUser) {
        boolean ok;
        boolean bl = ok = pfn != null && localUser != null;
        if (!ok) {
            log.error("VolatileAndJiT CATALOG: programming bug! expireGetJiTs invoked on null attributes; pfn=" + pfn + " localUser=" + localUser);
            return false;
        }
        boolean result = true;
        result = result && this.expireJiT(pfn, localUser, FilesystemPermission.Read);
        return result;
    }

    public synchronized boolean expireJiT(PFN pfn, LocalUser localUser, FilesystemPermission acl) {
        boolean ok;
        boolean bl = ok = pfn != null && localUser != null && acl != null;
        if (!ok) {
            log.error("VolatileAndJiT CATALOG: programming bug! expireJiT invoked on null attributes; pfn=" + pfn + " localUser=" + localUser + " acl=" + acl);
            return false;
        }
        String fileName = pfn.getValue();
        int uid = localUser.getUid();
        int intacl = acl.getInt();
        long pinStart = Calendar.getInstance().getTimeInMillis() / 1000L - 10L;
        long pinTime = 0L;
        int n = dao.numberJiT(fileName, uid, intacl);
        if (n == 0) {
            log.warn("VolatileAndJiT CATALOG: expireJiT found no entry for (" + fileName + "," + uid + "," + intacl + ")!");
            return false;
        }
        dao.forceUpdateJiT(fileName, uid, intacl, pinStart, pinTime);
        if (n > 1) {
            log.warn("VolatileAndJiT CATALOG: expireJiT found more than one entry for (" + fileName + "," + uid + "," + intacl + "); the catalogue could be corrupt!");
        }
        return true;
    }

    public synchronized boolean expirePutJiTs(PFN pfn, LocalUser localUser) {
        boolean ok;
        boolean bl = ok = pfn != null && localUser != null;
        if (!ok) {
            log.error("VolatileAndJiT CATALOG: programming bug! expirePutJiTs invoked on null attributes; pfn=" + pfn + " localUser=" + localUser);
            return false;
        }
        boolean result = true;
        result = result && this.expireJiT(pfn, localUser, FilesystemPermission.Read);
        result = result && this.expireJiT(pfn, localUser, FilesystemPermission.Write);
        return result;
    }

    public synchronized void purge() {
        log.debug("VolatileAndJiT CATALOG! Executing purge!");
        Calendar rightNow = Calendar.getInstance();
        Collection[] expired = dao.removeExpired(rightNow.getTimeInMillis() / 1000L);
        Collection expiredVolatile = expired[0];
        Collection expiredJiT = expired[1];
        if (expiredVolatile.size() == 0) {
            log.debug("VolatileAndJiT CATALOG! No expired Volatile entries found.");
        } else {
            log.info("VolatileAndJiT CATALOG! Found and purged the following expired Volatile entries:\n " + this.volatileString(expired[0]));
        }
        if (expiredJiT.size() == 0) {
            log.debug("VolatileAndJiT CATALOG! No JiT entries found.");
        } else {
            log.info("VolatileAndJiT CATALOG! Found and purged the following expired JiT ACLs entries:\n " + this.jitString(expired[1]));
        }
        JiTData aux2 = null;
        for (JiTData aux2 : expiredJiT) {
            int jitacl = aux2.acl();
            String jitfile = aux2.pfn();
            int jituid = aux2.uid();
            int jitgid = aux2.gid();
            try {
                log.info("VolatileAndJiT CATALOG. Removing ACL " + jitacl + " on file " + jitfile + " for user " + jituid + "," + jitgid);
                LocalFile auxFile = NamespaceDirector.getNamespace().resolveStoRIbyPFN(PFN.make(jitfile)).getLocalFile();
                LocalUser auxUser = new LocalUser(jituid, jitgid);
                FilesystemPermission auxACL = new FilesystemPermission(jitacl);
                AclManager manager = AclManagerFSAndHTTPS.getInstance();
                if (auxFile == null) {
                    log.warn("VolatileAndJiT CATALOG! Unable to setting up the ACL. LocalFile is null!");
                    continue;
                }
                try {
                    manager.revokeUserPermission(auxFile, auxUser, auxACL);
                }
                catch (IllegalArgumentException e) {
                    log.error("Unable to revoke user permissions on the file. IllegalArgumentException: " + e.getMessage());
                }
            }
            catch (Exception e) {
                log.error("VolatileAndJiT CATALOG! Entry removed from Catalog, but physical ACL " + jitacl + " for user " + jituid + "," + jitgid + " could NOT be removed from " + jitfile);
                log.error("VolatileAndJiT CATALOG! " + e);
            }
        }
        String auxPFN2 = null;
        for (String auxPFN2 : expiredVolatile) {
            try {
                log.info("VolatileAndJiT CATALOG. Deleting file " + auxPFN2);
                LocalFile auxFile = NamespaceDirector.getNamespace().resolveStoRIbyPFN(PFN.make(auxPFN2)).getLocalFile();
                boolean ok = auxFile.delete();
                if (ok) continue;
                throw new Exception("Java File deletion failed!");
            }
            catch (Exception e) {
                log.error("VolatileAndJiT CATALOG! Entry removed from Catalog, but physical file " + auxPFN2 + " could NOT be deleted!");
                log.error("VolatileAndJiT CATALOG! " + e);
            }
        }
    }

    public synchronized void removeAllJiTsOn(PFN pfn) {
        boolean ok;
        boolean bl = ok = pfn != null;
        if (!ok) {
            log.error("VolatileAndJiT CATALOG: programming bug! removeAllJiTsOn invoked on null pfn!");
        } else {
            String fileName = pfn.getValue();
            dao.removeAllJiTsOn(fileName);
        }
    }

    public synchronized void removeVolatile(PFN pfn) {
        boolean ok;
        boolean bl = ok = pfn != null;
        if (!ok) {
            log.warn("VolatileAndJiT CATALOG: programming bug! removeVolatile invoked on null pfn!");
        } else {
            dao.removeVolatile(pfn.getValue());
        }
    }

    public synchronized void trackJiT(PFN pfn, LocalUser localUser, FilesystemPermission acl, Calendar start, TLifeTimeInSeconds pinLifetime) {
        boolean ok;
        boolean bl = ok = pfn != null && localUser != null && acl != null && start != null && pinLifetime != null;
        if (!ok) {
            log.error("VolatileAndJiT CATALOG: programming bug! TrackACL invoked on null attributes; pfn=" + pfn + " localUser=" + localUser + " acl=" + acl + " start=" + start + " pinLifetime=" + pinLifetime);
        } else {
            String fileName = pfn.getValue();
            int uid = localUser.getUid();
            int gid = localUser.getPrimaryGid();
            int intacl = acl.getInt();
            long pinStart = start.getTimeInMillis() / 1000L;
            long pinTime = this.validatePinLifetime(pinLifetime.value());
            int n = dao.numberJiT(fileName, uid, intacl);
            if (n == 0) {
                dao.addJiT(fileName, uid, gid, intacl, pinStart, pinTime);
            } else {
                dao.updateJiT(fileName, uid, intacl, pinStart, pinTime);
                if (n > 1) {
                    log.warn("VolatileAndJiT CATALOG: More than one entry found for (" + fileName + "," + uid + "," + intacl + "); the catalogue could be corrupt!");
                }
            }
        }
    }

    public synchronized void trackVolatile(PFN pfn, Calendar start, TLifeTimeInSeconds fileLifetime) {
        boolean ok;
        boolean bl = ok = pfn != null && fileLifetime != null && start != null;
        if (!ok) {
            log.warn("VolatileAndJiT CATALOG: programming bug! volatileEntry invoked on null attributes; pfn=" + pfn + " start=" + start + " fileLifetime=" + fileLifetime);
        } else {
            String fileName = pfn.getValue();
            long fileTime = fileLifetime.value();
            if (fileTime <= 0L) {
                fileTime = this.defaultFileLifetime;
            }
            long fileStart = start.getTimeInMillis() / 1000L;
            int n = dao.numberVolatile(fileName);
            if (n == -1) {
                log.error("VolatileAndJiT CATALOG! DB problem does not allow to count number of Volatile entries for " + pfn + "! Volatile entry NOT processed!");
            } else if (n == 0) {
                dao.addVolatile(fileName, fileStart, fileTime);
            } else {
                dao.updateVolatile(fileName, fileStart, fileTime);
                if (n > 1) {
                    log.warn("VolatileAndJiT CATALOG: More than one entry found for " + fileName + "; the catalogue could be corrupt!");
                }
            }
        }
    }

    public synchronized void setStartTime(PFN pfn, Calendar start) throws Exception {
        if (pfn == null || start == null) {
            log.warn("VolatileAndJiT CATALOG: programming bug! volatileEntry invoked on null attributes; pfn=" + pfn + " start=" + start);
        } else {
            String fileName = pfn.getValue();
            long fileStart = start.getTimeInMillis() / 1000L;
            int n = dao.numberVolatile(fileName);
            if (n == -1) {
                log.error("VolatileAndJiT CATALOG! DB problem does not allow to count number of Volatile entries for " + pfn + "! Volatile entry NOT processed!");
            } else {
                if (n == 0) {
                    throw new Exception("Unable to update row volatile for pfn '" + pfn + "' , not on the database!");
                }
                dao.updateVolatile(fileName, fileStart);
                if (n > 1) {
                    log.warn("VolatileAndJiT CATALOG: More than one entry found for " + fileName + "; the catalogue could be corrupt!");
                }
            }
        }
    }

    public synchronized List volatileInfoOn(PFN pfn) {
        boolean ok = pfn != null;
        ArrayList<Serializable> aux = new ArrayList<Serializable>();
        if (!ok) {
            log.error("VolatileAndJiT CATALOG: programming bug! volatileInfoOn invoked on null PFN!");
            return aux;
        }
        List<Long> c = dao.volatileInfoOn(pfn.getValue());
        if (c.size() == 2) {
            Iterator i = c.iterator();
            long startInMillis = (Long)i.next() * 1000L;
            Calendar auxcal = Calendar.getInstance();
            auxcal.setTimeInMillis(startInMillis);
            aux.add(auxcal);
            long lifetimeInSeconds = (Long)i.next();
            TLifeTimeInSeconds auxLifeTime = TLifeTimeInSeconds.makeEmpty();
            try {
                auxLifeTime = TLifeTimeInSeconds.make(lifetimeInSeconds, TimeUnit.SECONDS);
            }
            catch (IllegalArgumentException e) {
                log.error("VolatileAndJiT CATALOG: programming bug! Retrieved long does not allow TLifeTimeCreation! long is: " + lifetimeInSeconds + "; exception is: " + e);
            }
            aux.add(auxLifeTime);
        }
        return aux;
    }

    private String jitString(Collection<JiTData> c) {
        if (c == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("file,acl,uid,gid\n");
        JiTData aux = null;
        Iterator<JiTData> i = c.iterator();
        while (i.hasNext()) {
            aux = i.next();
            sb.append(aux.pfn());
            sb.append(",");
            sb.append(aux.acl());
            sb.append(",");
            sb.append(aux.uid());
            sb.append(",");
            sb.append(aux.gid());
            if (!i.hasNext()) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    private long validatePinLifetime(long lifetime) {
        long duration = lifetime < this.floor ? this.floor : lifetime;
        duration = duration <= this.ceiling ? duration : this.ceiling;
        return duration;
    }

    private String volatileString(Collection<String> c) {
        if (c == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        Iterator<String> i = c.iterator();
        while (i.hasNext()) {
            sb.append(i.next());
            if (!i.hasNext()) continue;
            sb.append(",");
        }
        return sb.toString();
    }
}

